/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.RecoverableException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGrantProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberProxyGeneric;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.util.PathVector;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class SelectCmd
extends Node {
    private String selectCmd;
    private WithHash with;
    private Vector sv;
    private int[] clist;
    private int[] ctype;
    private int[] cquote;
    private int cl_size;
    public static final int CATEGORYTYPE = 295;
    public static final int FOLDERTYPE = 380;
    public static final int JOBTYPE = 419;
    public static final int RESOURCETYPE = 533;
    public static final int SCOPETYPE = 557;
    public static final int SCHEDULETYPE = 555;

    public SelectCmd(String string) {
        this.selectCmd = string;
        this.with = null;
        this.cl_size = 0;
        this.sv = null;
        this.txMode = 1;
    }

    public SelectCmd(String string, WithHash withHash) {
        this.selectCmd = string;
        this.with = withHash;
        if (withHash != null) {
            this.cl_size = withHash.size();
            this.sv = (Vector)withHash.get("%%SORT%%");
            if (this.sv != null) {
                --this.cl_size;
            }
        } else {
            this.cl_size = 0;
            this.sv = null;
        }
        this.txMode = 1;
    }

    private Vector collist(ResultSetMetaData resultSetMetaData) throws SQLException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            String string = resultSetMetaData.getColumnName(i).toUpperCase();
            if (this.cl_size > 0 && this.with.get(string) != null) {
                Integer n2 = (Integer)this.with.get(string);
                this.clist[n] = i;
                this.ctype[n] = Math.abs(n2);
                this.cquote[n] = n2 > 0 ? 1 : -1;
                ++n;
            }
            vector.addElement(string);
        }
        this.cl_size = n;
        this.sort();
        return vector;
    }

    private void sort() {
        for (int i = 0; i < this.cl_size - 1; ++i) {
            for (int j = i + 1; j < this.cl_size; ++j) {
                if (this.clist[i] <= this.clist[j]) continue;
                int n = this.clist[i];
                this.clist[i] = this.clist[j];
                this.clist[j] = n;
                n = this.ctype[i];
                this.ctype[i] = this.ctype[j];
                this.ctype[j] = n;
            }
        }
    }

    private Long objectToId(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        Long l;
        if (object instanceof Integer) {
            l = new Long(((Integer)object).intValue());
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof BigDecimal) {
            l = new Long(((BigDecimal)object).intValue());
        } else {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204250147", "Type Error, Column is not an Id but a $1", (Object)object.getClass().getName()));
        }
        return l;
    }

    private PathVector convert_folder(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        SDMSFolder sDMSFolder;
        Long l = this.objectToId(systemEnvironment, object);
        try {
            sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
        }
        catch (NotFoundException notFoundException) {
            return this.convert_job_raw(systemEnvironment, l);
        }
        return sDMSFolder.pathVector(systemEnvironment);
    }

    private PathVector convert_folder_raw(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l);
        return sDMSFolder.pathVector(systemEnvironment);
    }

    private PathVector convert_scope(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, this.objectToId(systemEnvironment, object));
        return sDMSScope.pathVector(systemEnvironment);
    }

    private PathVector convert_job(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity;
        Long l = this.objectToId(systemEnvironment, object);
        try {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        }
        catch (NotFoundException notFoundException) {
            return this.convert_folder_raw(systemEnvironment, l);
        }
        return sDMSSchedulingEntity.pathVector(systemEnvironment);
    }

    private PathVector convert_job_raw(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        return sDMSSchedulingEntity.pathVector(systemEnvironment);
    }

    private PathVector convert_category(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.objectToId(systemEnvironment, object));
        return sDMSNamedResource.pathVector(systemEnvironment);
    }

    private PathVector convert_schedule(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, this.objectToId(systemEnvironment, object));
        return sDMSSchedule.pathVector(systemEnvironment);
    }

    private String convert(SystemEnvironment systemEnvironment, Object object, int n) throws SDMSException {
        PathVector pathVector = null;
        int n2 = this.cquote[n];
        if (object == null) {
            return null;
        }
        try {
            switch (this.ctype[n]) {
                case 295: {
                    pathVector = this.convert_category(systemEnvironment, object);
                    break;
                }
                case 380: {
                    pathVector = this.convert_folder(systemEnvironment, object);
                    break;
                }
                case 419: {
                    pathVector = this.convert_job(systemEnvironment, object);
                    break;
                }
                case 533: {
                    pathVector = this.convert_category(systemEnvironment, object);
                    break;
                }
                case 555: {
                    pathVector = this.convert_schedule(systemEnvironment, object);
                    break;
                }
                case 557: {
                    pathVector = this.convert_scope(systemEnvironment, object);
                }
            }
        }
        catch (NotFoundException notFoundException) {
            notFoundException.printStackTrace();
            pathVector = null;
        }
        if (pathVector != null) {
            if (n2 < 0) {
                return pathVector.toQuotedString(null);
            }
            return pathVector.toString();
        }
        return null;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Long l = null;
        Long l2 = new Long(0L);
        if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
            serializable = SDMSMemberTable.idx_uId.getVector(systemEnvironment, systemEnvironment.cEnv.uid());
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                object3 = (SDMSMember)((Vector)serializable).get(i);
                try {
                    object2 = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(l2, ((SDMSMemberProxyGeneric)object3).getGId(systemEnvironment)));
                    sDMSPrivilege.addPriv(systemEnvironment, ((SDMSGrantProxyGeneric)object2).getPrivs(systemEnvironment));
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            try {
                if (SystemEnvironment.selectGroup != null) {
                    SDMSGroup sDMSGroup = SDMSGroupTable.idx_name_getUnique(systemEnvironment, SystemEnvironment.selectGroup);
                    l = sDMSGroup.getId(systemEnvironment);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (!(sDMSPrivilege.can(0x400000000000L) || l != null && systemEnvironment.cEnv.gid().contains(l))) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03003081235", "Insufficient Privileges"));
            }
        }
        int n = 0;
        serializable = null;
        if (this.cl_size > 0) {
            this.clist = new int[this.cl_size];
            this.ctype = new int[this.cl_size];
            this.cquote = new int[this.cl_size];
        }
        try {
            object = systemEnvironment.dbConnection.createStatement();
            object3 = object.executeQuery(this.selectCmd);
            object2 = object3.getMetaData();
            Vector vector = this.collist((ResultSetMetaData)object2);
            serializable = new SDMSOutputContainer(systemEnvironment, "Selected Values", vector);
            while (object3.next()) {
                Vector<Object> vector2 = new Vector<Object>();
                int n2 = 0;
                for (int i = 1; i <= vector.size(); ++i) {
                    Object object4 = object3.getObject(i);
                    if (this.cl_size > 0 && n2 < this.cl_size && i == this.clist[n2]) {
                        object4 = this.convert(systemEnvironment, object4, n2);
                        ++n2;
                    }
                    vector2.addElement(object3.wasNull() ? null : object4);
                }
                ((SDMSOutputContainer)serializable).addData(systemEnvironment, vector2);
                ++n;
            }
            object.close();
            systemEnvironment.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            try {
                systemEnvironment.dbConnection.rollback();
            }
            catch (SQLException sQLException2) {
                throw new RecoverableException(new SDMSMessage(systemEnvironment, "03310281524", "Connection lost"));
            }
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204170024", "SQL Error : $1", (Object)sQLException.toString()));
        }
        if (this.sv != null && this.sv.size() > 0) {
            object = new int[this.sv.size()];
            for (int i = 0; i < this.sv.size(); ++i) {
                object[i] = (Integer)this.sv.get(i);
                if (object[i] < ((SDMSOutputContainer)serializable).columns) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03003081227", "The sort column specified ($1) exceeds the number of columns in the output", (Object)new Integer((int)object[i])));
            }
            Collections.sort(((SDMSOutputContainer)serializable).dataset, ((SDMSOutputContainer)serializable).getComparator(systemEnvironment, (int[])object));
        }
        this.result.setOutputContainer((SDMSOutputContainer)serializable);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112153", "$1 Row(s) selected", (Object)new Integer(n)));
    }
}

