/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Connect;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Date;
import java.util.Vector;

public class SetParameter
extends Node {
    public static final String __version = "@(#) $Id: SetParameter.java,v 2.4.14.1 2013/03/14 10:24:48 ronald Exp $";
    private WithHash parms;
    private Long jobid;
    private String key;
    private String auditComment;

    public SetParameter(WithHash withHash) {
        this.cmdtype = 4;
        this.parms = withHash;
        this.jobid = null;
        this.auditComment = null;
    }

    public SetParameter(WithHash withHash, Long l, String string, WithHash withHash2) {
        this.cmdtype = 1;
        this.parms = withHash;
        this.jobid = l;
        this.key = string;
        this.auditComment = withHash2 == null ? null : (String)withHash2.get("COMMENT");
    }

    private void writeAudit(SystemEnvironment systemEnvironment, Long l, String string, String string2) throws SDMSException {
        Date date = new Date();
        Long l2 = new Long(date.getTime());
        SDMSAuditTrailTable.table.create(systemEnvironment, systemEnvironment.cEnv.uid(), l2, new Integer(29), new Integer(17), l, l, Boolean.FALSE, string2, string);
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.jobid == null) {
            this.jobid = systemEnvironment.cEnv.uid();
        }
        if (this.key != null) {
            Connect.validateJobConnect(systemEnvironment, this.jobid, this.key, true);
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.jobid);
        Vector vector = new Vector(this.parms.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Vector vector2 = (Vector)this.parms.get(string);
            String string2 = (String)vector2.get(1);
            sDMSSubmittedEntity.setVariableValue(systemEnvironment, string, string2);
            if (this.auditComment == null) continue;
            this.writeAudit(systemEnvironment, this.jobid, "Parameter '" + string + "' set to '" + string2 + "'", this.auditComment);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206060017", "Parameter set"));
    }
}

