/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowGroup
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowGroup.java,v 2.9.4.2 2013/06/18 09:49:36 ronald Exp $";
    private static final Long ZERO = new Long(0L);
    private static final String USR = "user";
    private static final String GRP = "group";
    private static final String ESD = "exit state definition";
    private static final String ESP = "exit state profile";
    private static final String ESM = "exit state mapping";
    private static final String EST = "exit state translation";
    private static final String RSD = "resource state definition";
    private static final String RSP = "resource state profile";
    private static final String RSM = "resource state mapping";
    private static final String FPR = "footprint";
    private static final String ENV = "environment";
    private static final String SYS = "system";
    private static final String NP = "nice profile";
    private static final String WT = "watch type";
    private static final String SEL = "select";
    private ObjectURL url;

    public ShowGroup(ObjectURL objectURL) {
        this.url = objectURL;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSGroup sDMSGroup = (SDMSGroup)this.url.resolve(systemEnvironment);
        if (sDMSGroup.getDeleteVersion(systemEnvironment) > 0L) {
            throw new NotFoundException("Group " + sDMSGroup.getName(systemEnvironment) + " not found");
        }
        if (!sDMSGroup.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411717", "Insufficient privileges"));
        }
        Long l = sDMSGroup.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENTTYPE");
        vector.add("COMMENT");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("MANAGE_PRIVS");
        vector.add("USERS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSGroup.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSGroup.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSGroup.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSGroup.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSGroup.getPrivileges(systemEnvironment).toString());
        vector2.add(this.getManageList(systemEnvironment, l));
        vector2.add(this.getUserList(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Group", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312091452", "Group shown"));
    }

    private SDMSOutputContainer getUserList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("UID");
        vector.add("NAME");
        vector.add("IS_ENABLED");
        vector.add("DEFAULT_GROUP");
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Users", vector);
        Vector vector2 = SDMSMemberTable.idx_gId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSMember sDMSMember = (SDMSMember)vector2.get(i);
            SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, sDMSMember.getUId(systemEnvironment));
            if (sDMSUser.getName(systemEnvironment).equals("NOBODY")) continue;
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSMember.getId(systemEnvironment));
            vector3.add(sDMSUser.getId(systemEnvironment));
            vector3.add(sDMSUser.getName(systemEnvironment));
            vector3.add(sDMSUser.getIsEnabled(systemEnvironment));
            vector3.add(SDMSGroupTable.getObject(systemEnvironment, sDMSUser.getDefaultGId(systemEnvironment)).getName(systemEnvironment));
            vector3.add(sDMSUser.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getManageList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>(2);
        vector.add("PRIVS");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "MANAGE_PRIVS", vector);
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        try {
            SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(ZERO, l));
            sDMSPrivilege.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        long l2 = sDMSPrivilege.toLong();
        if ((0xFFFC00000000L & l2) != 0L) {
            Vector<String> vector2 = new Vector<String>();
            if ((0x400000000L & l2) == 0x400000000L) {
                vector2.add(USR);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x800000000L & l2) == 0x800000000L) {
                vector2.add(GRP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x1000000000L & l2) == 0x1000000000L) {
                vector2.add(ESD);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x2000000000L & l2) == 0x2000000000L) {
                vector2.add(ESP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x4000000000L & l2) == 0x4000000000L) {
                vector2.add(ESM);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x8000000000L & l2) == 0x8000000000L) {
                vector2.add(EST);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x10000000000L & l2) == 0x10000000000L) {
                vector2.add(RSD);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x20000000000L & l2) == 0x20000000000L) {
                vector2.add(RSP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x40000000000L & l2) == 0x40000000000L) {
                vector2.add(RSM);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x80000000000L & l2) == 0x80000000000L) {
                vector2.add(FPR);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x1000000000000L & l2) == 0x1000000000000L) {
                vector2.add(WT);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x100000000000L & l2) == 0x100000000000L) {
                vector2.add(ENV);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x200000000000L & l2) == 0x200000000000L) {
                vector2.add(SYS);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x800000000000L & l2) == 0x800000000000L) {
                vector2.add(NP);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
                vector2 = new Vector();
            }
            if ((0x400000000000L & l2) == 0x400000000000L) {
                vector2.add(SEL);
                sDMSOutputContainer.addData(systemEnvironment, vector2);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 0));
        return sDMSOutputContainer;
    }
}

