/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowRsp
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowRsp.java,v 2.4.8.2 2013/06/18 09:49:37 ronald Exp $";
    String name;

    public ShowRsp(String string) {
        this.txMode = 1;
        this.auditFlag = false;
        this.name = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateDefinition sDMSResourceStateDefinition;
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSResourceStateProfile sDMSResourceStateProfile = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        if (!sDMSResourceStateProfile.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411722", "Insufficient privileges"));
        }
        Long l = sDMSResourceStateProfile.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("INITIAL_STATE");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("STATES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSResourceStateProfile.getName(systemEnvironment));
        Long l2 = sDMSResourceStateProfile.getInitialRsdId(systemEnvironment);
        if (l2 != null) {
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2);
            vector2.add(sDMSResourceStateDefinition.getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateProfile.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateProfile.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateProfile.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateProfile.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSResourceStateProfile.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("RSD_NAME");
        vector3.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSResourceStateTable.idx_rspId.getVector(systemEnvironment, l);
        for (SDMSResourceState sDMSResourceState : vector4) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSResourceState.getId(systemEnvironment));
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResourceState.getRsdId(systemEnvironment));
            vector5.add(sDMSResourceStateDefinition.getName(systemEnvironment));
            vector5.add(sDMSResourceStateDefinition.getPrivileges(systemEnvironment).toString());
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 1));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03201101454", "Resource State Profile"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201292056", "Resource State Profile shown"));
    }
}

