/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.WorkerThread;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystemSynchronized;
import de.independit.scheduler.server.locking.ObjectLock;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ShowSystem
extends Node {
    public static final String __version = "@(#) $Id: ShowSystem.java,v 2.14.4.3 2013/06/18 09:49:38 ronald Exp $";
    static final String[] props = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version"};
    private boolean withLocks;

    public ShowSystem(boolean bl) {
        this.txMode = 1;
        this.auditFlag = false;
        this.withLocks = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        SDMSOutputContainer sDMSOutputContainer2 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Runtime runtime = Runtime.getRuntime();
        Set<Object> set = SystemEnvironment.props.keySet();
        vector.add("VERSION");
        vector.add("MAX_LEVEL");
        vector.add("NUM_CPU");
        vector.add("MEM_USED");
        vector.add("MEM_FREE");
        vector.add("MEM_MAX");
        vector.add("STARTTIME");
        vector.add("UPTIME");
        vector.add("HITRATE");
        vector.add("LOCK_HWM");
        vector.add("LOCKS_REQUESTED");
        vector.add("LOCKS_USED");
        vector.add("LOCKS_DISCARDED");
        vector.add("CNT_RW_TX");
        vector.add("CNT_DL");
        vector.add("CNT_WL");
        Iterator<Object> iterator = set.iterator();
        Vector<String> vector3 = new Vector<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("DbPasswd") || string.equals("KeyStorePassword") || string.equals("TrustStorePassword") || string.equals("SysPasswd")) continue;
            vector3.add(string);
        }
        Collections.sort(vector3);
        vector.addAll(vector3);
        for (int i = 0; i < props.length; ++i) {
            vector.add(props[i].toUpperCase());
        }
        vector.add("WORKER");
        if (this.withLocks) {
            vector.add("LOCKING STATUS");
        }
        Vector<Object> vector4 = new Vector<Object>();
        vector4.add("2.10");
        vector4.add(SystemEnvironment.programLevel);
        vector4.add(new Integer(runtime.availableProcessors()));
        vector4.add(new Long(runtime.totalMemory()));
        vector4.add(new Long(runtime.freeMemory()));
        vector4.add(new Long(runtime.maxMemory()));
        vector4.add(new Date(SystemEnvironment.startTime));
        long l = (System.currentTimeMillis() - SystemEnvironment.startTime) / 1000L;
        int n = (int)l % 60;
        int n2 = (int)(l /= 60L) % 60;
        int n3 = (int)(l /= 60L) % 24;
        String string = ((l /= 24L) > 0L ? "" + l + " day(s) " : "") + ((long)n3 + l > 0L ? "" + n3 + " hour(s) " : "") + ((long)(n2 + n3) + l > 0L ? "" + n2 + " min(s) " : "") + "" + n + " sec(s)";
        vector4.add(string);
        if (SystemEnvironment.sched.envhit == 0L) {
            vector4.add("0 %");
        } else {
            vector4.add("" + (long)((int)((double)SystemEnvironment.sched.envhit * 100.0)) / (SystemEnvironment.sched.envhit + SystemEnvironment.sched.envmiss) + " %");
        }
        vector4.add(new Long(ObjectLock.lockHWM));
        vector4.add(new Long(ObjectLock.lockRequest));
        vector4.add(new Long(ObjectLock.lockUsed));
        vector4.add(new Long(ObjectLock.lockDiscarded));
        vector4.add(new Long(SystemEnvironment.cntRwTx));
        vector4.add(new Long(SystemEnvironment.cntDl));
        vector4.add(new Long(SystemEnvironment.cntWl));
        for (String string2 : vector3) {
            if (string2.equals("DbPasswd") || string2.equals("KeyStorePassword") || string2.equals("TrustStorePassword") || string2.equals("SysPasswd")) continue;
            vector4.add(SystemEnvironment.props.get(string2));
        }
        for (int i = 0; i < props.length; ++i) {
            vector4.add(System.getProperty(props[i]));
        }
        vector2 = new Vector();
        vector2.add("ID");
        vector2.add("TYPE");
        vector2.add("NAME");
        vector2.add("STATE");
        vector2.add("TIME");
        sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, "worker", vector2);
        this.add_worker(systemEnvironment, sDMSOutputContainer2);
        vector4.add(sDMSOutputContainer2);
        if (this.withLocks) {
            vector4.add(LockingSystemSynchronized.strDump().toString());
        }
        this.listObjects(systemEnvironment);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "System", vector, vector4);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202252102", "System shown"));
    }

    private void add_worker(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        ThreadGroup threadGroup = SystemEnvironment.wg;
        Thread[] threadArray = new WorkerThread[SystemEnvironment.maxWorker + SystemEnvironment.maxWriter];
        if (threadArray != null) {
            threadGroup.enumerate(threadArray);
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null || !threadArray[i].isAlive()) continue;
                Vector<Object> vector = new Vector<Object>();
                vector.add(new Integer(((WorkerThread)threadArray[i]).id()));
                vector.add(i < SystemEnvironment.maxWriter ? "RW" : "RO");
                vector.add(threadArray[i].getName());
                vector.add(((WorkerThread)threadArray[i]).getWorkerState());
                vector.add(((WorkerThread)threadArray[i]).getWorkerStateTS(systemEnvironment));
                sDMSOutputContainer.addData(systemEnvironment, vector);
            }
        }
    }

    private void listObjects(SystemEnvironment systemEnvironment) throws SDMSException {
        Iterator iterator = SystemEnvironment.repository.getTableIterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSTable sDMSTable = (SDMSTable)iterator.next();
            SDMSThread.doTrace(systemEnvironment.cEnv, sDMSTable.getClass().getName() + "\t:\t" + sDMSTable.rawSize(), 3);
        }
    }
}

