/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.DateTime;
import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SubmitJob
extends Node {
    public static final String __version = "@(#) $Id: SubmitJob.java,v 2.17.4.2 2013/06/18 09:49:39 ronald Exp $";
    Vector path;
    String name;
    WithHash with;

    public SubmitJob(Vector vector, WithHash withHash) {
        this.cmdtype = 5;
        this.path = vector;
        this.name = this.name = (String)vector.remove(vector.size() - 1);
        this.with = withHash;
    }

    public SubmitJob(String string, WithHash withHash) {
        this.cmdtype = 4;
        this.path = null;
        this.name = string;
        this.with = withHash;
    }

    public static Long evalResumeObj(SystemEnvironment systemEnvironment, Object object, Long l, boolean bl, TimeZone timeZone) throws SDMSException {
        Long l2 = null;
        if (object == null) {
            return l2;
        }
        if (object instanceof WithHash) {
            WithHash withHash = (WithHash)object;
            return SubmitJob.evalResumeObj(systemEnvironment, null, (Integer)withHash.get("MULT"), (Integer)withHash.get("INTERVAL"), l, bl, timeZone);
        }
        return SubmitJob.evalResumeObj(systemEnvironment, (String)object, null, null, l, bl, timeZone);
    }

    public static Long evalResumeObj(SystemEnvironment systemEnvironment, String string, Integer n, Integer n2, Long l, boolean bl, TimeZone timeZone) throws SDMSException {
        Long l2 = null;
        long l3 = l != null ? l : System.currentTimeMillis();
        if (string == null && n == null) {
            return l2;
        }
        if (n != null) {
            if (n2 == null) {
                // empty if block
            }
            int n3 = n;
            int n4 = n2;
            long l4 = n3 * 60000;
            switch (n4) {
                case 0: {
                    break;
                }
                case 1: {
                    l4 *= 60L;
                    break;
                }
                case 2: {
                    l4 *= 1440L;
                    break;
                }
                case 3: {
                    l4 *= 10080L;
                    break;
                }
                case 4: {
                    l4 *= 43200L;
                    break;
                }
                case 5: {
                    l4 *= 525600L;
                }
            }
            l2 = new Long(l3 + l4);
        } else if (string != null) {
            DateTime dateTime = new DateTime(string, timeZone);
            if (dateTime.year == -1) {
                dateTime.setMissingFieldsFromReference(new Date(l3), bl);
            } else {
                dateTime.fixToMinDate();
            }
            Date date = dateTime.toDate();
            l2 = date.getTime();
        }
        if (l2 <= l3) {
            return new Long(-1L);
        }
        return l2;
    }

    public Long master_submit(SystemEnvironment systemEnvironment, String string, String string2) throws SDMSException {
        String string3;
        Object object;
        Long l;
        SDMSProxy sDMSProxy;
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, this.name);
        Boolean bl = (Boolean)this.with.get("SUSPEND");
        Object v = this.with.get("RESUME");
        Vector vector = (Vector)this.with.get("PARAMETERS");
        Integer n = (Integer)this.with.get("NICEVALUE");
        Integer n2 = (Integer)this.with.get("UNRESOLVED");
        String string4 = (String)this.with.get("CHILDTAG");
        Long l2 = null;
        Boolean bl2 = (Boolean)this.with.get("ENABLE");
        if (bl2 != null && !bl2.booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03007181310", "A disabled Master Submit is not allowed"));
        }
        if (n2 != null) {
            if (n2 == 4) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407082029", "DEFER is not a valid option"));
            }
            if (n2 == 2) {
                n2 = null;
            }
        }
        Long l3 = this.env.uid();
        if (this.env.isUser()) {
            sDMSProxy = SDMSUserTable.getObject(systemEnvironment, l3);
            if (!this.with.containsKey("GROUP")) {
                l = ((SDMSUserProxyGeneric)sDMSProxy).getDefaultGId(systemEnvironment);
            } else {
                object = (String)this.with.get("GROUP");
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, new Long(0L))).getId(systemEnvironment);
            }
            string3 = "manually submitted";
        } else {
            sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, l3);
            l = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getOwnerId(systemEnvironment);
            string3 = "submitted by job " + l3;
        }
        boolean bl3 = false;
        try {
            if (this.env.isJob()) {
                bl3 = true;
                this.env.setUser();
            }
            if (!sDMSSchedulingEntity.checkPrivileges(systemEnvironment, 0x100000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03312181437", "Insufficient privileges for submitting $1", (Object)sDMSSchedulingEntity.pathString(systemEnvironment)));
            }
        }
        catch (SDMSException sDMSException) {
            throw sDMSException;
        }
        finally {
            if (bl3) {
                this.env.setJob();
            }
        }
        sDMSSchedulingEntity.checkSubmitForGroup(systemEnvironment, l);
        if (bl != null && bl.booleanValue() && (l2 = SubmitJob.evalResumeObj(systemEnvironment, v, null, true, TimeZone.getTimeZone(string2))) != null && l2 == -1L) {
            bl = new Boolean(false);
            l2 = null;
        }
        object = sDMSSchedulingEntity.submitMaster(systemEnvironment, vector, bl == null ? null : new Integer(bl != false ? 1 : 0), l2, l, n, string3, string, string4, n2, string2);
        return ((SDMSProxy)object).getId(systemEnvironment);
    }

    public Long child_submit(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        Serializable serializable;
        Integer n = (Integer)this.with.get("SUSPEND");
        Object v = this.with.get("RESUME");
        Vector vector = (Vector)this.with.get("PARAMETERS");
        String string2 = (String)this.with.get("CHILDTAG");
        Integer n2 = (Integer)this.with.get("UNRESOLVED");
        Long l = null;
        Boolean bl = (Boolean)this.with.get("ENABLE");
        if (bl == null) {
            bl = Boolean.TRUE;
        }
        if (n2 != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03407082033", "UNRESOLVED only allowed for master submit"));
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        if (this.path != null) {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, this.name, l2);
        } else {
            serializable = SDMSSchedulingHierarchyTable.idx_parentId_aliasName.getVector(systemEnvironment, (Object)new SDMSKey(sDMSSubmittedEntity.getSeId(systemEnvironment), (Comparable)((Object)this.name)), l2);
            if (((Vector)serializable).size() == 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212060125", "alias not found"));
            }
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchy)((Vector)serializable).get(0)).getSeChildId(systemEnvironment), l2);
        }
        l = SubmitJob.evalResumeObj(systemEnvironment, v, null, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
        serializable = sDMSSubmittedEntity.getState(systemEnvironment);
        if ((Integer)serializable == 5 || (Integer)serializable == 6 || (Integer)serializable == 7) {
            if (sDMSSubmittedEntity.getIsCancelled(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03703020852", "Child submit rejected because job is cancelling"));
            }
            SDMSSubmittedEntity sDMSSubmittedEntity2 = sDMSSubmittedEntity.submitChild(systemEnvironment, vector, n, l, sDMSSchedulingEntity.getId(systemEnvironment), string2, null, string, bl);
            return sDMSSubmittedEntity2.getId(systemEnvironment);
        }
        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03703020852", "Child submit only allowed while job is active"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Serializable serializable;
        String string;
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        Vector<TimeZone> vector2 = new Vector<TimeZone>();
        String string2 = (String)this.with.get("SUBMITTAG");
        if (string2 != null && SDMSSubmittedEntityTable.idx_submitTag.containsKey(systemEnvironment, string2)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406031553", "Job with submit tag $1 already submitted", (Object)string2));
        }
        if (this.with.containsKey("TIME")) {
            string = (String)this.with.get("TIME");
            if (!string.equals((serializable = TimeZone.getTimeZone(string)).getID())) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207031503", "Time Zone " + string + " unknown"));
            }
        } else {
            serializable = TimeZone.getDefault();
            string = serializable.getID();
        }
        if (systemEnvironment.cEnv.isUser()) {
            boolean bl;
            Boolean bl2 = (Boolean)this.with.get("CHECK_ONLY");
            boolean bl3 = bl = bl2 == null ? false : bl2;
            if (this.path == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212060119", "You cannot submit by alias as a user"));
            }
            if (bl) {
                systemEnvironment.tx.beginSubTransaction(systemEnvironment);
            }
            serializable = this.master_submit(systemEnvironment, string2, string);
            if (bl) {
                systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03304141142", "Job submit checked successfully"));
                return;
            }
        } else if (this.with.containsKey("MASTER")) {
            if (this.path == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03801291249", "A master submit by alias is not supported"));
            }
            serializable = this.master_submit(systemEnvironment, string2, string);
        } else {
            serializable = this.child_submit(systemEnvironment, string2);
        }
        vector2.add((TimeZone)serializable);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Submit", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02201170716", "Job submitted"));
    }
}

