/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;

public class HistoryFilter
extends Filter {
    long numMillisFrom = 0L;
    long numMillisTo = 0L;

    public HistoryFilter(SystemEnvironment systemEnvironment, WithHash withHash, WithHash withHash2) {
        this.numMillisFrom = this.convertInterval(withHash);
        this.numMillisTo = this.convertInterval(withHash2);
        if (this.numMillisFrom > this.numMillisTo) {
            long l = this.numMillisTo;
            this.numMillisTo = this.numMillisFrom;
            this.numMillisFrom = l;
        }
    }

    public HistoryFilter(SystemEnvironment systemEnvironment, WithHash withHash) {
        this.numMillisFrom = this.convertInterval(withHash);
        this.numMillisTo = -1L;
    }

    private long convertInterval(WithHash withHash) {
        Integer n = (Integer)withHash.get("MULT");
        Integer n2 = (Integer)withHash.get("INTERVAL");
        if (n == null || n2 == null) {
            return 0L;
        }
        long l = System.currentTimeMillis();
        switch (n2) {
            case 0: {
                l -= n.longValue() * 60L * 1000L;
                break;
            }
            case 1: {
                l -= n.longValue() * 60L * 60L * 1000L;
                break;
            }
            case 2: {
                l -= n.longValue() * 24L * 60L * 60L * 1000L;
                break;
            }
            case 3: {
                l -= n.longValue() * 7L * 24L * 60L * 60L * 1000L;
                break;
            }
            case 4: {
                l -= n.longValue() * 30L * 24L * 60L * 60L * 1000L;
                break;
            }
            case 5: {
                l -= n.longValue() * 365L * 24L * 60L * 60L * 1000L;
            }
        }
        return l;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            if (!(sDMSProxy instanceof SDMSSubmittedEntity)) {
                return this.numMillisTo == -1L;
            }
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            Long l = sDMSSubmittedEntity.getFinalTs(systemEnvironment);
            if ((l == null || l >= this.numMillisFrom) && (this.numMillisTo == -1L || l != null && l <= this.numMillisTo)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HistoryFilter)) {
            return false;
        }
        HistoryFilter historyFilter = (HistoryFilter)object;
        if (this.numMillisFrom != historyFilter.numMillisFrom) {
            return false;
        }
        return this.numMillisTo == historyFilter.numMillisTo;
    }
}

