/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class JobServerFilter
extends Filter {
    Vector jobsrvrList;
    HashSet scopeIds = null;
    SystemEnvironment env;

    public JobServerFilter(SystemEnvironment systemEnvironment, Vector vector) {
        this.jobsrvrList = vector;
        this.env = systemEnvironment;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            if (this.scopeIds == null) {
                this.fillScopeIds(systemEnvironment);
            }
            if (this.scopeIds.contains(sDMSSubmittedEntity.getScopeId(systemEnvironment))) {
                return true;
            }
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
        return false;
    }

    private void fillScopeIds(SystemEnvironment systemEnvironment) {
        if (this.scopeIds == null) {
            this.scopeIds = new HashSet();
            for (int i = 0; i < this.jobsrvrList.size(); ++i) {
                Vector vector = (Vector)this.jobsrvrList.get(i);
                try {
                    this.scopeIds.add(SDMSScopeTable.pathToId(systemEnvironment, vector));
                    continue;
                }
                catch (SDMSException sDMSException) {
                    if (systemEnvironment.tx.mode == 1) continue;
                    throw new RuntimeException();
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JobServerFilter)) {
            return false;
        }
        JobServerFilter jobServerFilter = (JobServerFilter)object;
        if (this.scopeIds == null) {
            this.fillScopeIds(this.env);
        }
        if (jobServerFilter.scopeIds == null) {
            jobServerFilter.fillScopeIds(this.env);
        }
        if (this.scopeIds.size() != jobServerFilter.scopeIds.size()) {
            return false;
        }
        Iterator iterator = this.scopeIds.iterator();
        while (iterator.hasNext()) {
            if (jobServerFilter.scopeIds.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

