/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.triggerexpr;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class ParseObject {
    private BigDecimal number;
    private String string;
    private int type;
    public static final int VOID = 0;
    public static final int STRING = 1;
    public static final int NUMBER = 2;
    public static final int DATE = 3;
    public static final int INDETERMINED = 99;
    public static final BigDecimal one = new BigDecimal("1");

    public ParseObject() {
        this.type = 0;
        this.number = null;
        this.string = null;
    }

    public ParseObject(Object object) {
        if (object instanceof BigDecimal) {
            this.type = 2;
            this.number = (BigDecimal)object;
            this.string = null;
        } else if (object instanceof String) {
            this.string = (String)object;
            try {
                this.number = new BigDecimal(this.string);
                this.type = 2;
                this.string = null;
            }
            catch (NumberFormatException numberFormatException) {
                this.number = null;
                this.type = 1;
            }
        } else if (object.getClass().getName().endsWith("Something date like")) {
            this.type = 3;
            this.string = null;
            this.number = null;
        } else {
            System.err.println("Fatal Exception! Unexpected Object: " + object.toString() + "\n");
            System.exit(1);
        }
    }

    public String toString() {
        if (this.type == 0) {
            return "VOID";
        }
        if (this.type == 1) {
            return this.string;
        }
        if (this.type == 2) {
            return this.number.toString();
        }
        return "Unknown";
    }

    public ParseObject(String string) {
        this.type = 99;
        this.string = string;
        this.number = null;
    }

    public ParseObject(String string, int n) {
        this.type = n;
        if (this.type == 2) {
            this.type = 99;
        }
        this.string = string;
        this.number = null;
    }

    public ParseObject(BigDecimal bigDecimal) {
        this.type = 2;
        this.number = bigDecimal;
        this.string = null;
    }

    public ParseObject(ParseObject parseObject) {
        this.type = parseObject.type;
        this.number = parseObject.number;
        this.string = parseObject.string;
    }

    public static ParseObject question(Boolean bl, ParseObject parseObject, ParseObject parseObject2) {
        if (bl.booleanValue()) {
            return parseObject;
        }
        return parseObject2;
    }

    public Object getValue() {
        if (this.type == 1 || this.type == 99) {
            return this.string;
        }
        if (this.type == 2) {
            if (this.number == null) {
                return null;
            }
            try {
                long l = this.number.longValueExact();
                return new Long(l);
            }
            catch (ArithmeticException arithmeticException) {
                double d = this.number.doubleValue();
                return new Double(d);
            }
        }
        return null;
    }

    public ParseObject adjust(ParseObject parseObject, boolean bl) throws SDMSException {
        return this.adjust(parseObject.type, bl);
    }

    public ParseObject adjust(int n, boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        if (this.type == n) {
            return new ParseObject(this);
        }
        ParseObject parseObject = new ParseObject(this);
        try {
            switch (n) {
                case 1: 
                case 99: {
                    parseObject.type = 1;
                    parseObject.number = null;
                    if (this.type == 2) {
                        parseObject.string = this.number.toString();
                    }
                    if (this.type != 0) break;
                    parseObject.string = new String();
                    break;
                }
                case 2: {
                    parseObject.type = 2;
                    parseObject.string = null;
                    if (this.type == 1 || this.type == 99) {
                        parseObject.number = new BigDecimal(this.string);
                    }
                    if (this.type != 0) break;
                    parseObject.number = new BigDecimal("0");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (this.string == null || this.string.equals("") || this.string.toUpperCase().equals("NONE")) {
                parseObject.number = new BigDecimal("0");
            }
            throw new SDMSException(new SDMSMessage((SystemEnvironment)null, "03802071626", "Error evaluating expression. Invalid number format of $1", (Object)this.string));
        }
        return parseObject;
    }

    public ParseObject mult(ParseObject parseObject, Integer n, boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        int n2 = n;
        ParseObject parseObject2 = this.adjust(2, bl);
        ParseObject parseObject3 = parseObject.adjust(2, bl);
        switch (n2) {
            case 275: {
                if (parseObject3.number.equals(0)) {
                    throw new SDMSException(new SDMSMessage((SystemEnvironment)null, "03802071627", "Error evaluating expression. Division by zero"));
                }
                parseObject2.number = parseObject2.number.divide(parseObject3.number, 4);
                break;
            }
            case 279: {
                parseObject2.number = parseObject2.number.multiply(parseObject3.number);
                break;
            }
            case 277: {
                BigInteger bigInteger = parseObject2.number.toBigInteger();
                BigInteger bigInteger2 = parseObject3.number.toBigInteger();
                if (bigInteger2.equals(0)) {
                    throw new SDMSException(new SDMSMessage((SystemEnvironment)null, "03802071628", "Error evaluating expression. Division by zero"));
                }
                parseObject2.number = new BigDecimal(bigInteger.mod(bigInteger2));
            }
        }
        return parseObject2;
    }

    public ParseObject add(ParseObject parseObject, Integer n, boolean bl) throws SDMSException {
        ParseObject parseObject2 = this;
        ParseObject parseObject3 = null;
        if (bl) {
            return new ParseObject();
        }
        int n2 = n;
        if (n2 == 278) {
            if (parseObject2.type == 99) {
                try {
                    parseObject2 = this.adjust(2, bl);
                }
                catch (CommonErrorException commonErrorException) {
                    parseObject2 = this.adjust(1, bl);
                }
            }
            if (parseObject2.type == 1) {
                parseObject3 = parseObject.adjust(1, bl);
                parseObject3.string = parseObject2.string + parseObject3.string;
                return parseObject3;
            }
            if (parseObject.type != 2) {
                try {
                    parseObject3 = parseObject.adjust(2, bl);
                }
                catch (CommonErrorException commonErrorException) {
                    parseObject2 = parseObject2.adjust(1, bl);
                    parseObject3.string = parseObject2.string + parseObject3.string;
                    return parseObject3;
                }
            }
        }
        if (parseObject2.type != 2) {
            parseObject2 = this.adjust(2, bl);
        }
        parseObject3 = parseObject.adjust(2, bl);
        switch (n2) {
            case 278: {
                parseObject2.number = parseObject2.number.add(parseObject3.number);
                break;
            }
            case 276: {
                parseObject2.number = parseObject2.number.add(parseObject3.number.negate());
            }
        }
        return parseObject2;
    }

    public int compareTo(ParseObject parseObject, boolean bl) throws SDMSException {
        ParseObject parseObject2 = this;
        if (this.type == 99) {
            if (parseObject.type != 99) {
                try {
                    parseObject2 = this.adjust(parseObject.type, bl);
                }
                catch (CommonErrorException commonErrorException) {
                    parseObject2 = this.adjust(1, bl);
                }
            } else {
                parseObject2 = this.adjust(1, bl);
            }
        }
        ParseObject parseObject3 = parseObject.adjust(parseObject2.type, bl);
        int n = 0;
        switch (parseObject2.type) {
            case 2: {
                n = parseObject2.number.compareTo(parseObject3.number);
                break;
            }
            case 1: {
                n = parseObject2.string.compareTo(parseObject3.string);
            }
        }
        return n;
    }

    public Boolean compare(ParseObject parseObject, Integer n, boolean bl) throws SDMSException {
        if (bl) {
            return Boolean.TRUE;
        }
        int n2 = n;
        if (n2 == 273 || n2 == 274) {
            ParseObject parseObject2 = this.adjust(1, bl);
            ParseObject parseObject3 = parseObject.adjust(1, bl);
            if (n2 == 273 && parseObject2.string.matches(parseObject3.string)) {
                return Boolean.TRUE;
            }
            if (n2 == 274 && !parseObject2.string.matches(parseObject3.string)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        int n3 = this.compareTo(parseObject, bl);
        switch (n2) {
            case 267: {
                return new Boolean(n3 == 0);
            }
            case 269: {
                return new Boolean(n3 >= 0);
            }
            case 268: {
                return new Boolean(n3 > 0);
            }
            case 271: {
                return new Boolean(n3 <= 0);
            }
            case 270: {
                return new Boolean(n3 < 0);
            }
            case 272: {
                return new Boolean(n3 != 0);
            }
        }
        return Boolean.TRUE;
    }

    public ParseObject changeSign(Integer n, boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        int n2 = n;
        ParseObject parseObject = this.adjust(2, bl);
        switch (n2) {
            case 278: {
                break;
            }
            case 276: {
                parseObject.number = parseObject.number.negate();
            }
        }
        return parseObject;
    }

    public ParseObject to_int(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(2, bl);
        parseObject.number = new BigDecimal(parseObject.number.toBigInteger());
        return parseObject;
    }

    public ParseObject to_date(ParseObject parseObject, boolean bl) throws SDMSException {
        ParseObject parseObject2;
        if (bl) {
            return new ParseObject();
        }
        if (this.type == 2) {
            return this.to_int(false);
        }
        if (this.type == 0) {
            return this;
        }
        if (parseObject.type == 1) {
            try {
                SimpleDateFormat simpleDateFormat = parseObject.string != null ? new SimpleDateFormat(parseObject.string) : (SimpleDateFormat)SystemEnvironment.staticSystemDateFormat.clone();
                Date date = simpleDateFormat.parse(this.string);
                parseObject2 = new ParseObject(new BigDecimal(date.getTime()));
            }
            catch (ParseException parseException) {
                parseObject2 = new ParseObject(new BigDecimal(0));
            }
        } else {
            parseObject2 = new ParseObject(new BigDecimal(0));
        }
        return parseObject2;
    }

    public ParseObject abs(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(2, bl);
        parseObject.number = parseObject.number.abs();
        return parseObject;
    }

    public ParseObject round(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(2, bl);
        parseObject.number = parseObject.number.divide(one, 4);
        return parseObject;
    }

    public ParseObject substr(ParseObject parseObject, ParseObject parseObject2, boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject3 = this.adjust(1, bl);
        int n = parseObject.adjust((int)2, (boolean)bl).number.intValue();
        if (parseObject2 != null) {
            int n2 = parseObject2.adjust((int)2, (boolean)bl).number.intValue();
            parseObject3.string = parseObject3.string.substring(n, n2);
        } else {
            parseObject3.string = parseObject3.string.substring(n);
        }
        return parseObject3;
    }

    public ParseObject trim(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(1, bl);
        parseObject.string = parseObject.string.trim();
        return parseObject;
    }

    public ParseObject uppercase(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(1, bl);
        parseObject.string = parseObject.string.toUpperCase();
        return parseObject;
    }

    public ParseObject lowercase(boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        ParseObject parseObject = this.adjust(1, bl);
        parseObject.string = parseObject.string.toLowerCase();
        return parseObject;
    }

    public ParseObject nvl(ParseObject parseObject, boolean bl) throws SDMSException {
        if (bl) {
            return new ParseObject();
        }
        if (this.type == 0 || this.type == 1 && (this.string == null || this.string.equals("")) || this.type == 2 && this.number == null || this.type == 3 && this.number == null) {
            return parseObject;
        }
        return this;
    }
}

