/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventGeneric;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSEventTableGeneric
extends SDMSTable {
    public static final String tableName = "EVENT";
    public static SDMSEventTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "SE_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_seId;

    public SDMSEventTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Event"));
        }
        table = (SDMSEventTable)this;
        table = (SDMSEventTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
    }

    public SDMSEvent create(SystemEnvironment systemEnvironment, String string, Long l, Long l2) throws SDMSException {
        SDMSEvent sDMSEvent;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Event"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSEventGeneric sDMSEventGeneric = new SDMSEventGeneric(systemEnvironment, string, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSEventGeneric.versions, true);
            table.put(systemEnvironment, sDMSEventGeneric.id, sDMSEventGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSEvent = (SDMSEvent)sDMSEventGeneric.toProxy(systemEnvironment);
            sDMSEvent.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSEvent sDMSEvent2 = (SDMSEvent)sDMSEventGeneric.toProxy(systemEnvironment);
            sDMSEvent2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSEvent)) {
            throw new AccessViolationException(sDMSEvent.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSEvent;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSEvent sDMSEvent) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        String string;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l8 = new Long(resultSet.getLong(3));
            l7 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = new Long(resultSet.getLong(5));
            l5 = new Long(resultSet.getLong(6));
            l4 = new Long(resultSet.getLong(7));
            l3 = new Long(resultSet.getLong(8));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Event: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSEventGeneric(l9, string, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSEventGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSEventGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSEventGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSEventGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSEventGeneric)sDMSObject).ownerId, sDMSObject, (2L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSEventGeneric)sDMSObject).seId, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSEventGeneric)sDMSObject).name, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSEventGeneric)sDMSObject).ownerId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSEventGeneric)sDMSObject).seId, sDMSObject);
    }

    public static SDMSEvent getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEvent)table.get(systemEnvironment, l);
    }

    public static SDMSEvent getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSEvent)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSEvent getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSEvent)table.get(systemEnvironment, l, l2);
    }

    public static SDMSEvent idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEvent)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSEvent idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSEvent)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSEvent idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSEvent)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

