/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantProxyGeneric;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class SDMSResourceStateProfileProxyGeneric
extends SDMSProxy {
    public static final long privilegeMask = 0x210000111L;
    public static final int name_size = 64;

    protected SDMSResourceStateProfileProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSResourceStateProfile getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSResourceStateProfileTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSResourceStateProfile(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSResourceStateProfile)sDMSProxy;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    public Long getInitialRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getInitialRsdId(systemEnvironment);
    }

    public void setInitialRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setInitialRsdId(systemEnvironment, l);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSResourceStateProfile setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceStateProfileGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSResourceStateProfile)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSResourceStateProfileGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSResourceStateProfileGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSResourceStateProfile setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSResourceStateProfileGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSResourceStateProfile)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)this.getName(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 0x210000111L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 0x210000111L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser() || systemEnvironment.cEnv.isJob()) {
            SDMSProxy sDMSProxy;
            if (systemEnvironment.cEnv.isJob()) {
                HashSet<Long> hashSet = new HashSet<Long>();
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
                Long l3 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getOwnerId(systemEnvironment);
                hashSet.add(l3);
                hashSet.add(SDMSObject.publicGId);
                systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
            }
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                l2 = l;
            } else {
                l2 |= 0x10000000L & l;
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        sDMSProxy = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= ((SDMSGrantProxyGeneric)sDMSProxy).getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                    try {
                        sDMSProxy = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSProxy.ZERO, (Long)vector2.get(i)));
                        if ((((SDMSGrantProxyGeneric)sDMSProxy).getPrivs(systemEnvironment) & 0x20000000000L) == 0L) continue;
                        l2 = l;
                        break;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        } else {
            l2 = l;
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Resource State Profile $1", (Object)this.getName(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSResourceStateProfileGeneric)this.object).print();
    }
}

