/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceStateProfileTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_STATE_PROFILE";
    public static SDMSResourceStateProfileTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "INITIAL_RSD_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_initialRsdId;

    public SDMSResourceStateProfileTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceStateProfile"));
        }
        table = (SDMSResourceStateProfileTable)this;
        table = (SDMSResourceStateProfileTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_initialRsdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "initialRsdId");
    }

    public SDMSResourceStateProfile create(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        SDMSResourceStateProfile sDMSResourceStateProfile;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceStateProfile"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceStateProfileGeneric sDMSResourceStateProfileGeneric = new SDMSResourceStateProfileGeneric(systemEnvironment, string, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceStateProfileGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceStateProfileGeneric.id, sDMSResourceStateProfileGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceStateProfile = (SDMSResourceStateProfile)sDMSResourceStateProfileGeneric.toProxy(systemEnvironment);
            sDMSResourceStateProfile.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceStateProfile sDMSResourceStateProfile2 = (SDMSResourceStateProfile)sDMSResourceStateProfileGeneric.toProxy(systemEnvironment);
            sDMSResourceStateProfile2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceStateProfile)) {
            throw new AccessViolationException(sDMSResourceStateProfile.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSResourceStateProfile;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceStateProfile sDMSResourceStateProfile) throws SDMSException {
        return sDMSResourceStateProfile.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l7 = new Long(resultSet.getLong(3));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceStateProfile: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceStateProfileGeneric(l8, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "INITIAL_RSD_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSResourceStateProfileGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_initialRsdId.check(((SDMSResourceStateProfileGeneric)sDMSObject).initialRsdId, sDMSObject);
        string = string + "idx_initialRsdId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSResourceStateProfileGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_initialRsdId.put(systemEnvironment, ((SDMSResourceStateProfileGeneric)sDMSObject).initialRsdId, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSResourceStateProfileGeneric)sDMSObject).name, sDMSObject);
        idx_initialRsdId.remove(systemEnvironment, ((SDMSResourceStateProfileGeneric)sDMSObject).initialRsdId, sDMSObject);
    }

    public static SDMSResourceStateProfile getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceStateProfile)table.get(systemEnvironment, l);
    }

    public static SDMSResourceStateProfile getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceStateProfile)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceStateProfile getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceStateProfile)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceStateProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceStateProfile)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceStateProfile idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceStateProfile)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceStateProfile idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceStateProfile)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

