/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprintProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalHierarchyTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorProxyGeneric;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSResourceTemplateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SeVariableResolver;
import de.independit.scheduler.server.repository.VariableResolver;
import de.independit.scheduler.server.util.PathVector;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;

public class SDMSSchedulingEntity
extends SDMSSchedulingEntityProxyGeneric
implements SDMSOwnedObject {
    private static final VariableResolver SEVR = new SeVariableResolver();
    private static final Integer zero = new Integer(0);
    private static final Long lzero = new Long(0L);

    protected SDMSSchedulingEntity(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getFolderId(systemEnvironment);
    }

    @Override
    public SDMSProxy getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return SDMSFolderTable.getObject(systemEnvironment, l);
    }

    public String pathString(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        return sDMSFolder.pathString(systemEnvironment) + "." + this.getName(systemEnvironment);
    }

    public String pathString(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        return sDMSFolder.pathString(systemEnvironment, l) + "." + this.getName(systemEnvironment);
    }

    @Override
    public PathVector pathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        PathVector pathVector = sDMSFolder.pathVector(systemEnvironment);
        pathVector.add(this.getName(systemEnvironment));
        return pathVector;
    }

    public PathVector idPathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment));
        PathVector pathVector = sDMSFolder.idPathVector(systemEnvironment);
        pathVector.add(this.getId(systemEnvironment));
        return pathVector;
    }

    public PathVector pathVector(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        PathVector pathVector = sDMSFolder.pathVector(systemEnvironment, l);
        pathVector.add(this.getName(systemEnvironment));
        return pathVector;
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "job definition " + this.getURLName(systemEnvironment);
    }

    @Override
    public String getSubtypeName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.getTypeAsString(systemEnvironment);
    }

    public boolean checkParameterRI(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            if (sDMSParameterDefinition.getType(systemEnvironment) != 91 || !(sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition.getLinkPdId(systemEnvironment))).getSeId(systemEnvironment).equals(l)) continue;
            return true;
        }
        return false;
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        return SEVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, -1L);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, long l) throws SDMSException {
        return SEVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, l);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2) throws SDMSException {
        return this.submitMaster(systemEnvironment, vector, n, l, l2, n2, string, null, null, string2);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2, Integer n3, String string3) throws SDMSException {
        return this.submitMaster(systemEnvironment, vector, n, l, l2, n2, string, string2, null, n3, string3);
    }

    public SDMSSubmittedEntity submitMaster(SystemEnvironment systemEnvironment, Vector vector, Integer n, Long l, Long l2, Integer n2, String string, String string2, String string3, Integer n3, String string4) throws SDMSException {
        Object object;
        Comparable comparable;
        Serializable serializable;
        Long l3 = this.getId(systemEnvironment);
        Date date = new Date();
        Long l4 = date.getTime();
        if (!this.getMasterSubmittable(systemEnvironment).booleanValue()) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201041040", "$1 $2 cannot be submitted as master", (Object)this.getTypeAsString(systemEnvironment), (Object)this.getName(systemEnvironment)));
        }
        Long l5 = this.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l5);
        if (!sDMSExitStateProfile.getIsValid(systemEnvironment).booleanValue()) {
            sDMSExitStateProfile.checkProfile(systemEnvironment);
        }
        if (n == null && (n = new Integer(this.getSubmitSuspended(systemEnvironment) != false ? 1 : 0)) == 1) {
            serializable = null;
            serializable = string4 == null ? TimeZone.getDefault() : TimeZone.getTimeZone(string4);
            l = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l4, true, (TimeZone)serializable);
        }
        serializable = null;
        if (n != 0) {
            serializable = new Long(-l4.longValue());
        }
        long l6 = SDMSTransaction.drawVersion(systemEnvironment);
        Integer n4 = this.getPriority(systemEnvironment);
        Integer n5 = zero;
        Integer n6 = n2 == null ? new Integer(0) : n2;
        switch (this.getType(systemEnvironment)) {
            case 1: {
                if (n4 == null) {
                    n4 = new Integer(50 + n6);
                    break;
                }
                if (n4 >= SystemEnvironment.priorityLowerBound && (n4 = new Integer(n4 + n6)) < SystemEnvironment.priorityLowerBound) {
                    n4 = new Integer(SystemEnvironment.priorityLowerBound);
                }
                n5 = new Integer(n4 * 100);
                break;
            }
            case 2: {
                if (n4 == null) break;
                n6 = new Integer(n4 + n6);
                n4 = new Integer(50);
                break;
            }
            case 3: {
                n4 = new Integer(50);
                if (n6 != null) break;
                n6 = new Integer(0);
            }
        }
        Integer n7 = null;
        n7 = this.getMinPriority(systemEnvironment);
        if (n7 == null) {
            n7 = new Integer(SystemEnvironment.priorityLowerBound);
        }
        Integer n8 = null;
        Integer n9 = null;
        n8 = this.getAgingAmount(systemEnvironment);
        n9 = this.getAgingBase(systemEnvironment);
        if (n8 == null || n9 == null) {
            n8 = new Integer(SystemEnvironment.priorityDelay);
            n9 = new Integer(0);
        }
        switch (n9) {
            case 0: {
                break;
            }
            case 1: {
                n8 = new Integer((int)((long)n8.intValue() * 60L));
                break;
            }
            case 2: {
                n8 = new Integer((int)((long)n8.intValue() * 1440L));
                break;
            }
            case 3: {
                n8 = new Integer((int)((long)n8.intValue() * 10080L));
                break;
            }
            case 4: {
                n8 = new Integer((int)((long)n8.intValue() * 43200L));
                break;
            }
            case 5: {
                n8 = new Integer((int)((long)n8.intValue() * 525600L));
            }
        }
        n9 = new Integer(0);
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.table.create(systemEnvironment, systemEnvironment.randomLong(), new Long(0L), string2, n3, l3, string3, new Long(l6), l2, null, null, Boolean.TRUE, Boolean.FALSE, null, new Integer(4), new Integer(0), null, null, Boolean.FALSE, Boolean.FALSE, null, null, null, null, zero, Boolean.FALSE, Boolean.FALSE, null, null, null, null, null, null, null, zero, null, null, null, null, null, null, null, null, n, n4, n5, n6, zero, n7, n8, zero, zero, zero, null, l4, l, null, null, null, null, null, null, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, zero, null, zero, zero, zero, zero, zero, zero, zero, zero, zero, (Long)serializable, null, string4);
        Long l7 = sDMSSubmittedEntity.getId(systemEnvironment);
        if (vector != null) {
            for (WithItem withItem : vector) {
                sDMSSubmittedEntity.setVariableValue(systemEnvironment, (String)((Object)withItem.key), (String)withItem.value);
            }
        }
        sDMSSubmittedEntity.submitChilds(systemEnvironment, n == 0 ? 0 : 1, l2, null, n6 * 100, false);
        sDMSSubmittedEntity.resolveDependencies(systemEnvironment, true);
        Vector vector2 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l3);
        for (int i = 0; i < vector2.size(); ++i) {
            comparable = (SDMSTrigger)vector2.get(i);
            int n10 = ((SDMSTriggerProxyGeneric)comparable).getType(systemEnvironment);
            if (n10 != 5 && n10 != 6) continue;
            SDMSTriggerQueueTable.table.create(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment), ((SDMSProxy)comparable).getId(systemEnvironment), lzero, zero, zero);
        }
        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
        Long l8 = new Long(date.getTime());
        comparable = systemEnvironment.cEnv.isUser() ? systemEnvironment.cEnv.uid() : SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"INTERNAL"), new Long(0L))).getId(systemEnvironment);
        SDMSAuditTrailTable.table.create(systemEnvironment, (Long)comparable, l8, new Integer(15), new Integer(17), l7, l7, Boolean.FALSE, null, string);
        SDMSNiceProfileEntry sDMSNiceProfileEntry = null;
        Vector vector3 = SDMSNiceProfile.getActiveNiceProfiles(systemEnvironment);
        Iterator iterator = vector3.iterator();
        SDMSNiceProfile sDMSNiceProfile = null;
        while (iterator.hasNext() && (sDMSNiceProfileEntry = (sDMSNiceProfile = (SDMSNiceProfile)iterator.next()).match(systemEnvironment, (Vector)(object = sDMSNiceProfile.getSortedEntries(systemEnvironment)), sDMSSubmittedEntity)) == null) {
        }
        if (sDMSNiceProfileEntry != null) {
            int n11;
            int n12;
            object = "Renice caused by ative Nice Profile " + sDMSNiceProfile.getName(systemEnvironment);
            n6 = (int)sDMSNiceProfileEntry.getRenice(systemEnvironment);
            if (n6 != 0) {
                sDMSSubmittedEntity.renice(systemEnvironment, null, new Integer(n6), (String)object);
            }
            if ((n12 = sDMSNiceProfileEntry.getIsSuspended(systemEnvironment).intValue()) != 0 && (n11 = sDMSSubmittedEntity.getIsSuspended(systemEnvironment).intValue()) != n12 && n11 != 2) {
                boolean bl = false;
                String string5 = "";
                if (n12 == 2) {
                    bl = true;
                    string5 = "Admin ";
                }
                SDMSAuditTrailTable.table.create(systemEnvironment, (Long)comparable, l8, new Integer(4), new Integer(17), sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, string5 + "Suspend caused by active Nice Profile " + sDMSNiceProfile.getName(systemEnvironment));
                sDMSSubmittedEntity.suspend(systemEnvironment, false, bl, false);
            }
            sDMSSubmittedEntity.setNpeId(systemEnvironment, sDMSNiceProfileEntry.getId(systemEnvironment));
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSSubmittedEntity, 18);
        return sDMSSubmittedEntity;
    }

    public SDMSSubmittedEntity createErrorMaster(SystemEnvironment systemEnvironment, Long l, String string, String string2) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Date date = new Date();
        long l3 = SDMSTransaction.drawVersion(systemEnvironment);
        Integer n = new Integer(50);
        Integer n2 = new Integer(0);
        Long l4 = this.getEspId(systemEnvironment);
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l4);
        Long l5 = null;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSExitState sDMSExitState = (SDMSExitState)vector.get(i);
            if (!sDMSExitState.getIsBroken(systemEnvironment).booleanValue()) continue;
            l5 = sDMSExitState.getEsdId(systemEnvironment);
            break;
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.table.createErrorMaster(systemEnvironment, l2, new Long(l3), l, l5, l5, string2, n, n2, new Long(date.getTime()));
        Long l6 = sDMSSubmittedEntity.getId(systemEnvironment);
        sDMSSubmittedEntity.setMasterId(systemEnvironment, l6);
        Long l7 = new Long(date.getTime());
        Long l8 = systemEnvironment.cEnv.isUser() ? systemEnvironment.cEnv.uid() : SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"INTERNAL"), new Long(0L))).getId(systemEnvironment);
        SDMSAuditTrailTable.table.create(systemEnvironment, l8, l7, new Integer(15), new Integer(17), l6, l6, Boolean.FALSE, null, string);
        sDMSSubmittedEntity.trigger(systemEnvironment, 0);
        sDMSSubmittedEntity.trigger(systemEnvironment, 1);
        sDMSSubmittedEntity.trigger(systemEnvironment, 4);
        return sDMSSubmittedEntity;
    }

    public SDMSSchedulingEntity copy(SystemEnvironment systemEnvironment, Long l, String string, HashMap hashMap) throws SDMSException {
        Comparable comparable;
        SDMSProxy sDMSProxy;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Iterator iterator;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object102;
        SDMSProxy sDMSProxy2;
        Comparable comparable2;
        Long l2 = this.getId(systemEnvironment);
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        Long l3 = this.getNeId(systemEnvironment);
        if (l3 != null && !((SDMSNamedEnvironmentProxyGeneric)(comparable2 = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l3))).checkPrivileges(systemEnvironment, 0x1000000L)) {
            throw new AccessViolationException(((SDMSNamedEnvironmentProxyGeneric)comparable2).accessViolationMessage(systemEnvironment, "03402291147"));
        }
        comparable2 = this.getFpId(systemEnvironment);
        if (comparable2 != null && !((SDMSFootprintProxyGeneric)(sDMSProxy2 = SDMSFootprintTable.getObject(systemEnvironment, (Long)comparable2))).checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(((SDMSFootprintProxyGeneric)sDMSProxy2).accessViolationMessage(systemEnvironment, "03402291151"));
        }
        sDMSProxy2 = SDMSSchedulingEntityTable.table.create(systemEnvironment, string, l, sDMSUser.getDefaultGId(systemEnvironment), this.getType(systemEnvironment), this.getRunProgram(systemEnvironment), this.getRerunProgram(systemEnvironment), this.getKillProgram(systemEnvironment), this.getWorkdir(systemEnvironment), this.getLogfile(systemEnvironment), this.getTruncLog(systemEnvironment), this.getErrlogfile(systemEnvironment), this.getTruncErrlog(systemEnvironment), this.getExpectedRuntime(systemEnvironment), this.getExpectedFinaltime(systemEnvironment), this.getGetExpectedRuntime(systemEnvironment), this.getPriority(systemEnvironment), this.getMinPriority(systemEnvironment), this.getAgingAmount(systemEnvironment), this.getAgingBase(systemEnvironment), this.getSubmitSuspended(systemEnvironment), this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), this.getMasterSubmittable(systemEnvironment), this.getTimeoutAmount(systemEnvironment), this.getTimeoutBase(systemEnvironment), this.getTimeoutStateId(systemEnvironment), this.getSameNode(systemEnvironment), this.getGangSchedule(systemEnvironment), this.getDependencyOperation(systemEnvironment), this.getEsmpId(systemEnvironment), this.getEspId(systemEnvironment), this.getQaId(systemEnvironment), l3, (Long)comparable2, this.getInheritPrivs(systemEnvironment));
        Long l4 = sDMSProxy2.getId(systemEnvironment);
        Vector vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l2);
        for (Object object102 : vector) {
            object9 = ((SDMSResourceRequirementProxyGeneric)object102).getNrId(systemEnvironment);
            object8 = SDMSNamedResourceTable.getObject(systemEnvironment, (Long)object9);
            if (!((SDMSNamedResourceProxyGeneric)object8).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(((SDMSNamedResourceProxyGeneric)object8).accessViolationMessage(systemEnvironment, "03402291155"));
            }
            object7 = SDMSResourceRequirementTable.table.create(systemEnvironment, (Long)object9, l4, ((SDMSResourceRequirementProxyGeneric)object102).getAmount(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getKeepMode(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getIsSticky(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getStickyName(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getStickyParent(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getRsmpId(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getExpiredAmount(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getExpiredBase(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getIgnoreOnRerun(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getLockmode(systemEnvironment), ((SDMSResourceRequirementProxyGeneric)object102).getCondition(systemEnvironment));
            object6 = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, ((SDMSProxy)object102).getId(systemEnvironment));
            iterator = ((Vector)object6).iterator();
            while (iterator.hasNext()) {
                object5 = (SDMSResourceReqStates)iterator.next();
                SDMSResourceReqStatesTable.table.create(systemEnvironment, ((SDMSProxy)object7).getId(systemEnvironment), ((SDMSResourceReqStatesProxyGeneric)object5).getRsdId(systemEnvironment));
            }
        }
        object102 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l2);
        object9 = ((Vector)object102).iterator();
        while (object9.hasNext()) {
            object8 = (SDMSParameterDefinition)object9.next();
            object7 = SDMSParameterDefinitionTable.table.create(systemEnvironment, l4, ((SDMSParameterDefinitionProxyGeneric)object8).getName(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object8).getType(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object8).getAggFunction(systemEnvironment), ((SDMSParameterDefinition)object8).getDefaultValue(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object8).getIsLocal(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object8).getLinkPdId(systemEnvironment), ((SDMSParameterDefinitionProxyGeneric)object8).getExportName(systemEnvironment));
            if (hashMap == null) continue;
            hashMap.put(((SDMSProxy)object8).getId(systemEnvironment), ((SDMSProxy)object7).getId(systemEnvironment));
        }
        object8 = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l2);
        object7 = ((Vector)object8).iterator();
        while (object7.hasNext()) {
            object6 = (SDMSDependencyDefinition)object7.next();
            iterator = SDMSDependencyDefinitionTable.table.create(systemEnvironment, l4, ((SDMSDependencyDefinitionProxyGeneric)object6).getSeRequiredId(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getName(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getUnresolvedHandling(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getMode(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getStateSelection(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getCondition(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getResolveMode(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getExpiredAmount(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getExpiredBase(systemEnvironment), ((SDMSDependencyDefinitionProxyGeneric)object6).getSelectCondition(systemEnvironment));
            object5 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, ((SDMSProxy)object6).getId(systemEnvironment));
            object4 = ((Vector)object5).iterator();
            while (object4.hasNext()) {
                object3 = (SDMSDependencyState)object4.next();
                SDMSDependencyStateTable.table.create(systemEnvironment, ((SDMSProxy)((Object)iterator)).getId(systemEnvironment), ((SDMSDependencyStateProxyGeneric)object3).getEsdId(systemEnvironment), ((SDMSDependencyStateProxyGeneric)object3).getCondition(systemEnvironment));
            }
        }
        object6 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l2);
        iterator = ((Vector)object6).iterator();
        while (iterator.hasNext()) {
            object5 = (SDMSSchedulingHierarchy)iterator.next();
            object4 = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)object5).getSeChildId(systemEnvironment));
            if (!((SDMSSchedulingEntityProxyGeneric)object4).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(((SDMSSchedulingEntityProxyGeneric)object4).accessViolationMessage(systemEnvironment, "03402292318"));
            }
            SDMSSchedulingHierarchyTable.table.create(systemEnvironment, l4, ((SDMSSchedulingHierarchyProxyGeneric)object5).getSeChildId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getAliasName(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getIsStatic(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getIsDisabled(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getPriority(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getSuspend(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getResumeAt(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getResumeIn(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getResumeBase(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getMergeMode(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getEstpId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getIntId(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getEnableCondition(systemEnvironment), ((SDMSSchedulingHierarchyProxyGeneric)object5).getEnableMode(systemEnvironment));
        }
        boolean bl = false;
        object4 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l2);
        do {
            object3 = ((Vector)object4).iterator();
            while (object3.hasNext()) {
                Object object112;
                object2 = (SDMSTrigger)object3.next();
                object = ((SDMSTriggerProxyGeneric)object2).getIsInverse(systemEnvironment);
                if ((Boolean)object != bl) continue;
                sDMSProxy = SDMSTriggerTable.table.create(systemEnvironment, ((SDMSTriggerProxyGeneric)object2).getName(systemEnvironment), bl ? ((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment) : l4, ((SDMSTriggerProxyGeneric)object2).getObjectType(systemEnvironment), bl ? l4 : ((SDMSTriggerProxyGeneric)object2).getSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getMainSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getParentSeId(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsActive(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsInverse(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getAction(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getType(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsMaster(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsSuspend(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsCreate(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsChange(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsDelete(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsGroup(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getResumeAt(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getResumeIn(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getResumeBase(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getIsWarnOnLimit(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getLimitState(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getMaxRetry(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getSubmitOwnerId(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getCondition(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getCheckAmount(systemEnvironment), ((SDMSTriggerProxyGeneric)object2).getCheckBase(systemEnvironment));
                comparable = sDMSProxy.getId(systemEnvironment);
                Vector vector2 = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, ((SDMSProxy)object2).getId(systemEnvironment));
                for (Object object112 : vector2) {
                    SDMSTriggerStateTable.table.create(systemEnvironment, (Long)comparable, ((SDMSTriggerStateProxyGeneric)object112).getFromStateId(systemEnvironment), ((SDMSTriggerStateProxyGeneric)object112).getToStateId(systemEnvironment));
                }
                object112 = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, ((SDMSProxy)object2).getId(systemEnvironment));
                Iterator iterator2 = ((Vector)object112).iterator();
                while (iterator2.hasNext()) {
                    SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)iterator2.next();
                    SDMSTriggerParameterTable.table.create(systemEnvironment, sDMSTriggerParameter.getName(systemEnvironment), sDMSTriggerParameter.getExpression(systemEnvironment), (Long)comparable);
                }
            }
            if (bl) continue;
            object4 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l2);
        } while (bl = !bl);
        object3 = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, l2);
        object2 = ((Vector)object3).iterator();
        while (object2.hasNext()) {
            object = (SDMSResourceTemplate)object2.next();
            sDMSProxy = SDMSResourceTemplateTable.table.create(systemEnvironment, ((SDMSResourceTemplateProxyGeneric)object).getNrId(systemEnvironment), l4, ((SDMSResourceTemplateProxyGeneric)object).getOwnerId(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getRsdId(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getRequestableAmount(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getAmount(systemEnvironment), ((SDMSResourceTemplateProxyGeneric)object).getIsOnline(systemEnvironment));
            ((SDMSResourceTemplate)object).copyVariables(systemEnvironment, sDMSProxy.getId(systemEnvironment));
        }
        object = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, l2);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            comparable = (SDMSObjectComment)((Vector)object).get(i);
            SDMSObjectCommentTable.table.create(systemEnvironment, l4, comparable.getObjectType(systemEnvironment), comparable.getInfoType(systemEnvironment), comparable.getSequenceNumber(systemEnvironment), comparable.getTag(systemEnvironment), comparable.getDescription(systemEnvironment));
        }
        return sDMSProxy2;
    }

    public void relocateDetails(SystemEnvironment systemEnvironment, HashMap hashMap) throws SDMSException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object82;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l);
        for (Object object82 : vector) {
            object7 = (Long)hashMap.get(((SDMSDependencyDefinitionProxyGeneric)object82).getSeRequiredId(systemEnvironment));
            if (object7 == null) continue;
            ((SDMSDependencyDefinitionProxyGeneric)object82).setSeRequiredId(systemEnvironment, (Long)object7);
        }
        object82 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
        object7 = ((Vector)object82).iterator();
        while (object7.hasNext()) {
            object6 = (SDMSSchedulingHierarchy)object7.next();
            object5 = (Long)hashMap.get(((SDMSSchedulingHierarchyProxyGeneric)object6).getSeChildId(systemEnvironment));
            if (object5 == null) continue;
            ((SDMSSchedulingHierarchyProxyGeneric)object6).setSeChildId(systemEnvironment, (Long)object5);
        }
        object6 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        object5 = ((Vector)object6).iterator();
        while (object5.hasNext()) {
            object4 = (SDMSParameterDefinition)object5.next();
            object3 = (Long)hashMap.get(((SDMSParameterDefinitionProxyGeneric)object4).getLinkPdId(systemEnvironment));
            if (object3 == null) continue;
            ((SDMSParameterDefinition)object4).setLinkPdId(systemEnvironment, (Long)object3);
        }
        object4 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            object2 = (SDMSTrigger)object3.next();
            object = (Long)hashMap.get(((SDMSTriggerProxyGeneric)object2).getSeId(systemEnvironment));
            if (object == null) continue;
            ((SDMSTriggerProxyGeneric)object2).setSeId(systemEnvironment, (Long)object);
        }
        object4 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            object2 = (SDMSTrigger)object3.next();
            object = (Long)hashMap.get(((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment));
            if (object == null) continue;
            ((SDMSTriggerProxyGeneric)object2).setFireId(systemEnvironment, (Long)object);
        }
        object2 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)object.next();
            Long l2 = sDMSResourceRequirement.getStickyParent(systemEnvironment);
            if (l2 == null || (l2 = (Long)hashMap.get(l2)) == null) continue;
            sDMSResourceRequirement.setStickyParent(systemEnvironment, l2);
        }
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser() && l2 != l) {
            long l3;
            long l4 = this.getInheritPrivs(systemEnvironment);
            if ((l & 4L) != 0L) {
                l4 |= 4L;
            }
            if ((l2 | (l3 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4)) != l && bl) {
                return 0L;
            }
            Long l5 = this.getFolderId(systemEnvironment);
            if (l5 != null && l3 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l5);
                long l6 = (l3 & 4L) != 0L ? l3 & 0xFFFFFFFFFFFFFFFBL | 2L : l3;
                if (((l6 = sDMSFolder.getPrivileges(systemEnvironment, l6, bl, vector)) & 2L) != 0L) {
                    l6 |= 4L;
                }
                l2 |= l6 & l4;
            }
            l2 &= l;
        }
        return l2;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        long l3 = super.getPrivileges(systemEnvironment, l, bl, vector, l2);
        if (systemEnvironment.cEnv.isUser() && l3 != l) {
            long l4;
            long l5 = 0L;
            try {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getId(systemEnvironment));
                l5 = sDMSSchedulingEntity.getInheritPrivs(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if ((l & 4L) != 0L) {
                l5 |= 4L;
            }
            if ((l3 | (l4 = l & (l3 ^ 0xFFFFFFFFFFFFFFFFL) & l5)) != l && bl) {
                return 0L;
            }
            Long l6 = this.getFolderId(systemEnvironment);
            if (l6 != null && l4 != 0L) {
                SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l6, l2);
                long l7 = (l4 & 4L) != 0L ? l4 & 0xFFFFFFFFFFFFFFFBL | 2L : l4;
                if (((l7 = sDMSFolder.getPrivileges(systemEnvironment, l7, bl, vector, l2)) & 2L) != 0L) {
                    l7 |= 4L;
                }
                l3 |= l7 & l5;
            }
            if ((l3 & 0x100000L) == 0x100000L) {
                l3 |= 0x10000000L;
            }
            if ((l3 & 0x10000L) == 65536L) {
                l3 |= 0x1000L;
            }
            l3 &= l;
        }
        return l3;
    }

    public void checkSubmitForGroup(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = systemEnvironment.cEnv.uid();
        if (systemEnvironment.cEnv.isUser()) {
            if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(SDMSObject.adminGId, l2))) {
                if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l, l2))) {
                    SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180823", "User $1 does not belong to Group $2", (Object)sDMSUser.getName(systemEnvironment), (Object)sDMSGroup.getName(systemEnvironment)));
                }
                Long l3 = this.getOwnerId(systemEnvironment);
                if (!SDMSMemberTable.idx_gId_uId.containsKey(systemEnvironment, new SDMSKey(l3, l2))) {
                    Vector<Long> vector = new Vector<Long>();
                    vector.add(l);
                    SDMSPrivilege sDMSPrivilege = this.getPrivilegesForGroups(systemEnvironment, vector);
                    if (!sDMSPrivilege.can(0x100000L)) {
                        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, l2);
                        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02402180938", "User $1 not allowed to submit $2 for group $3", sDMSUser.getName(systemEnvironment), this.pathString(systemEnvironment), sDMSGroup.getName(systemEnvironment)));
                    }
                }
            }
        } else {
            Vector<Long> vector = new Vector<Long>();
            vector.add(l);
            vector.add(SDMSObject.publicGId);
            systemEnvironment.cEnv.setUser();
            try {
                SDMSPrivilege sDMSPrivilege = this.getPrivilegesForGroups(systemEnvironment, vector);
                if (!sDMSPrivilege.can(0x100000L)) {
                    SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03801291413", "Job $1 not allowed to submit $2 from group $3", l2, this.pathString(systemEnvironment), sDMSGroup.getName(systemEnvironment)));
                }
            }
            catch (SDMSException sDMSException) {
                throw sDMSException;
            }
            finally {
                systemEnvironment.cEnv.setJob();
            }
        }
    }

    public void removeFromTimeScheduling(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSEventTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSEvent sDMSEvent = (SDMSEvent)vector.get(i);
            Vector vector2 = SDMSScheduledEventTable.idx_evtId.getVector(systemEnvironment, sDMSEvent.getId(systemEnvironment));
            for (int j = 0; j < vector2.size(); ++j) {
                comparable = (SDMSScheduledEvent)vector2.get(j);
                ((SDMSScheduledEvent)comparable).delete(systemEnvironment);
            }
            sDMSEvent.delete(systemEnvironment);
        }
        Vector vector3 = null;
        boolean bl = false;
        while (!bl) {
            bl = true;
            vector3 = SDMSScheduleTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector3.size(); ++i) {
                SDMSSchedule sDMSSchedule = (SDMSSchedule)vector3.get(i);
                comparable = sDMSSchedule.getId(systemEnvironment);
                if (SDMSScheduledEventTable.idx_sceId.containsKey(systemEnvironment, comparable) || SDMSScheduleTable.idx_parentId.containsKey(systemEnvironment, comparable)) continue;
                sDMSSchedule.delete(systemEnvironment);
                bl = false;
            }
        }
        if (vector3 != null) {
            for (int i = 0; i < vector3.size(); ++i) {
                SDMSSchedule sDMSSchedule = (SDMSSchedule)vector3.get(i);
                sDMSSchedule.setSeId(systemEnvironment, null);
            }
        }
        Vector vector4 = null;
        bl = false;
        while (!bl) {
            bl = true;
            vector4 = SDMSIntervalTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                comparable = (SDMSInterval)vector4.get(i);
                Long l2 = ((SDMSProxy)comparable).getId(systemEnvironment);
                if (SDMSIntervalTable.idx_embeddedIntervalId.containsKey(systemEnvironment, l2)) continue;
                if (SDMSScheduleTable.idx_intId.containsKey(systemEnvironment, l2)) {
                    ((SDMSIntervalProxyGeneric)comparable).setSeId(systemEnvironment, null);
                    continue;
                }
                if (SDMSIntervalHierarchyTable.idx_childId.containsKey(systemEnvironment, l2)) continue;
                IntervalUtil.killFilter(systemEnvironment, l2);
                IntervalUtil.killSelections(systemEnvironment, l2);
                IntervalUtil.killDispatcher(systemEnvironment, l2);
                ((SDMSInterval)comparable).delete(systemEnvironment);
                bl = false;
            }
        }
        if (vector4 != null) {
            for (int i = 0; i < vector4.size(); ++i) {
                comparable = (SDMSInterval)vector4.get(i);
                ((SDMSIntervalProxyGeneric)comparable).setSeId(systemEnvironment, null);
            }
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.delete(systemEnvironment, false);
    }

    private void doDelete(SystemEnvironment systemEnvironment) throws SDMSException {
        super.delete(systemEnvironment);
    }

    public void delete(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(this.getId(systemEnvironment));
        SDMSSchedulingEntity.delete(systemEnvironment, hashSet, bl);
    }

    public static void delete(SystemEnvironment systemEnvironment, HashSet<Long> hashSet, boolean bl) throws SDMSException {
        for (Long l : hashSet) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
            Vector vector = SDMSNiceProfileEntryTable.idx_folderId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSNiceProfileEntry sDMSNiceProfileEntry = (SDMSNiceProfileEntry)vector.get(i);
                if (sDMSNiceProfileEntry.getIsActive(systemEnvironment).booleanValue()) {
                    SDMSNiceProfile sDMSNiceProfile = SDMSNiceProfileTable.getObject(systemEnvironment, sDMSNiceProfileEntry.getNpId(systemEnvironment));
                    if (!sDMSNiceProfile.getIsActive(systemEnvironment).booleanValue()) {
                        sDMSNiceProfileEntry.delete(systemEnvironment);
                        continue;
                    }
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408211534", "Job Definition $1 is addressed by active Nice Profile $2", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)sDMSNiceProfile.getName(systemEnvironment)));
                }
                sDMSNiceProfileEntry.delete(systemEnvironment);
            }
            Vector vector2 = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector2.size(); ++i) {
                ((SDMSDependencyDefinition)vector2.get(i)).delete(systemEnvironment);
            }
            Vector vector3 = SDMSDependencyDefinitionTable.idx_seRequiredId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector3.size(); ++i) {
                object8 = (SDMSDependencyDefinition)vector3.get(i);
                if (hashSet.contains(((SDMSDependencyDefinitionProxyGeneric)object8).getSeDependentId(systemEnvironment))) continue;
                if (!bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112202113", "$1 is required by $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSDependencyDefinitionProxyGeneric)object8).getSeDependentId(systemEnvironment)).pathString(systemEnvironment)));
                }
                ((SDMSDependencyDefinition)object8).delete(systemEnvironment);
            }
            Vector vector4 = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                object7 = (SDMSSchedulingHierarchy)vector4.get(i);
                ((SDMSSchedulingHierarchy)object7).delete(systemEnvironment);
            }
            object8 = SDMSSchedulingHierarchyTable.idx_seChildId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object8).size(); ++i) {
                object6 = (SDMSSchedulingHierarchy)((Vector)object8).get(i);
                if (hashSet.contains(((SDMSSchedulingHierarchyProxyGeneric)object6).getSeParentId(systemEnvironment))) continue;
                if (!bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042302", "$1 is used as a child of $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSchedulingHierarchyProxyGeneric)object6).getSeParentId(systemEnvironment)).pathString(systemEnvironment)));
                }
                ((SDMSSchedulingHierarchy)object6).delete(systemEnvironment);
            }
            object7 = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object7).size(); ++i) {
                ((SDMSResourceRequirement)((Vector)object7).get(i)).delete(systemEnvironment);
            }
            object6 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object6).size(); ++i) {
                object5 = (SDMSParameterDefinition)((Vector)object6).get(i);
                ((SDMSParameterDefinition)object5).delete(systemEnvironment, hashSet, bl);
            }
            Vector vector5 = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector5.size(); ++i) {
                object4 = (SDMSTrigger)vector5.get(i);
                if (((SDMSTriggerProxyGeneric)object4).getIsInverse(systemEnvironment).booleanValue()) {
                    if (hashSet.contains(((SDMSTriggerProxyGeneric)object4).getSeId(systemEnvironment))) continue;
                    if (!bl) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042303", "$1 is used as triggering job of $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object4).getSeId(systemEnvironment)).pathString(systemEnvironment)));
                    }
                }
                ((SDMSTrigger)object4).delete(systemEnvironment);
            }
            object5 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object5).size(); ++i) {
                object3 = (SDMSTrigger)((Vector)object5).get(i);
                if (!((SDMSTriggerProxyGeneric)object3).getIsInverse(systemEnvironment).booleanValue()) {
                    if (hashSet.contains(((SDMSTriggerProxyGeneric)object3).getFireId(systemEnvironment))) continue;
                    if (!bl) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207042304", "$1 triggered by $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object3).getFireId(systemEnvironment)).pathString(systemEnvironment)));
                    }
                }
                ((SDMSTrigger)object3).delete(systemEnvironment);
            }
            object4 = SDMSTriggerTable.idx_mainSeId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                object2 = (SDMSTrigger)((Vector)object4).get(i);
                if (!bl) {
                    object = SDMSObjectMonitorTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object2).getFireId(systemEnvironment));
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109120829", "$1 is used as a trigger job (mainSe) of object monitor $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)((SDMSObjectMonitorProxyGeneric)object).getName(systemEnvironment)));
                }
                ((SDMSTrigger)object2).delete(systemEnvironment);
            }
            object3 = SDMSTriggerTable.idx_parentSeId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object = (SDMSTrigger)((Vector)object3).get(i);
                if (!bl) {
                    SDMSObjectMonitor sDMSObjectMonitor = SDMSObjectMonitorTable.getObject(systemEnvironment, ((SDMSTriggerProxyGeneric)object).getFireId(systemEnvironment));
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109120830", "$1 is used as a trigger job (parentSe) of object monitor $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)sDMSObjectMonitor.getName(systemEnvironment)));
                }
                ((SDMSTrigger)object).delete(systemEnvironment);
            }
            object2 = SDMSObjectMonitorTable.idx_watchSeId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                SDMSObjectMonitor sDMSObjectMonitor = (SDMSObjectMonitor)((Vector)object2).get(i);
                if (!bl) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109121002", "$1 is used as a watch job of object monitor $2, specify force to delete anyway", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)sDMSObjectMonitor.getName(systemEnvironment)));
                }
                sDMSObjectMonitor.setWatchSeId(systemEnvironment, null);
            }
            object = SDMSResourceTemplateTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SDMSResourceTemplate sDMSResourceTemplate = (SDMSResourceTemplate)((Vector)object).get(i);
                sDMSResourceTemplate.delete(systemEnvironment);
            }
            sDMSSchedulingEntity.removeFromTimeScheduling(systemEnvironment);
            sDMSSchedulingEntity.doDelete(systemEnvironment);
        }
    }

    public String pathString(SystemEnvironment systemEnvironment, long l, HashMap hashMap) throws SDMSException {
        if (hashMap == null) {
            return this.pathString(systemEnvironment, l);
        }
        Long l2 = this.getId(systemEnvironment);
        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, this.getFolderId(systemEnvironment), l);
        String string = sDMSFolder.pathString(systemEnvironment, l, hashMap) + '.' + this.getName(systemEnvironment);
        return string;
    }
}

