/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSScopeGeneric
extends SDMSObject
implements Cloneable {
    public static final int SCOPE = 1;
    public static final int SERVER = 2;
    public static final int MD5 = 0;
    public static final int SHA256 = 1;
    public static final int NOMINAL = 1;
    public static final int NONFATAL = 2;
    public static final int FATAL = 3;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_parentId = 4;
    public static final int nr_type = 5;
    public static final int nr_isTerminate = 6;
    public static final int nr_hasAlteredConfig = 7;
    public static final int nr_isSuspended = 8;
    public static final int nr_isEnabled = 9;
    public static final int nr_isRegistered = 10;
    public static final int nr_state = 11;
    public static final int nr_passwd = 12;
    public static final int nr_salt = 13;
    public static final int nr_method = 14;
    public static final int nr_pid = 15;
    public static final int nr_node = 16;
    public static final int nr_errmsg = 17;
    public static final int nr_lastActive = 18;
    public static final int nr_creatorUId = 19;
    public static final int nr_createTs = 20;
    public static final int nr_changerUId = 21;
    public static final int nr_changeTs = 22;
    public static final int nr_inheritPrivs = 23;
    public static String tableName = "SCOPE";
    protected String name;
    protected Long ownerId;
    protected Long parentId;
    protected Integer type;
    protected Boolean isTerminate;
    protected Boolean hasAlteredConfig;
    protected Boolean isSuspended;
    protected Boolean isEnabled;
    protected Boolean isRegistered;
    protected Integer state;
    protected String passwd;
    protected String salt;
    protected Integer method;
    protected String pid;
    protected String node;
    protected String errmsg;
    protected Long lastActive;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    protected Long inheritPrivs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSScopeGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Integer n2, String string2, String string3, Integer n3, String string4, String string5, String string6, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSScopeTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Scope) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.ownerId = l;
        this.parentId = l2;
        this.type = n;
        this.isTerminate = bl;
        this.hasAlteredConfig = bl2;
        this.isSuspended = bl3;
        this.isEnabled = bl4;
        this.isRegistered = bl5;
        this.state = n2;
        if (string2 != null && string2.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Scope) Length of $1 exceeds maximum length $2", (Object)"passwd", (Object)"64"));
        }
        this.passwd = string2;
        if (string3 != null && string3.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Scope) Length of $1 exceeds maximum length $2", (Object)"salt", (Object)"64"));
        }
        this.salt = string3;
        this.method = n3;
        if (string4 != null && string4.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Scope) Length of $1 exceeds maximum length $2", (Object)"pid", (Object)"32"));
        }
        this.pid = string4;
        if (string5 != null && string5.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Scope) Length of $1 exceeds maximum length $2", (Object)"node", (Object)"64"));
        }
        this.node = string5;
        if (string6 != null && string6.length() > 256) {
            string6 = string6.substring(0, 256);
        }
        this.errmsg = string6;
        this.lastActive = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.inheritPrivs = l8;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
            }
            SDMSScopeGeneric sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Scope) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSScopeGeneric.name = string;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 16L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            SDMSScopeGeneric sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            sDMSScopeGeneric.ownerId = l;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentId)) {
            return;
        }
        if (l == null && this.parentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
            }
            SDMSScopeGeneric sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            sDMSScopeGeneric.parentId = l;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 18L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.type;
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getType(systemEnvironment);
        switch (n) {
            case 1: {
                return "SCOPE";
            }
            case 2: {
                return "SERVER";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Scope.type: $1", (Object)this.getType(systemEnvironment)));
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.type.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
            }
            SDMSScopeGeneric sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            sDMSScopeGeneric.type = n;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsTerminate(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isTerminate;
    }

    public void setIsTerminate(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isTerminate)) {
            return;
        }
        if (bl == null && this.isTerminate == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.isTerminate = bl;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Boolean getHasAlteredConfig(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.hasAlteredConfig;
    }

    public void setHasAlteredConfig(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.hasAlteredConfig)) {
            return;
        }
        if (bl == null && this.hasAlteredConfig == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.hasAlteredConfig = bl;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Boolean getIsSuspended(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSuspended;
    }

    public void setIsSuspended(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isSuspended)) {
            return;
        }
        if (bl == null && this.isSuspended == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.isSuspended = bl;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Boolean getIsEnabled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isEnabled;
    }

    public void setIsEnabled(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isEnabled)) {
            return;
        }
        if (bl == null && this.isEnabled == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.isEnabled = bl;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Boolean getIsRegistered(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isRegistered;
    }

    public void setIsRegistered(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (bl != null && bl.equals(this.isRegistered)) {
            return;
        }
        if (bl == null && this.isRegistered == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.isRegistered = bl;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Integer getState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.state;
    }

    public String getStateAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getState(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "NOMINAL";
            }
            case 2: {
                return "NONFATAL";
            }
            case 3: {
                return "FATAL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Scope.state: $1", (Object)this.getState(systemEnvironment)));
    }

    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.state)) {
            return;
        }
        if (n == null && this.state == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.state = n;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public String getPasswd(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.passwd;
    }

    public void setPasswd(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.passwd)) {
            return;
        }
        if (string == null && this.passwd == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Scope) Length of $1 exceeds maximum length $2", (Object)"passwd", (Object)"64"));
        }
        sDMSScopeGeneric.passwd = string;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public String getSalt(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.salt;
    }

    public void setSalt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.salt)) {
            return;
        }
        if (string == null && this.salt == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Scope) Length of $1 exceeds maximum length $2", (Object)"salt", (Object)"64"));
        }
        sDMSScopeGeneric.salt = string;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Integer getMethod(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.method;
    }

    public String getMethodAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMethod(systemEnvironment);
        switch (n) {
            case 0: {
                return "MD5";
            }
            case 1: {
                return "SHA256";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Scope.method: $1", (Object)this.getMethod(systemEnvironment)));
    }

    public void setMethod(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.method.equals(n)) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.method = n;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public String getPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pid;
    }

    public void setPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.pid)) {
            return;
        }
        if (string == null && this.pid == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Scope) Length of $1 exceeds maximum length $2", (Object)"pid", (Object)"32"));
        }
        sDMSScopeGeneric.pid = string;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public String getNode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.node;
    }

    public void setNode(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.node)) {
            return;
        }
        if (string == null && this.node == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
            }
            SDMSScopeGeneric sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Scope) Length of $1 exceeds maximum length $2", (Object)"node", (Object)"64"));
            }
            sDMSScopeGeneric.node = string;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getErrmsg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errmsg;
    }

    public void setErrmsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errmsg)) {
            return;
        }
        if (string == null && this.errmsg == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            string = string.substring(0, 256);
        }
        sDMSScopeGeneric.errmsg = string;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getLastActive(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.lastActive;
    }

    public void setLastActive(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.lastActive)) {
            return;
        }
        if (l == null && this.lastActive == null) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.lastActive = l;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.creatorUId = l;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.createTs = l;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.changerUId = l;
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.changeTs = l;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.inheritPrivs;
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.inheritPrivs.equals(l)) {
            return;
        }
        SDMSScopeGeneric sDMSScopeGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Scope) Change of system object not allowed"));
        }
        if (sDMSScopeGeneric.versions.o_v == null || sDMSScopeGeneric.versions.o_v.size() == 0 || sDMSScopeGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
        }
        sDMSScopeGeneric.inheritPrivs = l;
        sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSScopeGeneric != this) {
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric, 0L);
        }
    }

    public SDMSScopeGeneric set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSScopeGeneric sDMSScopeGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Scope) Change of system object not allowed"));
            }
            sDMSScopeGeneric = (SDMSScopeGeneric)this.change(systemEnvironment);
            sDMSScopeGeneric.parentId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(Scope) Length of $1 exceeds maximum length $2", (Object)"inheritPrivs", (Object)"64"));
            }
            sDMSScopeGeneric.name = string;
            sDMSScopeGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSScopeGeneric.changeTs = systemEnvironment.txTime();
            sDMSScopeGeneric.versions.table.index(systemEnvironment, sDMSScopeGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSScopeGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSScope(this);
    }

    protected SDMSScopeGeneric(Long l, String string, Long l2, Long l3, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Integer n2, String string2, String string3, Integer n3, String string4, String string5, String string6, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.parentId = l3;
        this.type = n;
        this.isTerminate = bl;
        this.hasAlteredConfig = bl2;
        this.isSuspended = bl3;
        this.isEnabled = bl4;
        this.isRegistered = bl5;
        this.state = n2;
        this.passwd = string2;
        this.salt = string3;
        this.method = n3;
        this.pid = string4;
        this.node = string5;
        this.errmsg = string6;
        this.lastActive = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.inheritPrivs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SCOPE" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "PARENT_ID" + string3 + ", " + string2 + "TYPE" + string3 + ", " + string2 + "IS_TERMINATE" + string3 + ", " + string2 + "HAS_ALTEREDCONFIG" + string3 + ", " + string2 + "IS_SUSPENDED" + string3 + ", " + string2 + "IS_ENABLED" + string3 + ", " + string2 + "IS_REGISTERED" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "PASSWD" + string3 + ", " + string2 + "SALT" + string3 + ", " + string2 + "METHOD" + string3 + ", " + string2 + "PID" + string3 + ", " + string2 + "NODE" + string3 + ", " + string2 + "ERRMSG" + string3 + ", " + string2 + "LAST_ACTIVE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", " + string2 + "INHERIT_PRIVS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSScopeGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Scope: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.parentId);
            }
            preparedStatement.setInt(5, this.type);
            if (this.isTerminate == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.isTerminate != false ? 1 : 0);
            }
            if (this.hasAlteredConfig == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.hasAlteredConfig != false ? 1 : 0);
            }
            if (this.isSuspended == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.isSuspended != false ? 1 : 0);
            }
            if (this.isEnabled == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.isEnabled != false ? 1 : 0);
            }
            if (this.isRegistered == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.isRegistered != false ? 1 : 0);
            }
            if (this.state == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setInt(11, this.state);
            }
            if (this.passwd == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.passwd);
            }
            if (this.salt == null) {
                preparedStatement.setNull(13, 12);
            } else {
                preparedStatement.setString(13, this.salt);
            }
            preparedStatement.setInt(14, this.method);
            if (this.pid == null) {
                preparedStatement.setNull(15, 12);
            } else {
                preparedStatement.setString(15, this.pid);
            }
            if (this.node == null) {
                preparedStatement.setNull(16, 12);
            } else {
                preparedStatement.setString(16, this.node);
            }
            if (this.errmsg == null) {
                preparedStatement.setNull(17, 12);
            } else {
                preparedStatement.setString(17, this.errmsg);
            }
            if (this.lastActive == null) {
                preparedStatement.setNull(18, 4);
            } else {
                preparedStatement.setLong(18, this.lastActive);
            }
            preparedStatement.setLong(19, this.creatorUId);
            preparedStatement.setLong(20, this.createTs);
            preparedStatement.setLong(21, this.changerUId);
            preparedStatement.setLong(22, this.changeTs);
            preparedStatement.setLong(23, this.inheritPrivs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Scope: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SCOPE" + string3 + " WHERE ID = ?";
                SDMSScopeGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Scope: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Scope: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SCOPE" + string3 + " SET " + string2 + "NAME" + string3 + " = ? , " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "PARENT_ID" + string3 + " = ? , " + string2 + "TYPE" + string3 + " = ? , " + string2 + "IS_TERMINATE" + string3 + " = ? , " + string2 + "HAS_ALTEREDCONFIG" + string3 + " = ? , " + string2 + "IS_SUSPENDED" + string3 + " = ? , " + string2 + "IS_ENABLED" + string3 + " = ? , " + string2 + "IS_REGISTERED" + string3 + " = ? , " + string2 + "STATE" + string3 + " = ? , " + string2 + "PASSWD" + string3 + " = ? , " + string2 + "SALT" + string3 + " = ? , " + string2 + "METHOD" + string3 + " = ? , " + string2 + "PID" + string3 + " = ? , " + string2 + "NODE" + string3 + " = ? , " + string2 + "ERRMSG" + string3 + " = ? , " + string2 + "LAST_ACTIVE" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? , " + string2 + "INHERIT_PRIVS" + string3 + " = ? WHERE ID = ?";
                SDMSScopeGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Scope: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.parentId);
            }
            preparedStatement.setInt(4, this.type);
            if (this.isTerminate == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.isTerminate != false ? 1 : 0);
            }
            if (this.hasAlteredConfig == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.hasAlteredConfig != false ? 1 : 0);
            }
            if (this.isSuspended == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.isSuspended != false ? 1 : 0);
            }
            if (this.isEnabled == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.isEnabled != false ? 1 : 0);
            }
            if (this.isRegistered == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.isRegistered != false ? 1 : 0);
            }
            if (this.state == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.state);
            }
            if (this.passwd == null) {
                preparedStatement.setNull(11, 12);
            } else {
                preparedStatement.setString(11, this.passwd);
            }
            if (this.salt == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.salt);
            }
            preparedStatement.setInt(13, this.method);
            if (this.pid == null) {
                preparedStatement.setNull(14, 12);
            } else {
                preparedStatement.setString(14, this.pid);
            }
            if (this.node == null) {
                preparedStatement.setNull(15, 12);
            } else {
                preparedStatement.setString(15, this.node);
            }
            if (this.errmsg == null) {
                preparedStatement.setNull(16, 12);
            } else {
                preparedStatement.setString(16, this.errmsg);
            }
            if (this.lastActive == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setLong(17, this.lastActive);
            }
            preparedStatement.setLong(18, this.creatorUId);
            preparedStatement.setLong(19, this.createTs);
            preparedStatement.setLong(20, this.changerUId);
            preparedStatement.setLong(21, this.changeTs);
            preparedStatement.setLong(22, this.inheritPrivs);
            preparedStatement.setLong(23, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Scope: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkType(Integer n) {
        switch (n) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkState(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkMethod(Integer n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Scope", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "type : " + this.type, 2);
        SDMSThread.doTrace(null, "isTerminate : " + this.isTerminate, 2);
        SDMSThread.doTrace(null, "hasAlteredConfig : " + this.hasAlteredConfig, 2);
        SDMSThread.doTrace(null, "isSuspended : " + this.isSuspended, 2);
        SDMSThread.doTrace(null, "isEnabled : " + this.isEnabled, 2);
        SDMSThread.doTrace(null, "isRegistered : " + this.isRegistered, 2);
        SDMSThread.doTrace(null, "state : " + this.state, 2);
        SDMSThread.doTrace(null, "passwd : " + this.passwd, 2);
        SDMSThread.doTrace(null, "salt : " + this.salt, 2);
        SDMSThread.doTrace(null, "method : " + this.method, 2);
        SDMSThread.doTrace(null, "pid : " + this.pid, 2);
        SDMSThread.doTrace(null, "node : " + this.node, 2);
        SDMSThread.doTrace(null, "errmsg : " + this.errmsg, 2);
        SDMSThread.doTrace(null, "lastActive : " + this.lastActive, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "inheritPrivs : " + this.inheritPrivs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name             : " + this.name + "\n" + string + "ownerId          : " + this.ownerId + "\n" + string + "parentId         : " + this.parentId + "\n" + string + "type             : " + this.type + "\n" + string + "isTerminate      : " + this.isTerminate + "\n" + string + "hasAlteredConfig : " + this.hasAlteredConfig + "\n" + string + "isSuspended      : " + this.isSuspended + "\n" + string + "isEnabled        : " + this.isEnabled + "\n" + string + "isRegistered     : " + this.isRegistered + "\n" + string + "state            : " + this.state + "\n" + string + "passwd           : " + this.passwd + "\n" + string + "salt             : " + this.salt + "\n" + string + "method           : " + this.method + "\n" + string + "pid              : " + this.pid + "\n" + string + "node             : " + this.node + "\n" + string + "errmsg           : " + this.errmsg + "\n" + string + "lastActive       : " + this.lastActive + "\n" + string + "creatorUId       : " + this.creatorUId + "\n" + string + "createTs         : " + this.createTs + "\n" + string + "changerUId       : " + this.changerUId + "\n" + string + "changeTs         : " + this.changeTs + "\n" + string + "inheritPrivs     : " + this.inheritPrivs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

