/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NonRecoverableException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.SubmitJob;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectEventTable;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameter;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameterTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.util.BoolExpr;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSTrigger
extends SDMSTriggerProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSTrigger.java,v 2.42.2.4 2013/03/22 14:01:55 dieter Exp $";
    private static final HashMap mapper = new HashMap();

    protected SDMSTrigger(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public static Integer map(Integer n) {
        return (Integer)mapper.get(n);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSTriggerState sDMSTriggerState = (SDMSTriggerState)vector.get(i);
            sDMSTriggerState.delete(systemEnvironment);
        }
        Vector vector2 = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)vector2.get(i);
            sDMSTriggerParameter.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    public boolean checkCondition(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        return this.checkCondition(systemEnvironment, null, sDMSSubmittedEntity, sDMSTriggerQueue);
    }

    public boolean checkCondition(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        return this.checkCondition(systemEnvironment, sDMSResource, null, null);
    }

    private boolean checkCondition(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        String string = this.getCondition(systemEnvironment);
        if (string == null) {
            return true;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        return boolExpr.checkCondition(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, this, sDMSTriggerQueue, null);
    }

    public void checkConditionSyntax(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.getCondition(systemEnvironment);
        if (string == null) {
            return;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        boolExpr.checkConditionSyntax(systemEnvironment);
    }

    public void checkParameterExpressionSyntax(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string == null) {
            return;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        boolExpr.checkConditionSyntax(systemEnvironment);
    }

    public String evalExpression(SystemEnvironment systemEnvironment, String string, SDMSResource sDMSResource, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSTriggerQueue sDMSTriggerQueue) throws SDMSException {
        if (string == null || string.equals("")) {
            return "";
        }
        BoolExpr boolExpr = new BoolExpr(string);
        Object object = boolExpr.evalExpression(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, this, sDMSTriggerQueue, null);
        return object.toString();
    }

    public boolean trigger(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSTriggerQueue sDMSTriggerQueue, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Comparable<Long> comparable;
        Comparable<Date> comparable2;
        Number number;
        Comparable<Long> comparable3;
        SDMSProxy sDMSProxy;
        Object object;
        Vector vector;
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return false;
        }
        if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            return false;
        }
        long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        boolean bl = false;
        Long l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        Long l5 = sDMSSubmittedEntity.getId(systemEnvironment);
        int n = this.getType(systemEnvironment);
        Long l6 = this.getId(systemEnvironment);
        long l7 = System.currentTimeMillis();
        int n2 = this.getAction(systemEnvironment);
        HashSet<Object> hashSet = (HashSet<Object>)systemEnvironment.tx.txData.get("TRIGGER_HASH_SET");
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            systemEnvironment.tx.txData.put("TRIGGER_HASH_SET", hashSet);
        }
        boolean bl2 = this.getIsMaster(systemEnvironment);
        Long l8 = null;
        if (n == 7) {
            l8 = l;
            l = null;
        }
        if ((vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, (Object)l6, l3)).size() > 0) {
            object = vector.iterator();
            boolean bl3 = false;
            while (object.hasNext()) {
                sDMSProxy = (SDMSTriggerState)object.next();
                if (!((SDMSTriggerStateProxyGeneric)sDMSProxy).getToStateId(systemEnvironment).equals(l)) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                return bl;
            }
        }
        if (n == 4 && !hashSet.add(object = new SDMSKey(l2, l5, l6))) {
            return bl;
        }
        if (n == 5 || n == 6) {
            if (sDMSTriggerQueue == null) {
                sDMSTriggerQueue = SDMSTriggerQueueTable.idx_smeId_trId_getUnique(systemEnvironment, new SDMSKey(l5, l6));
            }
            long l9 = this.getCheckAmount(systemEnvironment).longValue();
            int n3 = this.getCheckBase(systemEnvironment);
            switch (n3) {
                case 0: {
                    l9 *= 60000L;
                    break;
                }
                case 1: {
                    l9 *= 3600000L;
                    break;
                }
                case 2: {
                    l9 *= 86400000L;
                    break;
                }
                case 3: {
                    l9 *= 604800000L;
                }
            }
            sDMSTriggerQueue.setNextTriggerTime(systemEnvironment, new Long(l7 + l9));
        }
        int n4 = 0;
        if (n != 3) {
            if (n == 5 || n == 6) {
                n4 = sDMSTriggerQueue.getTimesTriggered(systemEnvironment);
            } else if (n2 != 1) {
                Vector vector2 = SDMSSubmittedEntityTable.idx_fireSmeId_trId.getVector(systemEnvironment, new SDMSKey(l5, l6));
                n4 = vector2.size();
            } else {
                n4 = sDMSSubmittedEntity.getRerunSeq(systemEnvironment);
            }
        } else if (!bl2) {
            sDMSProxy = sDMSSubmittedEntity;
            comparable3 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getFireSmeId(systemEnvironment);
            number = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getTrId(systemEnvironment);
            while (comparable3 != null && l6.equals(number)) {
                ++n4;
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, (Long)comparable3);
                comparable3 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getFireSmeId(systemEnvironment);
                number = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getTrId(systemEnvironment);
            }
        } else {
            n4 = 0;
        }
        int n5 = this.getMaxRetry(systemEnvironment);
        if (n2 != 1 || !this.getIsSuspend(systemEnvironment).booleanValue()) {
            if (n5 == 0) {
                n5 = SystemEnvironment.triggerSoftLimit;
            }
            if (n5 > SystemEnvironment.triggerHardLimit) {
                n5 = SystemEnvironment.triggerHardLimit;
            }
        }
        if (n4 >= n5 && n5 != 0) {
            if (this.getIsWarnOnLimit(systemEnvironment).booleanValue()) {
                comparable3 = new Date();
                number = new Long(((Date)comparable3).getTime());
                boolean bl4 = true;
                if (n == 7) {
                    bl4 = false;
                }
                sDMSSubmittedEntity.setWarn(systemEnvironment, new Integer(16), "Triggering of " + this.getName(systemEnvironment) + " failed, limit reached", (Long)number, bl4);
            }
            if ((comparable3 = this.getLimitState(systemEnvironment)) != null) {
                SDMSExitState sDMSExitState;
                number = sDMSSubmittedEntity.getSeId(systemEnvironment);
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, number, l3);
                Long l10 = sDMSSchedulingEntity.getEspId(systemEnvironment);
                try {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l10, comparable3), l3);
                }
                catch (NotFoundException notFoundException) {
                    SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, comparable3);
                    String string = "The limit state " + sDMSExitStateDefinition.getName(systemEnvironment) + " of trigger " + this.getName(systemEnvironment) + " isn't contained in the job's exit state profile";
                    HashSet<Long> hashSet2 = (HashSet<Long>)systemEnvironment.tx.txData.get("TRIGGER_BROKEN_ESD_ID");
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<Long>();
                        systemEnvironment.tx.txData.put("TRIGGER_BROKEN_ESD_ID", hashSet2);
                    }
                    hashSet2.add(sDMSSubmittedEntity.getId(systemEnvironment));
                    sDMSSubmittedEntity.setToError(systemEnvironment, string);
                    SDMSThread.doTrace(systemEnvironment.cEnv, "Definition error in job definition " + sDMSSchedulingEntity.pathString(systemEnvironment) + ": " + string, 1);
                    return bl;
                }
                sDMSSubmittedEntity.changeState(systemEnvironment, (Long)comparable3, sDMSExitState, null, null, null, false);
            }
            return bl;
        }
        boolean bl5 = false;
        try {
            bl5 = this.checkCondition(systemEnvironment, sDMSSubmittedEntity, sDMSTriggerQueue);
        }
        catch (CommonErrorException commonErrorException) {
            comparable2 = new Date();
            comparable = new Long(comparable2.getTime());
            boolean bl6 = true;
            if (n == 7) {
                bl6 = false;
            }
            sDMSSubmittedEntity.setWarn(systemEnvironment, new Integer(16), "Triggering of " + this.getName(systemEnvironment) + " failed : " + commonErrorException.toString(), (Long)comparable, bl6);
        }
        if (sDMSTriggerQueue != null) {
            sDMSTriggerQueue.setTimesChecked(systemEnvironment, new Integer(sDMSTriggerQueue.getTimesChecked(systemEnvironment) + 1));
        }
        if (bl5) {
            number = new Integer(n4 + 1);
            if (n2 == 0) {
                SDMSSubmittedEntity sDMSSubmittedEntity2 = this.triggerSubmit(systemEnvironment, sDMSSubmittedEntity, (Integer)number, n);
                if (sDMSSubmittedEntity2 == null) {
                    return bl;
                }
                bl = true;
                comparable2 = (Long)systemEnvironment.tx.txData.get("BASE_SME_ID");
                if (comparable2 == null) {
                    comparable2 = l2;
                }
                sDMSSubmittedEntity2.setBaseSmeId(systemEnvironment, (Long)comparable2);
                sDMSSubmittedEntity2.setReasonSmeId(systemEnvironment, l2);
                sDMSSubmittedEntity2.setFireSmeId(systemEnvironment, l5);
                sDMSSubmittedEntity2.setFireSeId(systemEnvironment, l4);
                sDMSSubmittedEntity2.setTrId(systemEnvironment, l6);
                sDMSSubmittedEntity2.setTrSdIdNew(systemEnvironment, l);
                sDMSSubmittedEntity2.setTrSeq(systemEnvironment, (Integer)number);
                sDMSSubmittedEntity2.setWarnLink(systemEnvironment, l8);
                if (sDMSTriggerQueue != null) {
                    sDMSTriggerQueue.setTimesTriggered(systemEnvironment, (Integer)number);
                }
                comparable = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    Long l11 = sDMSSubmittedEntity2.getSubmitTs(systemEnvironment);
                    comparable = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l11, true, sDMSSubmittedEntity2.getEffectiveTimeZone(systemEnvironment));
                    sDMSSubmittedEntity2.setResumeTs(systemEnvironment, (Long)comparable);
                }
            } else {
                sDMSSubmittedEntity.rerun(systemEnvironment);
                comparable2 = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    sDMSSubmittedEntity.suspend(systemEnvironment, true, false);
                    comparable = sDMSSubmittedEntity.getFinishTs(systemEnvironment);
                    comparable2 = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), comparable, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
                    sDMSSubmittedEntity.setResumeTs(systemEnvironment, (Long)comparable2);
                }
                comparable = new Date();
                Long l12 = new Long(((Date)comparable).getTime());
                SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l12, new Integer(1), new Integer(17), sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Automatical restart" + (comparable2 == null ? "" : " (suspended with autoresume)"));
            }
        }
        return bl;
    }

    public SDMSSubmittedEntity triggerSubmit(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Integer n, int n2) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity2;
        Serializable serializable;
        SDMSSchedulingEntity sDMSSchedulingEntity;
        Date date = new Date();
        Long l = new Long(date.getTime());
        Long l2 = this.getId(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity3 = null;
        Long l3 = this.getSeId(systemEnvironment);
        Long l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        long l5 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        boolean bl = this.getIsMaster(systemEnvironment);
        String string = null;
        HashSet<Long> hashSet = (HashSet<Long>)systemEnvironment.tx.txData.get("MASTERTRIGGER_HASHSET");
        if (hashSet == null) {
            hashSet = new HashSet<Long>();
            systemEnvironment.tx.txData.put("MASTERTRIGGER_HASHSET", hashSet);
        }
        if (bl) {
            try {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
            }
            catch (NotFoundException notFoundException) {
                sDMSSubmittedEntity.setWarn(systemEnvironment, new Integer(16), "Failed to submit master trigger " + this.getName(systemEnvironment) + ". Scheduling Entity not found", l, false);
                return null;
            }
        } else {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l5);
            boolean bl2 = false;
            bl2 = true;
            if (n2 == 3) {
                serializable = sDMSSubmittedEntity.getParentId(systemEnvironment);
                if (serializable == null) {
                    if (bl2) {
                        SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l, new Integer(16), new Integer(17), sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Triggering of " + sDMSSchedulingEntity.pathString(systemEnvironment, l5) + " failed,triggering Job has no parent");
                    }
                    return null;
                }
                sDMSSubmittedEntity3 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getParentId(systemEnvironment));
            } else {
                sDMSSubmittedEntity3 = sDMSSubmittedEntity;
            }
            string = sDMSSubmittedEntity.getId(systemEnvironment).toString() + '.' + this.getId(systemEnvironment).toString() + ':' + n.toString();
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            Comparable comparable;
            Object object;
            Object object2;
            Comparable comparable2;
            if (!hashSet.add(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03305141915", "Cannot fire Trigger $1 recursively in same Transaction", (Object)this.getName(systemEnvironment)));
            }
            Vector<Comparable> vector = new Vector<Comparable>();
            serializable = SDMSTriggerParameterTable.idx_triggerId.getVector(systemEnvironment, (Object)l2, sDMSSubmittedEntity.getSeVersion(systemEnvironment));
            Iterator iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                comparable2 = (SDMSTriggerParameter)iterator.next();
                object2 = ((SDMSTriggerParameter)comparable2).getExpression(systemEnvironment);
                object = this.evalExpression(systemEnvironment, (String)object2, null, sDMSSubmittedEntity, null);
                comparable = new WithItem((Comparable)((Object)((SDMSTriggerParameterProxyGeneric)comparable2).getName(systemEnvironment)), object);
                vector.add(comparable);
            }
            comparable2 = this.getIsSuspend(systemEnvironment);
            object2 = !((Boolean)comparable2).booleanValue() ? null : new Integer(1);
            if (bl) {
                object = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l5);
                comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getMasterId(systemEnvironment));
                sDMSSubmittedEntity2 = sDMSSchedulingEntity.submitMaster(systemEnvironment, vector, (Integer)object2, null, this.getSubmitOwnerId(systemEnvironment), new Integer(0), "Triggered by " + ((SDMSSchedulingEntity)object).pathString(systemEnvironment, l5) + "(" + this.getName(systemEnvironment) + "), Job " + sDMSSubmittedEntity.getId(systemEnvironment).toString(), ((SDMSSubmittedEntityProxyGeneric)comparable).getTimeZone(systemEnvironment));
            } else {
                object = null;
                if (l3.equals(l4)) {
                    object = sDMSSubmittedEntity.getId(systemEnvironment);
                }
                boolean bl3 = n2 == 3;
                sDMSSubmittedEntity2 = sDMSSubmittedEntity3.submitChild(systemEnvironment, vector, (Integer)object2, null, l3, string, (Long)object, null, bl3, true);
                SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l, new Integer(15), new Integer(17), sDMSSubmittedEntity2.getId(systemEnvironment), sDMSSubmittedEntity2.getId(systemEnvironment), Boolean.FALSE, null, "Triggered by " + sDMSSubmittedEntity.getId(systemEnvironment) + "(" + this.getName(systemEnvironment) + ")");
            }
            sDMSSubmittedEntity2.setBaseSmeId(systemEnvironment, (Long)systemEnvironment.tx.txData.get("BASE_SME_ID"));
            SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, l, new Integer(17), new Integer(17), sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Trigger " + this.getName(systemEnvironment) + "(" + sDMSSubmittedEntity2.getId(systemEnvironment) + ") submitted");
        }
        catch (NonRecoverableException nonRecoverableException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            if (!nonRecoverableException.errNumber().equals("03305141915") && bl) {
                sDMSSchedulingEntity.createErrorMaster(systemEnvironment, this.getSubmitOwnerId(systemEnvironment), "Triggered by " + sDMSSubmittedEntity.getId(systemEnvironment).toString() + "(" + this.getName(systemEnvironment) + ")", nonRecoverableException.toString());
            }
            sDMSSubmittedEntity.setWarn(systemEnvironment, new Integer(16), "Triggering of " + this.getName(systemEnvironment) + " failed : " + nonRecoverableException.toString(), l);
            sDMSSubmittedEntity2 = null;
        }
        if (sDMSSubmittedEntity2 != null) {
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        hashSet.remove(l2);
        return sDMSSubmittedEntity2;
    }

    public void trigger(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, Long l, Long l2, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Comparable comparable;
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return;
        }
        Long l3 = null;
        Long l4 = null;
        if (sDMSSubmittedEntity != null) {
            l3 = sDMSSubmittedEntity.getId(systemEnvironment);
            l4 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        }
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getVector(systemEnvironment, this.getId(systemEnvironment));
        boolean bl = false;
        if (vector.size() == 0) {
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            comparable = (SDMSTriggerState)vector.get(i);
            Long l5 = comparable.getFromStateId(systemEnvironment);
            Long l6 = comparable.getToStateId(systemEnvironment);
            if (l5 != null && !l5.equals(l) || l6 != null && !l6.equals(l2)) continue;
            bl = true;
            break;
        }
        if (bl) {
            try {
                bl = this.checkCondition(systemEnvironment, sDMSResource);
            }
            catch (CommonErrorException commonErrorException) {
                bl = false;
            }
        }
        if (bl) {
            Comparable comparable2;
            SDMSSubmittedEntityProxyGeneric sDMSSubmittedEntityProxyGeneric = null;
            systemEnvironment.tx.beginSubTransaction(systemEnvironment);
            try {
                comparable2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getSeId(systemEnvironment));
                sDMSSubmittedEntityProxyGeneric = comparable2.submitMaster(systemEnvironment, null, new Integer(this.getIsSuspend(systemEnvironment) != false ? 1 : 0), null, this.getSubmitOwnerId(systemEnvironment), new Integer(0), "Triggered by Resource " + sDMSResource.getId(systemEnvironment).toString() + "(" + this.getName(systemEnvironment) + ")", null);
            }
            catch (NonRecoverableException nonRecoverableException) {
                systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            }
            if (sDMSSubmittedEntityProxyGeneric != null) {
                systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                sDMSSubmittedEntityProxyGeneric.setBaseSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setReasonSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setFireSmeId(systemEnvironment, l3);
                sDMSSubmittedEntityProxyGeneric.setFireSeId(systemEnvironment, l4);
                sDMSSubmittedEntityProxyGeneric.setTrId(systemEnvironment, this.getId(systemEnvironment));
                sDMSSubmittedEntityProxyGeneric.setTrSdIdOld(systemEnvironment, l);
                sDMSSubmittedEntityProxyGeneric.setTrSdIdNew(systemEnvironment, l2);
                sDMSSubmittedEntityProxyGeneric.setTrSeq(systemEnvironment, new Integer(0));
                comparable2 = null;
                if (this.getIsSuspend(systemEnvironment).booleanValue()) {
                    comparable = sDMSSubmittedEntityProxyGeneric.getSubmitTs(systemEnvironment);
                    comparable2 = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), (Long)comparable, true, ((SDMSSubmittedEntity)sDMSSubmittedEntityProxyGeneric).getEffectiveTimeZone(systemEnvironment));
                    ((SDMSSubmittedEntity)sDMSSubmittedEntityProxyGeneric).setResumeTs(systemEnvironment, (Long)comparable2);
                }
            }
        }
    }

    private Vector determineConfigParameters(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor, Vector vector) throws SDMSException {
        Long l = sDMSObjectMonitor.getId(systemEnvironment);
        Vector<SDMSObjectMonitorParameter> vector2 = new Vector<SDMSObjectMonitorParameter>();
        for (int i = 0; i < vector.size(); ++i) {
            Comparable comparable;
            SDMSWatchTypeParameter sDMSWatchTypeParameter = (SDMSWatchTypeParameter)vector.get(i);
            if (!sDMSWatchTypeParameter.getIsSubmitPar(systemEnvironment).booleanValue()) continue;
            String string = sDMSWatchTypeParameter.getName(systemEnvironment);
            String string2 = null;
            if (sDMSWatchTypeParameter.getType(systemEnvironment) != 1) continue;
            try {
                comparable = SDMSObjectMonitorParameterTable.idx_omId_wtpId_getUnique(systemEnvironment, new SDMSKey(l, sDMSWatchTypeParameter.getId(systemEnvironment)));
                string2 = comparable.getValue(systemEnvironment).substring(1);
            }
            catch (NotFoundException notFoundException) {
                string2 = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
                if (string2 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109071534", "Didn't find a value for mandatory submit parameter $1 of object type $2", (Object)string, (Object)sDMSObjectMonitor.getName(systemEnvironment)));
                }
                string2 = string2.substring(1);
            }
            comparable = new WithItem((Comparable)((Object)string), string2);
            vector2.add((SDMSObjectMonitorParameter)comparable);
        }
        return vector2;
    }

    private void determineInstanceParameters(SystemEnvironment systemEnvironment, SDMSObjectInstance sDMSObjectInstance, Vector vector, Vector vector2) throws SDMSException {
        Long l = sDMSObjectInstance.getId(systemEnvironment);
        vector2.add(new WithItem((Comparable)((Object)"OBJECT_NAME"), sDMSObjectInstance.getUniqueName(systemEnvironment)));
        for (int i = 0; i < vector.size(); ++i) {
            Comparable comparable;
            SDMSWatchTypeParameter sDMSWatchTypeParameter = (SDMSWatchTypeParameter)vector.get(i);
            if (!sDMSWatchTypeParameter.getIsSubmitPar(systemEnvironment).booleanValue()) continue;
            String string = sDMSWatchTypeParameter.getName(systemEnvironment);
            String string2 = null;
            if (sDMSWatchTypeParameter.getType(systemEnvironment) == 1) continue;
            try {
                comparable = SDMSInstanceValueTable.idx_oiId_wtpId_getUnique(systemEnvironment, new SDMSKey(l, sDMSWatchTypeParameter.getId(systemEnvironment)));
                string2 = comparable.getValue(systemEnvironment).substring(1);
            }
            catch (NotFoundException notFoundException) {
                string2 = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
                if (string2 == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109071508", "Didn't find a value for mandatory submit parameter $1 of object instance $2", (Object)string, (Object)sDMSObjectInstance.getUniqueName(systemEnvironment)));
                }
                string2 = string2.substring(1);
            }
            comparable = new WithItem((Comparable)((Object)string), string2);
            vector2.add(comparable);
        }
    }

    private Integer getEventType(SDMSObjectInstance sDMSObjectInstance, Vector vector, Vector vector2, Vector vector3) {
        if (vector3 != null && vector3.contains(sDMSObjectInstance)) {
            return new Integer(3);
        }
        if (vector2 != null && vector2.contains(sDMSObjectInstance)) {
            return new Integer(2);
        }
        return new Integer(1);
    }

    private String getEventTypeAsString(int n) {
        switch (n) {
            case 3: {
                return "DELETE";
            }
            case 2: {
                return "CHANGE";
            }
            case 1: {
                return "CREATE";
            }
        }
        return null;
    }

    private void updateTriggeredSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        sDMSSubmittedEntity.setBaseSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setReasonSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setFireSmeId(systemEnvironment, null);
        sDMSSubmittedEntity.setFireSeId(systemEnvironment, null);
        sDMSSubmittedEntity.setTrId(systemEnvironment, this.getId(systemEnvironment));
        sDMSSubmittedEntity.setTrSdIdOld(systemEnvironment, null);
        sDMSSubmittedEntity.setTrSdIdNew(systemEnvironment, null);
        sDMSSubmittedEntity.setTrSeq(systemEnvironment, new Integer(0));
        Long l = null;
        if (this.getIsSuspend(systemEnvironment).booleanValue()) {
            Long l2 = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
            l = SubmitJob.evalResumeObj(systemEnvironment, this.getResumeAt(systemEnvironment), this.getResumeIn(systemEnvironment), this.getResumeBase(systemEnvironment), l2, true, sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
            sDMSSubmittedEntity.setResumeTs(systemEnvironment, l);
        }
    }

    private Vector getGeneralParams(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor, String string, Vector vector) throws SDMSException {
        Vector vector2 = (Vector)vector.clone();
        vector2.add(new WithItem((Comparable)((Object)"EVENT_TYPE"), string));
        vector2.add(new WithItem((Comparable)((Object)"OBJECT_MONITOR"), sDMSObjectMonitor.getName(systemEnvironment)));
        return vector2;
    }

    public void trigger(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor, Vector vector, Vector vector2, Vector vector3, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        if (!this.getIsActive(systemEnvironment).booleanValue()) {
            return;
        }
        Long l = sDMSObjectMonitor.getId(systemEnvironment);
        Vector vector4 = new Vector();
        if (vector != null) {
            vector4.addAll(vector);
        }
        if (vector2 != null) {
            vector4.addAll(vector2);
        }
        if (vector3 != null) {
            vector4.addAll(vector3);
        }
        if (vector4.size() == 0) {
            return;
        }
        Collections.sort(vector4, SDMSObjectInstance.getComparator(systemEnvironment));
        Vector vector5 = SDMSWatchTypeParameterTable.idx_wtId.getVector(systemEnvironment, sDMSObjectMonitor.getWtId(systemEnvironment));
        Vector vector6 = this.determineConfigParameters(systemEnvironment, sDMSObjectMonitor, vector5);
        if (!this.getIsGroup(systemEnvironment).booleanValue()) {
            for (int i = 0; i < vector4.size(); ++i) {
                SDMSSubmittedEntity sDMSSubmittedEntity2;
                SDMSObjectInstance sDMSObjectInstance = (SDMSObjectInstance)vector4.get(i);
                Long l2 = sDMSObjectInstance.getId(systemEnvironment);
                Long l3 = this.getSeId(systemEnvironment);
                Integer n = this.getEventType(sDMSObjectInstance, vector, vector2, vector3);
                String string = this.getEventTypeAsString(n);
                Vector vector7 = this.getGeneralParams(systemEnvironment, sDMSObjectMonitor, string, vector6);
                this.determineInstanceParameters(systemEnvironment, sDMSObjectInstance, vector5, vector7);
                if (this.getIsMaster(systemEnvironment).booleanValue()) {
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
                    sDMSSubmittedEntity2 = sDMSSchedulingEntity.submitMaster(systemEnvironment, vector7, new Integer(this.getIsSuspend(systemEnvironment) != false ? 1 : 0), null, this.getSubmitOwnerId(systemEnvironment), new Integer(0), "Triggered by Object Type  " + sDMSObjectMonitor.getName(systemEnvironment), null);
                } else {
                    sDMSSubmittedEntity2 = sDMSSubmittedEntity.submitChild(systemEnvironment, vector7, new Integer(this.getIsSuspend(systemEnvironment) != false ? 1 : 0), null, l3, l2.toString(), null, null, true, true);
                    SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, sDMSSubmittedEntity2.getSubmitTs(systemEnvironment), new Integer(15), new Integer(17), sDMSSubmittedEntity2.getId(systemEnvironment), sDMSSubmittedEntity2.getId(systemEnvironment), Boolean.FALSE, null, "Triggered by Object Type " + sDMSObjectMonitor.getName(systemEnvironment));
                }
                this.updateTriggeredSme(systemEnvironment, sDMSSubmittedEntity2);
                SDMSObjectEventTable.table.create(systemEnvironment, this.getId(systemEnvironment), l2, n, sDMSSubmittedEntity2.getId(systemEnvironment), l3, sDMSSubmittedEntity2.getSubmitTs(systemEnvironment), null, null, null, null, null, null, sDMSSubmittedEntity2.getSeVersion(systemEnvironment));
            }
        } else {
            Long l4 = this.getMainSeId(systemEnvironment);
            Vector vector8 = this.getGeneralParams(systemEnvironment, sDMSObjectMonitor, "", vector6);
            if (l4 == null) {
                SDMSSubmittedEntity sDMSSubmittedEntity3;
                Comparable comparable;
                Long l5 = this.getSeId(systemEnvironment);
                if (this.getIsMaster(systemEnvironment).booleanValue()) {
                    comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l5);
                    sDMSSubmittedEntity3 = comparable.submitMaster(systemEnvironment, vector8, new Integer(this.getIsSuspend(systemEnvironment) != false ? 1 : 0), null, this.getSubmitOwnerId(systemEnvironment), new Integer(0), "Triggered by Object Type  " + sDMSObjectMonitor.getName(systemEnvironment), null);
                } else {
                    sDMSSubmittedEntity3 = sDMSSubmittedEntity.submitChild(systemEnvironment, vector8, new Integer(this.getIsSuspend(systemEnvironment) != false ? 1 : 0), null, l5, l.toString(), null, null, true, true);
                    SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, sDMSSubmittedEntity3.getSubmitTs(systemEnvironment), new Integer(15), new Integer(17), sDMSSubmittedEntity3.getId(systemEnvironment), sDMSSubmittedEntity3.getId(systemEnvironment), Boolean.FALSE, null, "Triggered by Object Type " + sDMSObjectMonitor.getName(systemEnvironment));
                }
                this.updateTriggeredSme(systemEnvironment, sDMSSubmittedEntity3);
                comparable = sDMSSubmittedEntity3.getId(systemEnvironment);
                for (int i = 0; i < vector4.size(); ++i) {
                    SDMSObjectInstance sDMSObjectInstance = (SDMSObjectInstance)vector4.get(i);
                    Long l6 = sDMSObjectInstance.getId(systemEnvironment);
                    Integer n = this.getEventType(sDMSObjectInstance, vector, vector2, vector3);
                    String string = this.getEventTypeAsString(n);
                    SDMSObjectEventTable.table.create(systemEnvironment, this.getId(systemEnvironment), l6, n, (Long)comparable, l5, sDMSSubmittedEntity3.getSubmitTs(systemEnvironment), null, null, (Long)comparable, l5, null, null, sDMSSubmittedEntity3.getSeVersion(systemEnvironment));
                }
            } else {
                SDMSSubmittedEntity sDMSSubmittedEntity4;
                Comparable comparable;
                l4 = this.getMainSeId(systemEnvironment);
                Boolean bl = this.getIsSuspend(systemEnvironment);
                if (this.getIsMaster(systemEnvironment).booleanValue()) {
                    comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, l4);
                    sDMSSubmittedEntity4 = comparable.submitMaster(systemEnvironment, vector8, new Integer(1), null, this.getSubmitOwnerId(systemEnvironment), new Integer(0), "Triggered by Object Type  " + sDMSObjectMonitor.getName(systemEnvironment), null);
                } else {
                    sDMSSubmittedEntity4 = sDMSSubmittedEntity.submitChild(systemEnvironment, vector8, new Integer(1), null, l4, l.toString(), null, null, true, true);
                    SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, sDMSSubmittedEntity4.getSubmitTs(systemEnvironment), new Integer(15), new Integer(17), sDMSSubmittedEntity4.getId(systemEnvironment), sDMSSubmittedEntity4.getId(systemEnvironment), Boolean.FALSE, null, "Triggered by Object Type " + sDMSObjectMonitor.getName(systemEnvironment));
                }
                SDMSSubmittedEntity sDMSSubmittedEntity5 = sDMSSubmittedEntity4;
                comparable = sDMSSubmittedEntity5.getId(systemEnvironment);
                this.updateTriggeredSme(systemEnvironment, sDMSSubmittedEntity5);
                SDMSSubmittedEntity sDMSSubmittedEntity6 = sDMSSubmittedEntity4;
                Long l7 = this.getParentSeId(systemEnvironment);
                if (l7 != null && (sDMSSubmittedEntity6 = sDMSSubmittedEntity5.getChildSubmittedEntity(systemEnvironment, l7, null, sDMSSubmittedEntity5, false)) == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03109091241", "Didn't find the specified parent scheduling entity $1", (Object)SDMSSchedulingEntityTable.getObject(systemEnvironment, l7).pathString(systemEnvironment)));
                }
                for (int i = 0; i < vector4.size(); ++i) {
                    SDMSObjectInstance sDMSObjectInstance = (SDMSObjectInstance)vector4.get(i);
                    Long l8 = sDMSObjectInstance.getId(systemEnvironment);
                    Long l9 = this.getSeId(systemEnvironment);
                    Integer n = this.getEventType(sDMSObjectInstance, vector, vector2, vector3);
                    String string = this.getEventTypeAsString(n);
                    vector8 = this.getGeneralParams(systemEnvironment, sDMSObjectMonitor, string, vector6);
                    this.determineInstanceParameters(systemEnvironment, sDMSObjectInstance, vector5, vector8);
                    sDMSSubmittedEntity4 = sDMSSubmittedEntity6.submitChild(systemEnvironment, vector8, null, null, l9, l8.toString(), null, null, true, true);
                    SDMSAuditTrailTable.table.create(systemEnvironment, SDMSObject.internalUId, sDMSSubmittedEntity4.getSubmitTs(systemEnvironment), new Integer(15), new Integer(17), sDMSSubmittedEntity4.getId(systemEnvironment), sDMSSubmittedEntity4.getId(systemEnvironment), Boolean.FALSE, null, "Triggered by Object Type " + sDMSObjectMonitor.getName(systemEnvironment));
                    this.updateTriggeredSme(systemEnvironment, sDMSSubmittedEntity4);
                    SDMSObjectEventTable.table.create(systemEnvironment, this.getId(systemEnvironment), l8, n, sDMSSubmittedEntity4.getId(systemEnvironment), l9, sDMSSubmittedEntity4.getSubmitTs(systemEnvironment), null, null, (Long)comparable, l4, null, null, sDMSSubmittedEntity4.getSeVersion(systemEnvironment));
                }
                if (!bl.booleanValue()) {
                    sDMSSubmittedEntity5.resume(systemEnvironment, false);
                }
            }
        }
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        int n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 0: {
                sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            case 2: {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            case 1: {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            case 3: {
                sDMSProxy = SDMSObjectMonitorTable.getObject(systemEnvironment, this.getFireId(systemEnvironment));
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "0330603241133", "Unknown Objecttype in Trigger $1", (Object)this.getName(systemEnvironment)));
            }
        }
        return this.getName(systemEnvironment) + " on " + sDMSProxy.getURL(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "trigger " + this.getURLName(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l2 = 0L;
        l2 = l;
        int n = this.getObjectType(systemEnvironment);
        boolean bl2 = false;
        switch (n) {
            case 0: {
                boolean bl3 = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl3 ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment));
                    long l3 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l3 & 0x100L) == 256L) {
                        l3 |= 0x10000011L;
                    }
                    l2 &= l3;
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    long l4 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l4 & 0x100L) == 256L) {
                        l4 |= 0x10000011L;
                    }
                    l2 &= l4;
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
                break;
            }
            case 2: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    long l5 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l5 & 0x100L) == 256L) {
                        l5 |= 0x10000011L;
                    }
                    l2 &= l5;
                    bl2 = true;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
                break;
            }
            case 3: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    long l6 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l6 & 0x100L) == 256L) {
                        l6 |= 0x10000011L;
                    }
                    l2 &= l6;
                    bl2 = true;
                    break;
                }
                catch (NotFoundException notFoundException) {
                    l2 = 0L;
                }
            }
        }
        if (!bl2) {
            if (systemEnvironment.tx.mode == 1) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03809050935", "Orphan Trigger found, as ADMIN use 'drop trigger $1' to solve this problem", (Object)this.getId(systemEnvironment).toString()));
            }
            if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                l2 = l;
            }
        }
        return l2;
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector, long l2) throws SDMSException {
        if (vector == null) {
            Vector vector2 = new Vector();
        } else {
            Vector vector3 = vector;
        }
        long l3 = 0L;
        int n = this.getObjectType(systemEnvironment);
        l3 = l;
        switch (n) {
            case 0: {
                boolean bl2 = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl2 ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment), l2);
                    long l4 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l4 & 0x100L) == 256L) {
                        l4 |= 0x10000011L;
                    }
                    l3 &= l4;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment), l2);
                    long l5 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l5 & 0x100L) == 256L) {
                        l5 |= 0x10000011L;
                    }
                    l3 &= l5;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
                break;
            }
            case 2: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment), l2);
                    long l6 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l6 & 0x100L) == 256L) {
                        l6 |= 0x10000011L;
                    }
                    l3 &= l6;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
                break;
            }
            case 3: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment), l2);
                    long l7 = sDMSProxy.getPrivileges(systemEnvironment, 0x10000111L, false, vector);
                    if ((l7 & 0x100L) == 256L) {
                        l7 |= 0x10000011L;
                    }
                    l3 &= l7;
                    break;
                }
                catch (NotFoundException notFoundException) {
                    l3 = 0L;
                }
            }
        }
        return l3;
    }

    @Override
    void touchMaster(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 0: {
                boolean bl = this.getIsInverse(systemEnvironment);
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "SCHEDULING_ENTITY");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, bl ? this.getSeId(systemEnvironment) : this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {}
                break;
            }
            case 1: {
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "RESSOURCE");
                try {
                    SDMSProxy sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {}
                break;
            }
            case 2: {
                SDMSProxy sDMSProxy;
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "NAMED_RESOURCE");
                try {
                    sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            case 3: {
                SDMSProxy sDMSProxy;
                SDMSTable sDMSTable = SystemEnvironment.repository.getTable(systemEnvironment, "OBJECT_MONITOR");
                try {
                    sDMSProxy = sDMSTable.get(systemEnvironment, this.getFireId(systemEnvironment));
                    sDMSProxy.touch(systemEnvironment);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
    }

    static {
        mapper.put(new Integer(403), new Integer(0));
        mapper.put(new Integer(404), new Integer(1));
        mapper.put(new Integer(283), new Integer(2));
        mapper.put(new Integer(265), new Integer(3));
        mapper.put(new Integer(378), new Integer(4));
        mapper.put(new Integer(615), new Integer(5));
        mapper.put(new Integer(614), new Integer(6));
        mapper.put(new Integer(625), new Integer(7));
        mapper.put(new Integer(318), new Integer(0));
        mapper.put(new Integer(297), new Integer(1));
        mapper.put(new Integer(327), new Integer(2));
    }
}

