/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSUserGeneric
extends SDMSObject
implements Cloneable {
    public static final String SYSTEM = "SYSTEM";
    public static final String INTERNAL = "INTERNAL";
    public static final String NOBODY = "NOBODY";
    public static final int MD5 = 0;
    public static final int SHA256 = 1;
    public static final int PLAIN = 0;
    public static final int SSL = 1;
    public static final int SSL_AUTH = 2;
    public static final int SALT_LENGTH = 64;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_passwd = 3;
    public static final int nr_salt = 4;
    public static final int nr_method = 5;
    public static final int nr_isEnabled = 6;
    public static final int nr_defaultGId = 7;
    public static final int nr_connectionType = 8;
    public static final int nr_deleteVersion = 9;
    public static final int nr_creatorUId = 10;
    public static final int nr_createTs = 11;
    public static final int nr_changerUId = 12;
    public static final int nr_changeTs = 13;
    public static String tableName = "USERS";
    protected String name;
    protected String passwd;
    protected String salt;
    protected Integer method;
    protected Boolean isEnabled;
    protected Long defaultGId;
    protected Integer connectionType;
    protected Long deleteVersion;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSUserGeneric(SystemEnvironment systemEnvironment, String string, String string2, String string3, Integer n, Boolean bl, Long l, Integer n2, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSUserTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(User) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        if (string2 != null && string2.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(User) Length of $1 exceeds maximum length $2", (Object)"passwd", (Object)"64"));
        }
        this.passwd = string2;
        if (string3 != null && string3.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(User) Length of $1 exceeds maximum length $2", (Object)"salt", (Object)"64"));
        }
        this.salt = string3;
        this.method = n;
        this.isEnabled = bl;
        this.defaultGId = l;
        this.connectionType = n2;
        this.deleteVersion = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
            }
            SDMSUserGeneric sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(User) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSUserGeneric.name = string;
            sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 3L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getPasswd(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.passwd;
    }

    public void setPasswd(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.passwd.equals(string)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(User) Length of $1 exceeds maximum length $2", (Object)"passwd", (Object)"64"));
        }
        sDMSUserGeneric.passwd = string;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public String getSalt(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.salt;
    }

    public void setSalt(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.salt)) {
            return;
        }
        if (string == null && this.salt == null) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(User) Length of $1 exceeds maximum length $2", (Object)"salt", (Object)"64"));
        }
        sDMSUserGeneric.salt = string;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Integer getMethod(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.method;
    }

    public String getMethodAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getMethod(systemEnvironment);
        switch (n) {
            case 0: {
                return "MD5";
            }
            case 1: {
                return "SHA256";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown User.method: $1", (Object)this.getMethod(systemEnvironment)));
    }

    public void setMethod(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.method.equals(n)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.method = n;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Boolean getIsEnabled(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isEnabled;
    }

    public void setIsEnabled(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isEnabled.equals(bl)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
        }
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.isEnabled = bl;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Long getDefaultGId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.defaultGId;
    }

    public void setDefaultGId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.defaultGId.equals(l)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.defaultGId = l;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Integer getConnectionType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.connectionType;
    }

    public String getConnectionTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getConnectionType(systemEnvironment);
        switch (n) {
            case 0: {
                return "PLAIN";
            }
            case 1: {
                return "SSL";
            }
            case 2: {
                return "SSL_AUTH";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown User.connectionType: $1", (Object)this.getConnectionType(systemEnvironment)));
    }

    public void setConnectionType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.connectionType.equals(n)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
        }
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.connectionType = n;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Long getDeleteVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.deleteVersion;
    }

    public void setDeleteVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.deleteVersion.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
            }
            SDMSUserGeneric sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
            sDMSUserGeneric.deleteVersion = l;
            sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
        }
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.creatorUId = l;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(User) Change of system object not allowed"));
        }
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.createTs = l;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.changerUId = l;
        sDMSUserGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSUserGeneric sDMSUserGeneric = this;
        if (sDMSUserGeneric.versions.o_v == null || sDMSUserGeneric.versions.o_v.size() == 0 || sDMSUserGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
        }
        sDMSUserGeneric.changeTs = l;
        sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSUserGeneric != this) {
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric, 0L);
        }
    }

    public SDMSUserGeneric set_NameDeleteVersion(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        SDMSUserGeneric sDMSUserGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(User) Change of system object not allowed"));
            }
            sDMSUserGeneric = (SDMSUserGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(User) Length of $1 exceeds maximum length $2", (Object)"changeTs", (Object)"64"));
            }
            sDMSUserGeneric.name = string;
            sDMSUserGeneric.deleteVersion = l;
            sDMSUserGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSUserGeneric.changeTs = systemEnvironment.txTime();
            sDMSUserGeneric.versions.table.index(systemEnvironment, sDMSUserGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSUserGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSUser(this);
    }

    protected SDMSUserGeneric(Long l, String string, String string2, String string3, Integer n, Boolean bl, Long l2, Integer n2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.name = string;
        this.passwd = string2;
        this.salt = string3;
        this.method = n;
        this.isEnabled = bl;
        this.defaultGId = l2;
        this.connectionType = n2;
        this.deleteVersion = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "USERS" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "PASSWD" + string3 + ", " + string2 + "SALT" + string3 + ", " + string2 + "METHOD" + string3 + ", " + string2 + "IS_ENABLED" + string3 + ", " + string2 + "DEFAULT_G_ID" + string3 + ", " + string2 + "CONNECTION_TYPE" + string3 + ", " + string2 + "DELETE_VERSION" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSUserGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "User: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.passwd);
            if (this.salt == null) {
                preparedStatement.setNull(4, 12);
            } else {
                preparedStatement.setString(4, this.salt);
            }
            preparedStatement.setInt(5, this.method);
            preparedStatement.setInt(6, this.isEnabled != false ? 1 : 0);
            preparedStatement.setLong(7, this.defaultGId);
            preparedStatement.setInt(8, this.connectionType);
            preparedStatement.setLong(9, this.deleteVersion);
            preparedStatement.setLong(10, this.creatorUId);
            preparedStatement.setLong(11, this.createTs);
            preparedStatement.setLong(12, this.changerUId);
            preparedStatement.setLong(13, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "User: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "USERS" + string3 + " WHERE ID = ?";
                SDMSUserGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "User: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "User: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "USERS" + string3 + " SET " + string2 + "NAME" + string3 + " = ? , " + string2 + "PASSWD" + string3 + " = ? , " + string2 + "SALT" + string3 + " = ? , " + string2 + "METHOD" + string3 + " = ? , " + string2 + "IS_ENABLED" + string3 + " = ? , " + string2 + "DEFAULT_G_ID" + string3 + " = ? , " + string2 + "CONNECTION_TYPE" + string3 + " = ? , " + string2 + "DELETE_VERSION" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? WHERE ID = ?";
                SDMSUserGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "User: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setString(2, this.passwd);
            if (this.salt == null) {
                preparedStatement.setNull(3, 12);
            } else {
                preparedStatement.setString(3, this.salt);
            }
            preparedStatement.setInt(4, this.method);
            preparedStatement.setInt(5, this.isEnabled != false ? 1 : 0);
            preparedStatement.setLong(6, this.defaultGId);
            preparedStatement.setInt(7, this.connectionType);
            preparedStatement.setLong(8, this.deleteVersion);
            preparedStatement.setLong(9, this.creatorUId);
            preparedStatement.setLong(10, this.createTs);
            preparedStatement.setLong(11, this.changerUId);
            preparedStatement.setLong(12, this.changeTs);
            preparedStatement.setLong(13, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "User: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkMethod(Integer n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkConnectionType(Integer n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : User", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "passwd : " + this.passwd, 2);
        SDMSThread.doTrace(null, "salt : " + this.salt, 2);
        SDMSThread.doTrace(null, "method : " + this.method, 2);
        SDMSThread.doTrace(null, "isEnabled : " + this.isEnabled, 2);
        SDMSThread.doTrace(null, "defaultGId : " + this.defaultGId, 2);
        SDMSThread.doTrace(null, "connectionType : " + this.connectionType, 2);
        SDMSThread.doTrace(null, "deleteVersion : " + this.deleteVersion, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name           : " + this.name + "\n" + string + "passwd         : " + this.passwd + "\n" + string + "salt           : " + this.salt + "\n" + string + "method         : " + this.method + "\n" + string + "isEnabled      : " + this.isEnabled + "\n" + string + "defaultGId     : " + this.defaultGId + "\n" + string + "connectionType : " + this.connectionType + "\n" + string + "deleteVersion  : " + this.deleteVersion + "\n" + string + "creatorUId     : " + this.creatorUId + "\n" + string + "createTs       : " + this.createTs + "\n" + string + "changerUId     : " + this.changerUId + "\n" + string + "changeTs       : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

