/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.SQLException;

class TableLoader
extends SDMSThread {
    private int id = 0;
    private SystemEnvironment sysEnv = null;

    public TableLoader(int n, SystemEnvironment systemEnvironment) {
        this.id = n;
        try {
            this.sysEnv = (SystemEnvironment)systemEnvironment.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            SystemEnvironment.repository.notify(new FatalException(new SDMSMessage(this.sysEnv, "03305091630", "Error Cloning System Environment")));
        }
        try {
            this.sysEnv.dbConnection = Server.connectToDB(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            SystemEnvironment.repository.notify(sDMSException);
        }
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public void SDMSrun() {
        TableLoader.doTrace(null, "TableLoader " + this.id + " started", 0);
        try {
            try {
                SDMSTable sDMSTable;
                while ((sDMSTable = SystemEnvironment.repository.getNextTable()) != null) {
                    sDMSTable.loadTable(this.sysEnv);
                    this.sysEnv.dbConnection.commit();
                }
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(this.sysEnv, "03110181536", "SQL Error : " + sQLException.getMessage()));
            }
        }
        catch (SDMSException sDMSException) {
            SystemEnvironment.repository.notify(sDMSException);
        }
        finally {
            try {
                this.sysEnv.dbConnection.close();
            }
            catch (SQLException sQLException) {
                SystemEnvironment.repository.notify(new FatalException(new SDMSMessage(this.sysEnv, "03305091627", "SQL Error : " + sQLException.getMessage())));
            }
        }
    }
}

