#!/bin/sh 
if [ $# -lt 1 ]; then
	SERVERS="localhost host_1 host_2"
else
	SERVERS="$*"
fi

if [ -z "$BICSUITECONFIG" ]
then
	BICSUITECONFIG=$BICSUITEHOME/etc
fi

. $BICSUITECONFIG/bicsuite.conf

mkdir -p $BICSUITELOGDIR 2>/dev/null

for JS in $SERVERS
do
	echo "Starting Jobserver $JS"

	if ! test -f $BICSUITECONFIG/$JS.conf
	then
		cp $BICSUITEHOME/etc/$JS.conf.template $BICSUITECONFIG/$JS.conf
	fi

	# without scrolllog
	# $BICSUITEHOME/bin/jobserver-run $BICSUITECONFIG/$JS.conf > $BICSUITELOGDIR/$JS.out 2>&1 &

	# with scrolllog
	$BICSUITEHOME/bin/jobserver-run $BICSUITECONFIG/$JS.conf $BICSUITELOGDIR/$JS.out
done
