-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TEMPLATE_VARIABLE (
    ID                             bigint NOT NULL
    , PD_ID                          bigint          NOT NULL
    , RT_ID                          bigint          NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TEMPLATE_VARIABLE
ON TEMPLATE_VARIABLE(ID);
CREATE VIEW SCI_C_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TEMPLATE_VARIABLE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TEMPLATE_VARIABLE (ID,PD_ID,RT_ID,VALUE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TEMPLATE_VARIABLE;
