-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [ENVIRONMENT] (
    [ID]                           decimal (38) NOT NULL
    , [NE_ID]                        decimal (38)    NOT NULL
    , [NR_ID]                        decimal (38)    NOT NULL
    , [CONDITION]                    varchar(1024)       NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [VALID_FROM]                 decimal (38) NOT NULL
    , [VALID_TO]                   decimal (38) NOT NULL
);
go
CREATE INDEX PK_ENVIRONMENT
ON [ENVIRONMENT]([ID]);
go
CREATE VIEW SCI_C_ENVIRONMENT AS
SELECT 
    ID 
    , [NE_ID]                        AS [NE_ID]
    , [NR_ID]                        AS [NR_ID]
    , [CONDITION]                    AS [CONDITION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [ENVIRONMENT]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_ENVIRONMENT AS
SELECT 
    ID 
    , [NE_ID]                        AS [NE_ID]
    , [NR_ID]                        AS [NR_ID]
    , [CONDITION]                    AS [CONDITION]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [ENVIRONMENT];
go
