-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [EXTENTS] (
    [ID]                           decimal (38) NOT NULL
    , [O_ID]                         decimal (38)    NOT NULL
    , [SME_ID]                       decimal (38)    NOT NULL
    , [SEQUENCE]                     integer         NOT NULL
    , [EXTENT]                       varchar(256)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_EXTENTS
ON [EXTENTS]([ID]);
go
CREATE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , [O_ID]                         AS [O_ID]
    , [SME_ID]                       AS [SME_ID]
    , [SEQUENCE]                     AS [SEQUENCE]
    , [EXTENT]                       AS [EXTENT]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [EXTENTS];
go
CREATE TABLE ARC_EXTENTS (
    ID                             decimal (38) NOT NULL
    , [O_ID]                         decimal (38)     NULL
    , [SME_ID]                       decimal (38)     NULL
    , [SEQUENCE]                     integer          NULL
    , [EXTENT]                       varchar(256)     NULL
    , [CREATOR_U_ID]                 decimal (38)     NULL
    , [CREATE_TS]                    decimal (38)     NULL
    , [CHANGER_U_ID]                 decimal (38)     NULL
    , [CHANGE_TS]                    decimal (38)     NULL
);
go
