-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [USER_EQUIV] (
    [ID]                           decimal (38) NOT NULL
    , [U_ID]                         decimal (38)    NOT NULL
    , [ALT_U_TYPE]                   integer         NOT NULL
    , [ALT_U_ID]                     decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_USER_EQUIV
ON [USER_EQUIV]([ID]);
go
CREATE VIEW SCI_USER_EQUIV AS
SELECT 
    ID 
    , [U_ID]                         AS [U_ID]
    , CASE [ALT_U_TYPE] WHEN 0 THEN 'USER' WHEN 1 THEN 'SERVER' END AS [ALT_U_TYPE]
    , [ALT_U_ID]                     AS [ALT_U_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [USER_EQUIV];
go
