-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE_ENTRY (
    ID                             NUMBER (38) PRIMARY KEY
    , NP_ID                          NUMBER (38)          NOT NULL
    , PREFERENCE                     NUMBER (38)          NOT NULL
    , FOLDER_ID                      NUMBER (38)              NULL
    , IS_SUSPENDED                   NUMBER (38)          NOT NULL
    , RENICE                         NUMBER (38)          NOT NULL
    , IS_ACTIVE                      NUMBER (1)           NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_NICE_PROFILE_ENTRY AS
SELECT 
    ID 
    , NP_ID                          AS NP_ID
    , PREFERENCE                     AS PREFERENCE
    , FOLDER_ID                      AS FOLDER_ID
    , DECODE (IS_SUSPENDED, 0, 'NOSUSPEND', 1, 'SUSPEND', 2, 'ADMINSUSPEND') AS IS_SUSPENDED
    , RENICE                         AS RENICE
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM NICE_PROFILE_ENTRY;
