-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR (
    ID                             NUMBER (38) PRIMARY KEY
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , OWNER_ID                       NUMBER (38)          NOT NULL
    , WT_ID                          NUMBER (38)          NOT NULL
    , RECREATE_HANDLING              NUMBER (1)           NOT NULL
    , WATCH_SE_ID                    NUMBER (38)              NULL
    , DELETE_AMOUNT                  NUMBER (38)              NULL
    , DELETE_BASE                    NUMBER (38)              NULL
    , EVENT_DELETE_AMOUNT            NUMBER (38)              NULL
    , EVENT_DELETE_BASE              NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_OBJECT_MONITOR AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM OBJECT_MONITOR;
