-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE (
    ID                             NUMBER (38) PRIMARY KEY
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , OWNER_ID                       NUMBER (38)          NOT NULL
    , PARENT_ID                      NUMBER (38)              NULL
    , TYPE                           NUMBER (38)          NOT NULL
    , IS_TERMINATE                   NUMBER (1)               NULL
    , HAS_ALTEREDCONFIG              NUMBER (1)               NULL
    , IS_SUSPENDED                   NUMBER (1)               NULL
    , IS_ENABLED                     NUMBER (1)               NULL
    , IS_REGISTERED                  NUMBER (1)               NULL
    , STATE                          NUMBER (38)              NULL
    , PASSWD                         VARCHAR2 (64 CHAR)       NULL
    , SALT                           VARCHAR2 (64 CHAR)       NULL
    , METHOD                         NUMBER (38)          NOT NULL
    , PID                            VARCHAR2 (32 CHAR)       NULL
    , NODE                           VARCHAR2 (64 CHAR)       NULL
    , ERRMSG                         VARCHAR2 (256 CHAR)      NULL
    , LAST_ACTIVE                    NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , INHERIT_PRIVS                  NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_SCOPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
