CREATE VIEW sci_sme_quarter (
        jahr,
        quartal,
        anzahl,
        expected_anzahl,
        avg_anzahl_pro_tag)
AS
SELECT  jahr,
        ((monat-1)/3)+1,
        sum(anzahl),
	int4 (
		CASE         (int4(date_part('month', now())) - 1) / 3
			WHEN (int4(monat                    ) - 1) / 3 THEN 
				sum(anzahl)
				*
				date_part( 'day', date_trunc('quarter', now()) + '3 month' - date_trunc('quarter', now())) -- anzahl tage des aktuellen quartals
				/
				greatest(1, date_part( 'day', now()                                    - date_trunc('quarter', now()))) -- anzahl vergangene tage des aktuellen quartals
			ELSE 
				sum(anzahl)
        	END
	),
	round (
		CASE         (int4(date_part('month', now())) - 1) / 3
			WHEN (int4(monat                    ) - 1) / 3 THEN 
				sum(anzahl)
				/
				greatest(1, date_part( 'day', now()                                    - date_trunc('quarter', now()))) -- anzahl vergangene tage des aktuellen quartals
			ELSE 
				sum(anzahl) 
				/ 
				date_part( 
					'day', 
					date_trunc('quarter', to_timestamp(jahr||'-'||(monat-1)/3+1||'-1','YYYY-MM-DD')) + '3 month' - 
					date_trunc('quarter', to_timestamp(jahr||'-'||(monat-1)/3+1||'-1','YYYY-MM-DD')) 
					) -- anzahl tage des quartals
        	END * 100
	) / 100
FROM sme_counter
GROUP BY jahr, (monat-1)/3;
