/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSDesktop;

import de.independit.scheduler.SDMSDesktop.SDMSDesktop;
import de.independit.scheduler.SDMSDesktop.SDMSDesktopWindow;
import de.independit.scheduler.server.output.SDMSOutput;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class SDMSExitStateWindow
extends SDMSDesktopWindow
implements DragGestureListener,
DragSourceListener {
    public static final String __version = "@(#) $Id: SDMSExitStateWindow.java,v 2.0.20.1 2013/03/14 10:24:03 ronald Exp $";
    JTree tree;
    DefaultTreeModel model;
    JPopupMenu popupMenu;
    TreePath treePath;
    TreeCellEditor editor;

    public SDMSExitStateWindow(SDMSDesktop sDMSDesktop, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(sDMSDesktop, string, bl, bl2, bl3, bl4);
        this.setBounds(10, 10, 150, 150);
        this.setFrameIcon(new ImageIcon(SDMSDesktop.class.getResource("ExitStateDefinitionIconSmall.gif")));
        this.menuItem.setMnemonic('s');
        this.toolBarButton.setIcon(new ImageIcon(SDMSDesktop.class.getResource("ExitStateDefinitionIcon.gif")));
        this.doesRefresh = true;
        this.doesDrop = true;
        this.doesCreate = true;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 3, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        System.err.println("Starting drag");
        String string = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            string = (String)defaultMutableTreeNode.getUserObject();
        }
        if (string == null) {
            return;
        }
        dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, new StringSelection(string), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void initialize() {
        super.initialize();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("the invisible root");
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
        this.tree = new JTree(this.model);
        final ImageIcon imageIcon = new ImageIcon(SDMSDesktop.class.getResource("ExitStateDefinitionIconVerySmall.gif"));
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Icon getLeafIcon() {
                return imageIcon;
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setEditable(true);
        this.editor = this.tree.getCellEditor();
        this.editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                String string = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SDMSExitStateWindow.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    string = (String)defaultMutableTreeNode.getUserObject();
                }
                if (string == null) {
                    return;
                }
                String string2 = (String)SDMSExitStateWindow.this.editor.getCellEditorValue();
                SDMSOutput sDMSOutput = SDMSExitStateWindow.this.desktop.serverConnection.execute("RENAME EXIT STATE DEFINITION " + string + " TO " + string2 + ";");
                if (sDMSOutput.error != null) {
                    JOptionPane.showMessageDialog(SDMSExitStateWindow.this.tree, "ERROR: " + sDMSOutput.error.code + "\n TEXT: " + sDMSOutput.error.message, "Error", 0);
                    SDMSExitStateWindow.this.editor.cancelCellEditing();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.popupMenu = new JPopupMenu();
        AbstractAction abstractAction = new AbstractAction("Create"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSExitStateWindow.this.tree.repaint();
                SDMSExitStateWindow.this.create();
            }
        };
        this.popupMenu.add(abstractAction);
        abstractAction = new AbstractAction("Rename"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSExitStateWindow.this.tree.repaint();
                SDMSExitStateWindow.this.rename();
            }
        };
        this.popupMenu.add(abstractAction);
        abstractAction = new AbstractAction("Drop"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSExitStateWindow.this.tree.repaint();
                SDMSExitStateWindow.this.drop();
            }
        };
        this.popupMenu.add(abstractAction);
        this.tree.add(this.popupMenu);
        this.tree.addMouseListener(new PopupTrigger());
        this.refresh();
    }

    @Override
    public void refresh() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("the invisible root");
        SDMSOutput sDMSOutput = this.desktop.serverConnection.execute("LIST EXIT STATE DEFINITION;");
        if (sDMSOutput.error == null) {
            if (sDMSOutput.container != null && sDMSOutput.container.columns > 0) {
                Vector vector = new Vector();
                Iterator iterator = sDMSOutput.container.dataset.iterator();
                int n = sDMSOutput.container.indexForName(null, "NAME");
                while (iterator.hasNext()) {
                    Vector vector2 = (Vector)iterator.next();
                    vector.add(vector2.elementAt(n));
                }
                Collections.sort(vector);
                for (String string : vector) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            }
            this.model.setRoot(defaultMutableTreeNode);
        } else {
            JOptionPane.showMessageDialog(this.tree, "ERROR: " + sDMSOutput.error.code + "\n TEXT: " + sDMSOutput.error.message, "Error", 0);
        }
        this.tree.clearSelection();
    }

    @Override
    public void drop() {
        String string = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null) {
            string = (String)defaultMutableTreeNode.getUserObject();
        }
        if (string == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.tree, "Do You realy want to delete Exit State Definition " + string + " ?", "Confirm", 0, 3);
        if (n == 0) {
            SDMSOutput sDMSOutput = this.desktop.serverConnection.execute("DROP EXIT STATE DEFINITION " + string + ";");
            if (sDMSOutput.error != null) {
                JOptionPane.showMessageDialog(this.tree, "ERROR: " + sDMSOutput.error.code + "\n TEXT: " + sDMSOutput.error.message, "Error", 0);
            }
            this.tree.clearSelection();
            this.refresh();
        }
    }

    @Override
    public void rename() {
        if (this.treePath == null) {
            return;
        }
        this.tree.startEditingAtPath(this.treePath);
    }

    class PopupTrigger
    extends MouseAdapter {
        PopupTrigger() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            SDMSExitStateWindow.this.treePath = SDMSExitStateWindow.this.tree.getPathForLocation(n, n2);
            if (SDMSExitStateWindow.this.treePath != null) {
                SDMSExitStateWindow.this.tree.setSelectionPath(SDMSExitStateWindow.this.treePath);
                SDMSExitStateWindow.this.tree.repaint();
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3) {
                    SDMSExitStateWindow.this.popupMenu.show(SDMSExitStateWindow.this.tree, n, n2);
                }
            } else {
                SDMSExitStateWindow.this.tree.clearSelection();
            }
        }
    }
}

