/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.ProcessInfo;
import de.independit.scheduler.jobserver.Server;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.Utils;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.parser.ScopeConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Vector;

public class Config
extends HashMap {
    public static final String __version = "@(#) $Id: Config.java,v 2.16.4.1 2013/03/14 10:24:05 ronald Exp $";
    public static final String REPO_HOST = "REPOHOST";
    public static final String REPO_PORT = "REPOPORT";
    public static final String REPO_USER = "REPOUSER";
    public static final String REPO_PASS = "REPOPASS";
    public static final String RECONNECT_DELAY = "RECONNECTDELAY";
    public static final String DEFAULT_WORKDIR = "DEFAULTWORKDIR";
    public static final String USE_PATH = "USEPATH";
    public static final String VERBOSE_LOGS = "VERBOSELOGS";
    public static final String TRACE_LEVEL = "TRACELEVEL";
    public static final String BOOTTIME = "BOOTTIME";
    public static final String NOP_DELAY = "NOPDELAY";
    public static final String JOB_EXECUTOR = "JOBEXECUTOR";
    public static final String JOB_FILE_PREFIX = "JOBFILEPREFIX";
    public static final String ENV_MAPPING = "ENV";
    public static final String DYNAMIC = "DYNAMIC";
    public static final String NOTIFY_PORT = "NOTIFYPORT";
    public static final String HTTP_PORT = "HTTPPORT";
    public static final String HTTP_HOST = "HTTPHOST";
    public static final String HTTP_LOGENCODING = "HTTPLOGENCODING";
    public static final String HTTP_INTERFACE = "HTTP_INTERFACE";
    public static final String ONLINE_SERVER = "ONLINE_SERVER";
    public static final String NAME_PATTERN = "NAME_PATTERN_";
    public static final String KEYSTORE = "KEYSTORE";
    public static final String TRUSTSTORE = "TRUSTSTORE";
    public static final String KEYSTOREPW = "KEYSTOREPASSWORD";
    public static final String TRUSTSTOREPW = "TRUSTSTOREPASSWORD";
    public static final String USE_SSL = "USE_SSL";
    public static final String CREATE_WORKDIR = "CREATE_WORKDIR";
    public static final String CONVERT_NEWLINE = "CONVERT_NEWLINE";
    public static final String STARTTIME_JITTER = "STARTTIME_JITTER";
    public static final Long NOREPLACE = 0L;
    public static final Long CRLF_TO_LF = 1L;
    public static final Long LF_TO_CRLF = 2L;
    private static final String[] LONG_VALUES = new String[]{"REPOPORT", "TRACELEVEL", "RECONNECTDELAY", "NOPDELAY", "NOTIFYPORT", "HTTPPORT", "CONVERT_NEWLINE", "STARTTIME_JITTER"};
    private static final String[] BOOLEAN_VALUES = new String[]{"USEPATH", "VERBOSELOGS", "ONLINE_SERVER", "USE_SSL", "CREATE_WORKDIR"};
    private static final String[] FILE_VALUES = new String[]{"DEFAULTWORKDIR", "JOBEXECUTOR", "JOBFILEPREFIX"};
    private static final String[] SECOND_VALUES = new String[]{"RECONNECTDELAY", "NOPDELAY", "STARTTIME_JITTER"};
    private static final String[] VECTOR_VALUES = new String[]{"NAME_PATTERN_", "HTTP_INTERFACE"};
    private static final String[] REQUIRED = new String[]{"REPOHOST", "REPOPORT", "REPOUSER", "REPOPASS"};
    private static final String[] WRITE_THROUGH = new String[]{"REPOHOST", "REPOPORT", "REPOUSER", "USE_SSL", "KEYSTOREPASSWORD", "TRUSTSTOREPASSWORD", "KEYSTORE", "TRUSTSTORE"};
    private static final String[] DEPRECATED = new String[]{"RECONNECTDELAY", "NOPDELAY", "DEFAULTWORKDIR", "USEPATH", "VERBOSELOGS", "NOPDELAY", "JOBEXECUTOR", "JOBFILEPREFIX", "ENV", "NOTIFYPORT", "ONLINE_SERVER", "KEYSTORE", "TRUSTSTORE", "CREATE_WORKDIR"};
    public static final String[] ALL_VALUES = new String[]{"REPOHOST", "REPOPORT", "RECONNECTDELAY", "DEFAULTWORKDIR", "USEPATH", "VERBOSELOGS", "TRACELEVEL", "BOOTTIME", "NOPDELAY", "JOBEXECUTOR", "JOBFILEPREFIX", "ENV", "DYNAMIC", "NOTIFYPORT", "HTTPPORT", "HTTP_INTERFACE", "HTTPHOST", "HTTPLOGENCODING", "ONLINE_SERVER", "NAME_PATTERN_", "KEYSTORE", "TRUSTSTORE", "KEYSTOREPASSWORD", "TRUSTSTOREPASSWORD", "USE_SSL", "CREATE_WORKDIR", "CONVERT_NEWLINE", "STARTTIME_JITTER"};
    private final File startupWorkdir;
    private final File cfgFileName;
    private StreamTokenizer scanner;
    private LineNumberReader scannerFile;
    private boolean scanningConfigFile;
    private static Boolean isWindows = null;
    public static final String[] defaultKeys = new String[]{"USEPATH", "VERBOSELOGS", "RECONNECTDELAY", "NOPDELAY", "TRACELEVEL", "BOOTTIME", "ONLINE_SERVER", "CREATE_WORKDIR", "HTTPLOGENCODING", "HTTPPORT", "NOTIFYPORT", "CONVERT_NEWLINE", "STARTTIME_JITTER"};
    public static final Object[] defaultValues = new Object[]{Boolean.FALSE, Boolean.FALSE, 30L, 5L, 1, "NONE", Boolean.TRUE, Boolean.FALSE, "utf-8", 0L, 0L, 0L, 5L};

    public static boolean isWindows() {
        if (isWindows == null) {
            String string = System.getProperty("os.name");
            isWindows = string.toUpperCase().indexOf("WINDOWS") == -1 ? Boolean.FALSE : Boolean.TRUE;
        }
        return isWindows;
    }

    private final void ensureDefaults() {
        for (int i = 0; i < defaultKeys.length; ++i) {
            if (this.containsKey(defaultKeys[i])) continue;
            this.put(defaultKeys[i], defaultValues[i]);
        }
    }

    public static Object getDefaultValue(String string) {
        for (int i = 0; i < defaultKeys.length; ++i) {
            if (!defaultKeys[i].equals(string)) continue;
            return defaultValues[i];
        }
        return null;
    }

    private final void initScanner() throws IOException {
        this.scannerFile = new LineNumberReader(new InputStreamReader(new FileInputStream(this.cfgFileName)));
        this.scanner = new StreamTokenizer(this.scannerFile);
        this.scanner.commentChar(35);
        this.scanner.wordChars(95, 95);
        this.scanner.slashStarComments(true);
        this.scanner.slashSlashComments(true);
        this.scanner.eolIsSignificant(true);
    }

    private final String configFileError(String string) {
        if (this.scannerFile != null) {
            return this.cfgFileName + ", line " + (this.scannerFile.getLineNumber() + 1) + ": " + string;
        }
        return string;
    }

    private final Object scanValue(String string) throws IOException, CommonErrorException {
        this.scanner.nextToken();
        if (this.scanner.ttype == 61 || this.scanner.ttype == 58) {
            this.scanner.nextToken();
        }
        switch (this.scanner.ttype) {
            case -3: 
            case 34: {
                return this.scanner.sval;
            }
            case -2: {
                return (long)this.scanner.nval;
            }
            case -1: 
            case 10: {
                if (!string.equals(USE_PATH) && !string.equals(VERBOSE_LOGS)) break;
                return Boolean.TRUE;
            }
        }
        throw new CommonErrorException(this.configFileError("(04301271412) Missing value of " + string));
    }

    private final void scanFile() throws IOException, CommonErrorException {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        while (this.scanner.nextToken() != -1) {
            Object object;
            if (this.scanner.ttype == 10) continue;
            if (this.scanner.ttype != -3) {
                throw new CommonErrorException(this.configFileError("(04301271423) Identifier expected"));
            }
            String string = this.scanner.sval.toUpperCase();
            if (!Utils.isOneOf(string, WRITE_THROUGH) && !Utils.isOneOf(string, REQUIRED)) {
                if (Utils.isOneOf(string, DEPRECATED)) {
                    Trace.warning(this.configFileError("(04305082226) Deprecated entry: " + string));
                } else if (!Utils.isOneOf(string, new String[]{TRACE_LEVEL, BOOTTIME})) {
                    Trace.warning(this.configFileError("(04305082228) Unknown entry: " + string));
                }
            }
            if (string.equals(ENV_MAPPING)) {
                object = this.scanValue("ENV key").toString().toUpperCase();
                if (hashMap.containsKey(object)) {
                    Trace.warning(this.configFileError("(04305072227) Duplicate ENV entry: " + (String)object));
                }
                String string2 = this.scanValue("ENV value").toString().toUpperCase();
                hashMap.put(object, string2);
                continue;
            }
            if (this.containsKey(string)) {
                Trace.warning(this.configFileError("(04305082215) Duplicate entry: " + string));
            }
            object = this.scanValue(string);
            this.put(string, object);
        }
        this.put(ENV_MAPPING, hashMap);
    }

    public Config(String string) throws CommonErrorException {
        try {
            this.cfgFileName = new File(string).getCanonicalFile();
            this.scanningConfigFile = true;
            this.initScanner();
            this.scanFile();
        }
        catch (IOException iOException) {
            throw new CommonErrorException(this.configFileError("(04305082230) Error processing config file: " + iOException.getMessage()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommonErrorException(this.configFileError(illegalArgumentException.getMessage()));
        }
        finally {
            this.scanningConfigFile = false;
            try {
                if (this.scannerFile != null) {
                    this.scannerFile.close();
                }
            }
            catch (IOException iOException) {
                Trace.error("(04504100141) Error closing config file: " + iOException.getMessage());
            }
        }
        try {
            this.startupWorkdir = this.cfgFileName.getParentFile().getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new CommonErrorException(this.configFileError("(04305181347) Cannot determine startup directory: " + iOException.getMessage()));
        }
        for (int i = 0; i < REQUIRED.length; ++i) {
            if (this.containsKey(REQUIRED[i])) continue;
            throw new CommonErrorException("(04305100039) Missing entry: " + REQUIRED[i]);
        }
        this.ensureDefaults();
    }

    @Override
    public Object put(Object object, Object serializable) {
        Object object2;
        Object object3;
        Serializable serializable2;
        if (object == null || serializable == null) {
            throw new NullPointerException("(04305091334) Class Config does not permit null keys/values");
        }
        String string = ((String)object).toUpperCase();
        if (Utils.isOneOf(string, LONG_VALUES) && !(serializable instanceof Long)) {
            if (serializable == null || ((Object)serializable).toString().trim().equals("")) {
                serializable2 = Config.getDefaultValue(string);
                serializable = serializable2 != null ? (Long)serializable2 : Long.valueOf(0L);
            } else {
                try {
                    serializable = Long.valueOf(((Object)serializable).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("(04305141714) Error converting value ('" + ((Object)serializable).toString() + "'): " + numberFormatException.getMessage());
                }
            }
        } else if (Utils.isOneOf(string, BOOLEAN_VALUES) && !(serializable instanceof Boolean)) {
            serializable = Boolean.valueOf(((Object)serializable).toString());
        } else if (Utils.isOneOf(string, FILE_VALUES) && !(serializable instanceof File)) {
            serializable = new File(((Object)serializable).toString());
        } else if (string.equals(ENV_MAPPING)) {
            if (!(serializable instanceof HashMap)) {
                throw new IllegalArgumentException("(04305151810) " + string + " values must be of class java.util.HashMap");
            }
            serializable2 = (HashMap)serializable;
            object3 = new HashMap();
            object2 = new Vector(((HashMap)serializable2).keySet());
            int n = ((Vector)object2).size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)((Vector)object2).get(i);
                if (ScopeConfig.isInternalEntry(string2)) continue;
                String string3 = (String)((HashMap)serializable2).get(string2);
                ((HashMap)object3).put(string2.toUpperCase(), string3.toUpperCase());
            }
            serializable = object3;
        } else if (string.startsWith(NAME_PATTERN)) {
            serializable2 = (Vector)this.get(NAME_PATTERN);
            if (serializable2 == null) {
                serializable2 = new Vector();
            }
            ((Vector)serializable2).add(serializable);
            serializable = serializable2;
            string = NAME_PATTERN;
        }
        if (Utils.isOneOf(string, SECOND_VALUES)) {
            serializable = 1000L * (Long)serializable;
        }
        if (string.equals(TRACE_LEVEL)) {
            Trace.setLevel(((Long)serializable).intValue());
        }
        if (string.equals(BOOTTIME)) {
            serializable2 = (String)((Object)serializable);
            object3 = null;
            if (((String)((Object)serializable2)).equals("NONE")) {
                ProcessInfo.setBoottimeHow('N');
            } else if (((String)((Object)serializable2)).equals("SYSTEM")) {
                ProcessInfo.setBoottimeHow('S');
            } else if (((String)((Object)serializable2)).equals("FILE")) {
                ProcessInfo.setBoottimeHow('F');
            } else {
                object3 = "(04307111914) Unknown boottime determination: " + (String)((Object)serializable2);
            }
            if (object3 != null) {
                throw new IllegalArgumentException("(04307111418) Cannot determine " + serializable + " boottime: " + (String)object3);
            }
        }
        if (!this.scanningConfigFile && Utils.isOneOf(string, WRITE_THROUGH)) {
            try {
                this.updateConfigFile(string, serializable);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("(04305091428) Error processing config file: " + iOException.getMessage());
            }
        }
        if (string.equals(DEFAULT_WORKDIR)) {
            serializable2 = (File)serializable;
            if (!((File)serializable2).isAbsolute()) {
                throw new IllegalArgumentException("(04301271441) Default working directory must be absolute");
            }
            object3 = Utils.chdir(((File)serializable2).toString());
            if (object3 != null) {
                throw new IllegalArgumentException("(04301271442) Cannot chdir() to default working directory " + serializable2 + ": " + (String)object3);
            }
        }
        if (string.equals(JOB_EXECUTOR)) {
            this.validateJobExecutor((File)serializable);
        }
        if (string.equals(JOB_FILE_PREFIX)) {
            if (this.containsKey(REPO_USER)) {
                serializable2 = (File)serializable;
                serializable = new File(((File)serializable2).toString() + (((File)serializable2).isDirectory() ? File.separator : "") + this.get(REPO_USER).toString() + "-");
            }
            if ((serializable2 = ((File)serializable).getParentFile()) == null) {
                throw new IllegalArgumentException("(04301271438) Job file prefix contains no directory");
            }
            if (!((File)serializable2).isAbsolute()) {
                throw new IllegalArgumentException("(04301271439) Job file prefix must be absolute");
            }
            if (!(((File)serializable2).isDirectory() && ((File)serializable2).canRead() && ((File)serializable2).canWrite())) {
                throw new IllegalArgumentException("(04301271440) Job file prefix denotes no (accessible) directory");
            }
        }
        serializable2 = super.put(string, serializable);
        if (string.equals(REPO_USER) && this.containsKey(JOB_FILE_PREFIX)) {
            object3 = (File)this.get(JOB_FILE_PREFIX);
            if (serializable2 != null) {
                object2 = ((File)object3).toString();
                object3 = new File(((String)object2).substring(0, ((String)object2).length() - ((String)((Object)serializable2)).length() - 1));
            }
            this.put(JOB_FILE_PREFIX, object3);
        }
        return serializable2;
    }

    @Override
    public Object remove(Object object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("(04305181334) Class Config does not permit null keys");
        }
        String string = ((String)object).toUpperCase();
        if (Utils.isOneOf(string, REQUIRED)) {
            throw new IllegalArgumentException("(04504100123) Cannot remove() a required entry: " + string);
        }
        if (string.equals(TRACE_LEVEL)) {
            Trace.setLevel(1);
        }
        if (Utils.isOneOf(string, WRITE_THROUGH)) {
            try {
                this.updateConfigFile(string);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("(04305091429) Error processing config file: " + iOException.getMessage());
            }
        }
        if (string.equals(DEFAULT_WORKDIR) && (object2 = Utils.chdir(this.startupWorkdir.toString())) != null) {
            throw new IllegalArgumentException("(04305181339) Cannot chdir() to startup working directory " + this.startupWorkdir + ": " + object2);
        }
        object2 = super.remove(string);
        if (string.equals(REPO_USER) && this.containsKey(JOB_FILE_PREFIX)) {
            File file = (File)this.get(JOB_FILE_PREFIX);
            if (object2 != null) {
                String string2 = file.toString();
                file = new File(string2.substring(0, string2.length() - ((String)object2).length() - 1));
            }
            this.put(JOB_FILE_PREFIX, file);
        }
        this.ensureDefaults();
        return object2;
    }

    private final Vector readAllLines() throws IOException {
        Vector<String> vector = new Vector<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.cfgFileName)));){
            while (bufferedReader.ready()) {
                vector.add(bufferedReader.readLine());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAllLines(Vector vector) throws IOException {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(this.cfgFileName, "rws");){
            randomAccessFile.setLength(0L);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                randomAccessFile.writeBytes(vector.get(i) + "\n");
            }
        }
    }

    private final void skipValue() throws IOException {
        this.scanner.nextToken();
        if (this.scanner.ttype == 61 || this.scanner.ttype == 58) {
            this.scanner.nextToken();
        }
    }

    private final Vector getNoOfAllLines(String string) throws IOException {
        Vector<Integer> vector = new Vector<Integer>();
        this.initScanner();
        try {
            while (this.scanner.nextToken() != -1) {
                if (this.scanner.ttype != -3) continue;
                if (this.scanner.sval.toUpperCase().equals(string)) {
                    vector.add(this.scannerFile.getLineNumber());
                }
                this.skipValue();
                if (!string.equals(ENV_MAPPING)) continue;
                this.skipValue();
            }
        }
        finally {
            this.scannerFile.close();
        }
        return vector;
    }

    private final int skipBlanks(String string, int n) {
        while (true) {
            if (Character.isWhitespace(string.charAt(n))) {
                ++n;
                continue;
            }
            if (!string.substring(n, n + 2).equals("/*")) break;
            n = string.indexOf("*/", n) + 2;
        }
        return n;
    }

    public static final String quoted(String string) {
        String string2 = string.replaceAll("\\\"", "\\\\\"");
        if (string2.matches(".*[^0-9].*") || string2.length() == 0) {
            return "\"" + string2 + "\"";
        }
        return string2;
    }

    private final void updateConfigFile(String string, Object object) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        String string2 = string + " = THIS_WILL_BE_REPLACED!!!";
        if (this.containsKey(string) && this.get(string).equals(object)) {
            return;
        }
        Vector vector = this.readAllLines();
        Vector vector2 = this.getNoOfAllLines(string);
        if (!vector2.isEmpty()) {
            n4 = (Integer)vector2.get(vector2.size() - 1);
        } else {
            Trace.warning("(04305101139) No line with " + string + " found in " + this.cfgFileName);
            vector.add("");
            vector.add(string2);
            n4 = vector.size() - 1;
        }
        String string3 = (String)vector.get(n4);
        int n5 = string3.length();
        int n6 = 0;
        do {
            n2 = string3.toUpperCase().indexOf(string, n6);
            n3 = string3.lastIndexOf("/*", n2);
            n6 = string3.indexOf("*/", n3) + 1;
        } while (n3 != -1 && n6 != -1 && n2 >= n3 && n2 <= n6);
        if (string3.charAt(n2 = this.skipBlanks(string3, n2 + string.length())) == '=' || string3.charAt(n2) == ':') {
            n2 = this.skipBlanks(string3, n2 + 1);
        }
        if (string3.charAt(n2) == '\"') {
            for (n = n2 + 1; n < n5 && string3.charAt(n) != '\"'; ++n) {
                if (string3.charAt(n) != '\\') continue;
                ++n;
            }
        } else {
            while (n < n5 && !Character.isWhitespace(string3.charAt(n))) {
                ++n;
            }
        }
        if (n < n5 && string3.charAt(n) == '\"') {
            ++n;
        }
        String string4 = string3.substring(0, n2) + Config.quoted(object.toString());
        if (n < n5) {
            string4 = string4 + string3.substring(n);
        }
        vector.set(n4, string4);
        this.writeAllLines(vector);
    }

    private final void updateConfigFile(String string) throws IOException {
        Vector vector = this.readAllLines();
        Vector vector2 = this.getNoOfAllLines(string);
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)vector2.get(i);
            vector.set(n2, "// " + vector.get(n2));
        }
        this.writeAllLines(vector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateJobExecutor(File file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("(04301271443) Job executor must be absolute");
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(new String[]{file.toString(), "--version"});
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                 BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String string;
                process.waitFor();
                while ((string = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(string);
                }
                while ((string = bufferedReader2.readLine()) != null) {
                    if (stringBuffer2.length() != 0) {
                        stringBuffer2.append("\n");
                    }
                    stringBuffer2.append(string);
                }
                if (stringBuffer2.length() != 0) {
                    throw new IllegalArgumentException("(04301271418) Job executor: " + stringBuffer2.toString());
                }
                String string2 = stringBuffer.toString().toLowerCase();
                string2 = string2.substring(0, string2.indexOf("\n"));
                String string3 = string2.substring(string2.lastIndexOf("(") + 1, string2.lastIndexOf(")"));
                String string4 = Server.getVersionInfo().toLowerCase();
                System.out.println(string4);
                string4 = string4.substring(0, string4.indexOf("\n"));
                String string5 = string4.substring(string4.lastIndexOf("(") + 1, string4.lastIndexOf(")"));
                if (!string3.equals(string5)) {
                    throw new IllegalArgumentException("(04301271419) Invalid/non matching job executor: " + file + " [ " + string4 + " != " + string2 + " ]");
                }
            }
        }
        catch (IOException iOException) {
            Trace.error("(04301271416) Cannot launch job executor: " + iOException.getMessage());
            System.exit(1);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalArgumentException("(04301271417) Cannot launch job executor: " + interruptedException.getMessage());
        }
    }
}

