/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;

public class HttpThread
extends Thread {
    private static HttpThread httpThread = null;
    private int port = 0;
    private final Config cfg;
    private boolean run = true;
    private boolean needFooter = false;
    private boolean gotFooter = false;
    private int reqNr = 0;
    private static final String CLGTH = "Content-Length:";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String FNAME = "FNAME";
    private static final String LIMIT = "LIMIT";
    private static final int defaultLimit = 100000;
    private static final int sleepInterval = 5000;
    private static final int timeoutInterval = 5000;
    private static final String DIRECTORY_UP_PATTERN = ".*[/\\\\]\\.\\.[/\\\\].*";

    private HttpThread(Config config) {
        this.setDaemon(true);
        this.cfg = config;
    }

    public static HttpThread getInstance(Config config) {
        if (httpThread == null) {
            httpThread = new HttpThread(config);
        }
        return httpThread;
    }

    private String extrPostMsg(int n, BufferedReader bufferedReader) {
        char[] cArray = new char[n];
        try {
            bufferedReader.read(cArray, 0, n);
        }
        catch (IOException iOException) {
            return "";
        }
        return new String(cArray, 0, n);
    }

    private boolean authenticate(HashMap hashMap) {
        return true;
    }

    private String getFile(RandomAccessFile randomAccessFile, long l) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (randomAccessFile == null) {
            return null;
        }
        long l2 = randomAccessFile.length();
        if (l2 > l) {
            stringBuffer.append("<SPAN style=\"color:#ff0000;\">\n");
            stringBuffer.append("The length of the requested file exceeds the limit of " + l + " Bytes !<BR>\n");
            stringBuffer.append("Only the last " + l + " Bytes of the file are returned.<BR>\n");
            stringBuffer.append("</SPAN>\n");
            stringBuffer.append("<HR>\n");
            randomAccessFile.seek(l2 - l);
            l2 = l;
        }
        byte[] byArray = new byte[(int)l2];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        stringBuffer.append("<PRE>\n");
        stringBuffer.append(new String(byArray));
        stringBuffer.append("\n</PRE>\n");
        return stringBuffer.toString();
    }

    private void executeQuery(String string, PrintWriter printWriter) throws UnsupportedEncodingException {
        block15: {
            Object object;
            Object object2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = string.split("\\&");
            for (int i = 0; i < stringArray.length; ++i) {
                object2 = stringArray[i].split("=");
                if (((String[])object2).length <= 1) continue;
                object = URLDecoder.decode(object2[1], "UTF-8");
                hashMap.put(object2[0], (String)object);
            }
            if (!this.authenticate(hashMap)) {
                printWriter.println("ERROR: insufficient privileges");
            } else {
                RandomAccessFile randomAccessFile = null;
                if (hashMap.containsKey(FNAME)) {
                    object2 = (String)hashMap.get(FNAME);
                    try {
                        randomAccessFile = new RandomAccessFile((String)object2, "r");
                    }
                    catch (Exception exception) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.printPreamble(printWriter, 404, "Not Found");
                        printWriter.println("ERROR: couldn't open the requested file");
                        this.printFooter(printWriter);
                        printWriter.flush();
                        return;
                    }
                    object = (Vector)this.cfg.get("NAME_PATTERN_");
                    boolean bl = false;
                    if (object != null && !((String)object2).matches(DIRECTORY_UP_PATTERN)) {
                        for (int i = 0; i < ((Vector)object).size(); ++i) {
                            String string2 = (String)((Vector)object).get(i);
                            if (!((String)object2).matches(string2)) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        this.printPreamble(printWriter, 403, "Forbidden");
                        printWriter.println("ERROR: The requested filename doesn't match any of the configured patterns");
                        Trace.error("[HttpThread] ERROR: Illegal file request : " + (String)object2);
                        this.printFooter(printWriter);
                        printWriter.flush();
                        return;
                    }
                    long l = hashMap.containsKey(LIMIT) ? Long.parseLong((String)hashMap.get(LIMIT)) : 100000L;
                    try {
                        String string3 = this.getFile(randomAccessFile, l);
                        if (string3 == null) {
                            this.printPreamble(printWriter, 500, "Internal Server Error");
                            Trace.error("[HttpThread] ERROR: Internal error: getFile returned null");
                            break block15;
                        }
                        this.printPreamble(printWriter, 200, "OK", (String)object2);
                        printWriter.print(string3);
                    }
                    catch (IOException iOException) {
                        this.printPreamble(printWriter, 500, "Internal Server Error");
                        Trace.error("[HttpThread] ERROR: IOEception : " + iOException.toString());
                    }
                } else {
                    this.printPreamble(printWriter, 400, "Bad Request");
                }
            }
        }
        this.printFooter(printWriter);
        printWriter.flush();
    }

    private void printPreamble(PrintWriter printWriter, int n, String string) {
        this.printPreamble(printWriter, n, string, null);
    }

    private void printPreamble(PrintWriter printWriter, int n, String string, String string2) {
        printWriter.println("HTTP/1.0 " + n + " " + string);
        printWriter.println("Content-Type: text/html");
        printWriter.println("Server: BICsuiteJobserver");
        printWriter.println("");
        if (n == 200 || n == 404) {
            printWriter.println("<!DOCTYPE HTML>");
            printWriter.println("<html>");
            String string3 = (String)this.cfg.get("HTTPLOGENCODING");
            if (string3 == null) {
                string3 = "utf-8";
            }
            if (string2 != null) {
                printWriter.println("<head>");
                printWriter.println("<meta charset=\"" + string3 + "\">");
                printWriter.println("<title>" + string2 + "</title>");
                printWriter.println("</head>");
            }
            printWriter.println("<body>");
        }
        this.needFooter = true;
    }

    private void printFooter(PrintWriter printWriter) {
        printWriter.println("</body>");
        printWriter.println("</html>");
        this.gotFooter = true;
    }

    private static InetAddress parseHttpIf(String string) {
        InetAddress inetAddress;
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Trace.warning("Unable to resolve the configured IP Address: " + unknownHostException.toString());
            inetAddress = null;
        }
        Trace.warning("Using Inet Address/Interface " + (inetAddress == null ? "<ALL>" : inetAddress.toString()) + " for listening");
        return inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        var1_1 = Runtime.getRuntime();
        var2_2 = null;
        block32: while (this.run) {
            var3_3 = (Long)this.cfg.get("HTTPPORT");
            var4_4 = (String)this.cfg.get("HTTP_INTERFACE");
            var5_5 = HttpThread.parseHttpIf(var4_4);
            this.port = var3_3 != null ? var3_3.intValue() : 0;
            while (this.port == 0) {
                try {
                    HttpThread.sleep(5000L);
                    if (!this.run) {
                        break block32;
                    }
                }
                catch (Exception var6_7) {
                    // empty catch block
                }
                if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null) {
                    this.port = var3_3.intValue();
                    continue;
                }
                this.port = 0;
            }
            var6_6 = null;
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    block57: {
                        if (var6_6 == null) {
                            if (var5_5 != null) {
                                try {
                                    var6_6 = new ServerSocket(this.port, 5, var5_5);
                                }
                                catch (Exception var7_9) {
                                    Trace.warning("Failed to create a server socket for address " + var5_5.toString());
                                    var6_6 = new ServerSocket(this.port);
                                }
                            } else {
                                var6_6 = new ServerSocket(this.port, 5);
                            }
                        }
                        var7_8 = null;
                        var2_2 = var6_6.accept();
                        ++this.reqNr;
                        var8_12 = var2_2.getInetAddress().getHostAddress();
                        var2_2.setSoTimeout(5000);
                        var9_22 = new BufferedReader(new InputStreamReader(var2_2.getInputStream()));
                        var7_8 = new PrintWriter(var2_2.getOutputStream());
                        var10_23 = null;
                        var11_27 = 0;
                        var12_28 = "";
                        do {
                            var10_23 = var9_22.readLine();
                            Trace.message("[HttpThread] Received Request " + this.reqNr + " from " + var8_12 + " : " + var10_23);
                            if (var10_23 == null) break;
                            var13_29 = var10_23.split(" ");
                            if (var13_29[0].equals("Content-Length:")) {
                                var11_27 = Integer.parseInt(var13_29[1]);
                                continue;
                            }
                            if (var13_29[0].equals("POST")) {
                                var12_28 = this.extrPostMsg(var11_27, (BufferedReader)var9_22);
                                continue;
                            }
                            if (!var13_29[0].equals("GET")) continue;
                            if (var13_29.length > 1) {
                                var14_30 = var13_29[1].split("\\?");
                                if (var14_30.length > 1) {
                                    var12_28 = var13_29[1].split("\\?")[1];
                                    continue;
                                }
                                var12_28 = "FNAME=" + var13_29[1];
                                continue;
                            }
                            Trace.error("[HttpThread] Request " + this.reqNr + " Invalid : " + var10_23);
                        } while (!var10_23.equals(""));
                        this.executeQuery(var12_28, var7_8);
                        Trace.message("[HttpThread] Request " + this.reqNr + " from " + var8_12 + " processed");
                        var7_8.close();
                        try {
                            if (var2_2 == null) break block57;
                            if (this.needFooter && !this.gotFooter && var7_8 != null) {
                                this.printFooter(var7_8);
                            }
                            var2_2.close();
                            Trace.message("[HttpThread] Request " + this.reqNr + " connection closed");
                            var2_2 = null;
                        }
                        catch (Exception var8_13) {
                            Trace.error("[HttpThread] Request " + this.reqNr + " caught Exception (314) : " + var8_13.toString());
                            var9_22 = var8_13.getStackTrace();
                            for (var10_24 = 0; var10_24 < ((Object)var9_22).length; ++var10_24) {
                                Trace.error("[HttpThread] " + var9_22[var10_24].toString());
                            }
                        }
                    }
                    if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) ** GOTO lbl-1000
                    try {
                        var6_6.close();
                        var6_6 = null;
                    }
                    catch (Exception var8_14) {}
                    break;
                    catch (SocketTimeoutException var8_15) {
                        block59: {
                            try {
                                if (var2_2 == null) break block59;
                                if (this.needFooter && !this.gotFooter && var7_8 != null) {
                                    this.printFooter(var7_8);
                                }
                                var2_2.close();
                                Trace.message("[HttpThread] Request " + this.reqNr + " connection closed");
                                var2_2 = null;
                            }
                            catch (Exception var8_16) {
                                Trace.error("[HttpThread] Request " + this.reqNr + " caught Exception (314) : " + var8_16.toString());
                                var9_22 = var8_16.getStackTrace();
                                for (var10_25 = 0; var10_25 < ((StackTraceElement[])var9_22).length; ++var10_25) {
                                    Trace.error("[HttpThread] " + var9_22[var10_25].toString());
                                }
                            }
                        }
                        if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) ** GOTO lbl-1000
                        try {
                            var6_6.close();
                            var6_6 = null;
                        }
                        catch (Exception var8_17) {}
                        break;
                    }
                    catch (Throwable var8_18) {
                        this.port = 0;
                        Trace.error("[HttpThread] Request " + this.reqNr + " caught Exception (300): " + var8_18.toString());
                        var9_22 = var8_18.getStackTrace();
                        for (var10_26 = 0; var10_26 < ((StackTraceElement[])var9_22).length; ++var10_26) {
                            Trace.error("[HttpThread] " + var9_22[var10_26].toString());
                        }
                        try {
                            if (var2_2 == null) continue;
                            if (this.needFooter && !this.gotFooter && var7_8 != null) {
                                this.printFooter(var7_8);
                            }
                            var2_2.close();
                            Trace.message("[HttpThread] Request " + this.reqNr + " connection closed");
                            var2_2 = null;
                            continue;
                        }
                        catch (Exception var8_19) {
                            Trace.error("[HttpThread] Request " + this.reqNr + " caught Exception (314) : " + var8_19.toString());
                            var9_22 = var8_19.getStackTrace();
                            for (var10_26 = 0; var10_26 < ((Object)var9_22).length; ++var10_26) {
                                Trace.error("[HttpThread] " + var9_22[var10_26].toString());
                            }
                        }
                        if ((var3_3 = (Long)this.cfg.get("HTTPPORT")) != null && var3_3.intValue() == this.port) continue;
                        try {
                            var6_6.close();
                            var6_6 = null;
                        }
                        catch (Exception var8_20) {}
                        break;
                        {
                            catch (Throwable var15_31) {
                                block60: {
                                    try {
                                        if (var2_2 == null) break block60;
                                        if (this.needFooter && !this.gotFooter && var7_8 != null) {
                                            this.printFooter(var7_8);
                                        }
                                        var2_2.close();
                                        Trace.message("[HttpThread] Request " + this.reqNr + " connection closed");
                                        var2_2 = null;
                                    }
                                    catch (Exception var16_33) {
                                        Trace.error("[HttpThread] Request " + this.reqNr + " caught Exception (314) : " + var16_33.toString());
                                        var17_35 = var16_33.getStackTrace();
                                        for (var18_36 = 0; var18_36 < var17_35.length; ++var18_36) {
                                            Trace.error("[HttpThread] " + var17_35[var18_36].toString());
                                        }
                                    }
                                }
                                var3_3 = (Long)this.cfg.get("HTTPPORT");
                                if (var3_3 == null || var3_3.intValue() != this.port) {
                                    try {
                                        var6_6.close();
                                        var6_6 = null;
                                    }
                                    catch (Exception var16_34) {}
                                    break;
                                }
                                throw var15_31;
                            }
                        }
                    }
                    break;
                }
            }
            catch (Exception var7_10) {
                Trace.error("[HttpThread] Something went wrong : " + var7_10.toString());
                try {
                    if (this.run) {
                        HttpThread.sleep(5000L);
                    }
                    if (var6_6 != null) {
                        var6_6.close();
                        var6_6 = null;
                    }
                }
                catch (Exception var8_21) {
                    // empty catch block
                }
            }
            try {
                if (var6_6 == null) continue;
                var6_6.close();
                var6_6 = null;
            }
            catch (Exception var7_11) {}
        }
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setRun(boolean bl) {
        this.run = bl;
    }
}

