/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.proxy;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;

final class Config {
    public static final String __version = "@(#) $Id: Config.java,v 1.6.6.1 2013/03/14 10:24:08 ronald Exp $";
    public static final String S_TRACELEVEL = "TraceLevel";
    public static final String S_HOST = "Host";
    public static final String S_PORT = "Port";
    public static final String S_TLS = "TLS";
    public static final String S_MAX_CONNECTS = "MaxConnects";
    public static final String S_SERVER = "Server";
    public static final String S_KEYSTORE = "KeyStore";
    public static final String S_KEYSTOREPASSWORD = "KeyStorePassword";
    public static final String S_KEYSTOREPROVIDER = "KeyStoreProvider";
    public static final String S_KEYSTORETYPE = "KeyStoreType";
    public static final String S_TRUSTSTORE = "TrustStore";
    public static final String S_TRUSTSTOREPASSWORD = "TrustStorePassword";
    public static final String S_TRUSTSTOREPROVIDER = "TrustStoreProvider";
    public static final String S_TRUSTSTORETYPE = "TrustStoreType";
    public static final String S_CLIENTAUTHENTICATION = "ClientAuthentication";
    public static final String J_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String J_KEYSTOREPASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String J_KEYSTOREPROVIDER = "javax.net.ssl.keyStoreProvider";
    public static final String J_KEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String J_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String J_TRUSTSTOREPASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String J_TRUSTSTOREPROVIDER = "javax.net.ssl.trustStoreProvider";
    public static final String J_TRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    final int port;
    final int maxConnects;
    final String keystore;
    final String truststore;
    final String keystorepw;
    final String truststorepw;
    final String keystoreprov;
    final String truststoreprov;
    final String keystoretype;
    final String truststoretype;
    final boolean clientauth;
    boolean use_ssl;
    final String[] hosts;
    final int[] ports;
    final boolean[] ssls;
    final int numHosts;
    private final Properties props = new Properties();

    Config(String string) throws FatalException {
        Object object;
        Object object2;
        try {
            this.props.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            throw new FatalException("(04410231921) Error reading config file: " + iOException);
        }
        SystemEnvironment.setTraceLevel(this.getInt(S_TRACELEVEL, 0, 3, 1));
        this.port = this.getInt(S_PORT, 1, 65535, 2506);
        this.maxConnects = this.getInt(S_MAX_CONNECTS, 1, 2048, 50);
        this.clientauth = this.getBool(S_CLIENTAUTHENTICATION, false);
        this.use_ssl = this.getBool(S_TLS, false);
        this.keystore = this.getSSLProp(S_KEYSTORE, J_KEYSTORE);
        if (this.keystore == null) {
            this.use_ssl = false;
            this.props.setProperty(S_TLS, "false");
        }
        this.truststore = this.getSSLProp(S_TRUSTSTORE, J_TRUSTSTORE);
        this.keystorepw = this.getSSLProp(S_KEYSTOREPASSWORD, J_KEYSTOREPASSWORD);
        this.truststorepw = this.getSSLProp(S_TRUSTSTOREPASSWORD, J_TRUSTSTOREPASSWORD);
        this.keystoreprov = this.getSSLProp(S_KEYSTOREPROVIDER, J_KEYSTOREPROVIDER);
        this.truststoreprov = this.getSSLProp(S_TRUSTSTOREPROVIDER, J_TRUSTSTOREPROVIDER);
        this.keystoretype = this.getSSLProp(S_KEYSTORETYPE, J_KEYSTORETYPE);
        this.truststoretype = this.getSSLProp(S_TRUSTSTORETYPE, J_TRUSTSTORETYPE);
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap3 = new HashMap<Object, Object>();
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(S_SERVER)) continue;
            object2 = string2.split("\\.");
            if (((String[])object2).length != 3) {
                System.err.println("Wrong key format for config Entry " + string2);
                System.err.println("Entry ignored");
                continue;
            }
            object = this.props.getProperty(string2);
            if (object2[2].equals(S_HOST)) {
                hashMap.put(object2[1], object);
                continue;
            }
            if (((String)object2[2]).equals(S_PORT)) {
                hashMap2.put(object2[1], object);
                continue;
            }
            if (((String)object2[2]).equals(S_TLS)) {
                hashMap3.put(object2[1], object);
                continue;
            }
            System.err.println("Wrong key name for config Entry " + string2);
            System.err.println("Entry ignored");
        }
        int n = hashMap.size();
        if (n == 0) {
            throw new FatalException("(04410261715) no Server entries in config file found");
        }
        this.hosts = new String[n];
        this.ports = new int[n];
        this.ssls = new boolean[n];
        object2 = new TreeSet(hashMap.keySet());
        object = ((TreeSet)object2).iterator();
        int n2 = 0;
        int n3 = -1;
        while (object.hasNext()) {
            String string3 = (String)object.next();
            this.hosts[n2] = (String)hashMap.get(string3);
            String string4 = (String)hashMap2.get(string3);
            if (string4 == null) {
                System.err.println("Port missing for entry " + string3 + " (host : " + this.hosts[n2] + ")");
                System.err.println("Entry ignored");
                continue;
            }
            try {
                this.ports[n2] = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Port invalid (" + string4 + ") for entry " + string3 + " (host : " + this.hosts[n2] + ")");
                System.err.println("Entry ignored");
                continue;
            }
            string4 = (String)hashMap3.get(string3);
            this.ssls[n2] = string4 == null ? false : Boolean.parseBoolean(string4);
            n3 = n2++;
        }
        if (n3 < 0) {
            throw new FatalException("(03105131246) no valid Server entries in config file found");
        }
        this.numHosts = n3 + 1;
    }

    private final int getInt(String string, int n, int n2, int n3) throws FatalException {
        int n4 = n3;
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                n4 = Integer.parseInt(string2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new FatalException("(04410221556) Invalid " + string + " entry in config file: " + numberFormatException);
            }
        }
        if (n4 < n || n4 > n2) {
            throw new FatalException("(03105121147) Invalid " + string + " entry in config file; value should be between " + n + " and " + n2);
        }
        return n4;
    }

    private final boolean getBool(String string, boolean bl) throws FatalException {
        boolean bl2 = bl;
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            bl2 = Boolean.parseBoolean(string2.trim());
        }
        return bl2;
    }

    private final String getSSLProp(String string, String string2) {
        String string3 = this.props.getProperty(string);
        if (string3 != null) {
            string3 = System.getProperty(string2);
        }
        if (string3 != null) {
            System.setProperty(string2, string3);
            this.props.setProperty(string, string3);
        }
        return string3;
    }
}

