/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DoCheckPool;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.ResourceInfo;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSysResource;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.Vector;

public class PoolThread
extends InternalSession {
    public static final String __version = "@(#) $Id: PoolThread.java,v 2.13.2.1 2013/03/14 10:24:09 ronald Exp $";
    public static final String name = "PoolThread";

    public PoolThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) throws SDMSException {
        super(name);
        this.NR = 1234324;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, SystemEnvironment.ptWakeupInterval * 1000);
    }

    @Override
    protected Node getNode(int n) {
        if (n == 1) {
            return new DoCheckPool(1);
        }
        return new DoCheckPool();
    }

    public void checkPool(SystemEnvironment systemEnvironment) throws SDMSException {
        SystemEnvironment.sched.getPoolSchedule(systemEnvironment);
        long l = System.currentTimeMillis();
        PoolThread.doTrace(this.cEnv, "Start Pool Check", 2);
        Vector vector = SDMSPoolTable.idx_managerId.getVectorForUpdate(systemEnvironment, null);
        PoolThread.doTrace(this.cEnv, "Number of Pools to check: " + vector.size(), 2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPool sDMSPool = (SDMSPool)vector.get(i);
            this.checkSinglePool(systemEnvironment, sDMSPool, l, false);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, null, null, 2);
        PoolThread.doTrace(this.cEnv, "End Pool Check", 2);
    }

    public void checkSinglePool(SystemEnvironment systemEnvironment, SDMSPool sDMSPool, long l, boolean bl) throws SDMSException {
        int n;
        int n2;
        int n3;
        int n4;
        Comparable comparable;
        long l2 = sDMSPool.getNextEvaluationTime(systemEnvironment);
        int n5 = sDMSPool.getFreeAmount(systemEnvironment);
        if (bl) {
            comparable = SDMSPooledResourceTable.getObject(systemEnvironment, sDMSPool.getManagerId(systemEnvironment));
            n4 = ((SDMSPooledResourceProxyGeneric)comparable).getTargetAmount(systemEnvironment);
        } else {
            if (l2 > l) {
                return;
            }
            n4 = sDMSPool.getAmount(systemEnvironment);
        }
        comparable = sDMSPool.getEvaluationCycle(systemEnvironment);
        l2 = comparable == null ? l + (long)(SystemEnvironment.ptEvalCycle * 1000) : l + (long)((Integer)comparable * 1000);
        int n6 = n4;
        Vector vector = SDMSPooledResourceTable.idx_pId.getVectorForUpdate(systemEnvironment, sDMSPool.getId(systemEnvironment));
        ResourceInfo[] resourceInfoArray = new ResourceInfo[vector.size()];
        int n7 = 0;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(n3);
            if (!sDMSPooledResource.getActIsManaged(systemEnvironment).booleanValue()) continue;
            SDMSProxy sDMSProxy = sDMSPooledResource.getIsPool(systemEnvironment) == false ? SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment)) : SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
            resourceInfoArray[n7] = new ResourceInfo(systemEnvironment, (SDMSSysResource)((Object)sDMSProxy), sDMSPooledResource);
            n2 = resourceInfoArray[n7].nom_pct * n4 / 100;
            n = resourceInfoArray[n7].min_pct * n4 / 100;
            int n8 = resourceInfoArray[n7].free_pct * n4 / 100;
            int n9 = Math.max(0, resourceInfoArray[n7].amount - n2);
            n9 = Math.min(n9, resourceInfoArray[n7].freeAmount);
            n9 = Math.max(n9, resourceInfoArray[n7].freeAmount - n8);
            if ((n9 = Math.min(n9, resourceInfoArray[n7].amount - n)) > 0) {
                sDMSProxy.setAmount(systemEnvironment, resourceInfoArray[n7].amount - n9);
                resourceInfoArray[n7].amount -= n9;
                resourceInfoArray[n7].freeAmount -= n9;
                n5 += n9;
            }
            resourceInfoArray[n7].targetAmount = Math.min(resourceInfoArray[n7].amount - resourceInfoArray[n7].freeAmount + n8, n2);
            resourceInfoArray[n7].targetAmount = Math.max(resourceInfoArray[n7].targetAmount, n);
            resourceInfoArray[n7].targetFreeAmount = resourceInfoArray[n7].freeAmount + (resourceInfoArray[n7].targetAmount - resourceInfoArray[n7].amount);
            n6 -= resourceInfoArray[n7].targetAmount;
            ++n7;
        }
        sDMSPool.setFreeAmount(systemEnvironment, n5);
        if (bl) {
            n5 += n4 - sDMSPool.getAmount(systemEnvironment);
        }
        n3 = 1;
        block1: while (n3 == 1 && n6 > 0) {
            n3 = 0;
            for (int i = 0; i < n7; ++i) {
                int n10 = 0;
                n2 = resourceInfoArray[i].targetFreeAmount;
                if (n2 == resourceInfoArray[i].amountReceived) {
                    n10 = n2 + 1;
                }
                if ((n = this.determineAmount(n4, n6, resourceInfoArray[i].targetAmount, n10 = Math.max(n10, resourceInfoArray[i].free_pct * n4 / 100), resourceInfoArray[i].nom_pct * n4 / 100, n2)) == 0) continue;
                resourceInfoArray[i].targetAmount += n;
                resourceInfoArray[i].amountReceived += n;
                resourceInfoArray[i].targetFreeAmount += n;
                if ((n6 -= n) == 0) continue block1;
                n3 = 1;
            }
        }
        n3 = 1;
        block3: while (n3 == 1 && n6 > 0) {
            n3 = 0;
            for (int i = 0; i < n7; ++i) {
                int n11 = 0;
                n2 = resourceInfoArray[i].targetFreeAmount;
                if (n2 == resourceInfoArray[i].amountReceived) {
                    n11 = n2 + 1;
                }
                if ((n = this.determineAmount(n4, n6, resourceInfoArray[i].targetAmount, n11 = Math.max(n11, resourceInfoArray[i].free_pct * n4 / 100), resourceInfoArray[i].max_pct * n4 / 100, n2)) == 0) continue;
                resourceInfoArray[i].targetAmount += n;
                resourceInfoArray[i].amountReceived += n;
                resourceInfoArray[i].targetFreeAmount += n;
                if ((n6 -= n) == 0) continue block3;
                n3 = 1;
            }
        }
        for (int i = 0; i < n7; ++i) {
            resourceInfoArray[i].pr.setTargetAmount(systemEnvironment, resourceInfoArray[i].targetAmount);
            if (!resourceInfoArray[i].pr.getIsPool(systemEnvironment).booleanValue()) continue;
            SDMSPool sDMSPool2 = SDMSPoolTable.getObject(systemEnvironment, resourceInfoArray[i].pr.getRId(systemEnvironment));
            this.checkSinglePool(systemEnvironment, sDMSPool2, l, true);
        }
        sDMSPool.setNextEvaluationTime(systemEnvironment, l2);
    }

    int determineAmount(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        if (n3 < n5 && n6 < n4) {
            n7 = n4 / 3;
            if (n7 == 0) {
                n7 = 1;
            }
            if (n7 > n2) {
                n7 = n2;
            }
            if (n7 + n3 > n5) {
                n7 = n5 - n3;
            }
        }
        return n7;
    }
}

