/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLListenThread
extends ListenThread {
    public static final String __version = "@(#) $Id: SSLListenThread.java,v 2.2.6.1 2013/03/14 10:24:09 ronald Exp $";
    private String[] prots = null;
    private KeyStore ks;
    private KeyManagerFactory kmf;
    private char[] ksPass;
    private SSLContext sc;
    private SSLServerSocketFactory ssf;

    public SSLListenThread(ThreadGroup threadGroup, int n, InetAddress inetAddress, int n2, SyncFifo syncFifo, SyncFifo syncFifo2, int n3) throws SDMSException {
        super(threadGroup, n, inetAddress, n2, syncFifo, syncFifo2, n3);
        try {
            this.ks = KeyStore.getInstance("JKS");
            this.ksPass = SystemEnvironment.keystorepassword.toCharArray();
            this.ks.load(new FileInputStream(SystemEnvironment.keystore), this.ksPass);
            this.kmf = KeyManagerFactory.getInstance("SunX509");
            this.kmf.init(this.ks, this.ksPass);
            this.sc = SSLContext.getInstance("SSL");
            this.sc.init(this.kmf.getKeyManagers(), null, null);
            this.ssf = this.sc.getServerSocketFactory();
        }
        catch (Exception exception) {
            throw new FatalException("Unable to initialize SSL/TLS Listener : " + exception.toString());
        }
    }

    @Override
    ServerSocket getServerSocket(int n, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = inetAddress == null ? (SSLServerSocket)this.ssf.createServerSocket(n) : (SSLServerSocket)this.ssf.createServerSocket(n, 0, inetAddress);
        if (SystemEnvironment.clientAuthentication) {
            System.out.println("Client Authentication is needed");
            sSLServerSocket.setNeedClientAuth(true);
        } else {
            System.out.println("Client Authentication is optional");
            sSLServerSocket.setWantClientAuth(true);
        }
        this.prots = sSLServerSocket.getSupportedProtocols();
        return sSLServerSocket;
    }

    @Override
    protected Socket accept() throws InterruptedIOException, IOException {
        SSLSocket sSLSocket = (SSLSocket)this.serv.accept();
        return sSLSocket;
    }

    public String[] getProtocols() {
        return this.prots;
    }
}

