/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.FolderComparator;
import de.independit.scheduler.server.parser.NPEntry;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import java.util.Collections;
import java.util.Vector;

public class AlterNiceProfile
extends Node {
    private ObjectURL url;
    private WithHash with;
    private boolean noerr;

    public AlterNiceProfile(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNiceProfile sDMSNiceProfile = (SDMSNiceProfile)this.url.resolve(systemEnvironment);
        Long l = sDMSNiceProfile.getId(systemEnvironment);
        systemEnvironment.checkFeatureAvailability("NICE_PROFILE");
        Boolean bl = sDMSNiceProfile.getIsActive(systemEnvironment);
        Boolean bl2 = (Boolean)this.with.get("ACTIVE");
        if (bl2 != null && bl.booleanValue() && !bl2.booleanValue()) {
            sDMSNiceProfile.setIsActive(systemEnvironment, bl2);
        }
        Long l2 = null;
        if (bl.booleanValue() && (bl2 == null || bl2.booleanValue())) {
            l2 = sDMSNiceProfile.getActiveTs(systemEnvironment);
            sDMSNiceProfile.setIsActive(systemEnvironment, Boolean.FALSE);
        }
        this.diffEntries(systemEnvironment, l);
        if (l2 != null || bl2 != null && !bl.booleanValue() && bl2.booleanValue()) {
            sDMSNiceProfile.setIsActive(systemEnvironment, bl2, l2);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03408110751", "Nice Profile altered"));
    }

    private void diffEntries(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        int n;
        Vector vector = (Vector)this.with.get("PROFILE");
        if (vector == null) {
            if (this.with.containsKey("PROFILE")) {
                vector = new Vector();
            } else {
                return;
            }
        }
        Vector vector2 = SDMSNiceProfileEntryTable.idx_npId.getVector(systemEnvironment, l);
        FolderComparator folderComparator = new FolderComparator(systemEnvironment);
        Vector<NPEntry> vector3 = new Vector<NPEntry>();
        for (int i = 0; i < vector2.size(); ++i) {
            vector3.add(new NPEntry(systemEnvironment, (SDMSNiceProfileEntry)vector2.get(i)));
        }
        Collections.sort(vector3, folderComparator);
        Vector<NPEntry> vector4 = new Vector<NPEntry>();
        for (n = 0; n < vector.size(); ++n) {
            vector4.add(new NPEntry(systemEnvironment, (WithHash)vector.get(n), n));
        }
        Collections.sort(vector4, folderComparator);
        n = 0;
        int n2 = vector3.size();
        int n3 = 0;
        int n4 = vector4.size();
        NPEntry nPEntry = null;
        NPEntry nPEntry2 = null;
        System.out.println("npev_size = " + n2 + ", entries_size = " + n4);
        while (n < n2 || n3 < n4) {
            System.out.println("Processing idx_npe = " + n + ", idx_entries = " + n3);
            nPEntry = n < n2 ? (NPEntry)vector3.get(n) : null;
            nPEntry2 = n3 < n4 ? (NPEntry)vector4.get(n3) : null;
            if (nPEntry == null || nPEntry2 != null && nPEntry.lFolderId > nPEntry2.lFolderId) {
                while (n3 < n4 && (nPEntry == null || nPEntry.lFolderId > nPEntry2.lFolderId)) {
                    SDMSNiceProfileEntryTable.table.create(systemEnvironment, l, nPEntry2.oPreference, nPEntry2.folderId, nPEntry2.oSuspend, nPEntry2.oNicevalue, nPEntry2.oActive);
                    nPEntry2 = ++n3 < n4 ? (NPEntry)vector4.get(n3) : null;
                    System.out.println("Processing idx_npe = " + n + ", idx_entries = " + n3);
                }
                continue;
            }
            if (nPEntry2 == null || nPEntry != null && nPEntry.lFolderId < nPEntry2.lFolderId) {
                while (n < n2 && (nPEntry2 == null || nPEntry.lFolderId < nPEntry2.lFolderId)) {
                    nPEntry.npe.delete(systemEnvironment);
                    nPEntry = ++n < n2 ? (NPEntry)vector3.get(n) : null;
                    System.out.println("Processing idx_npe = " + n + ", idx_entries = " + n3);
                }
                continue;
            }
            nPEntry.npe.setPreference(systemEnvironment, nPEntry2.oPreference);
            nPEntry.npe.setFolderId(systemEnvironment, nPEntry2.folderId);
            nPEntry.npe.setIsSuspended(systemEnvironment, nPEntry2.oSuspend);
            nPEntry.npe.setRenice(systemEnvironment, nPEntry2.oNicevalue);
            nPEntry.npe.setIsActive(systemEnvironment, nPEntry2.oActive);
            ++n;
            ++n3;
        }
    }
}

