/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.ManipResource;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.util.DateTime;

public class AlterResource
extends ManipResource {
    public static final String __version = "@(#) $Id: AlterResource.java,v 2.21.4.4 2013/03/22 14:48:02 ronald Exp $";
    private WithHash with;
    private SDMSProxy pp;

    public AlterResource(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        super(objectURL, bl);
        this.with = withHash;
    }

    public AlterResource(SDMSProxy sDMSProxy, WithHash withHash, Boolean bl) {
        this.with = withHash;
        this.pp = sDMSProxy;
    }

    private void collectWith(SystemEnvironment systemEnvironment) throws SDMSException {
        this.status = (String)this.with.get("STATUS");
        this.requestableAmount = (Integer)this.with.get("REQUESTABLE_AMOUNT");
        this.amount = (Integer)this.with.get("AMOUNT");
        this.online = (Boolean)this.with.get("ONLINE");
        this.groupname = (String)this.with.get("GROUP");
        this.parms = (WithHash)this.with.get("PARAMETERS");
        this.factor = (Float)this.with.get("FACTOR");
        this.tag = (String)this.with.get("TAG");
        this.traceInterval = (Integer)this.with.get("TRACE");
        this.traceBase = (Integer)this.with.get("BASE");
        this.baseMultiplier = (Integer)this.with.get("MULTIPLIER");
        if (this.traceInterval != null || this.traceBase != null) {
            systemEnvironment.checkFeatureAvailability("RESOURCE_TRACING");
        }
    }

    private void alterResource(SystemEnvironment systemEnvironment, SDMSResource sDMSResource) throws SDMSException {
        Long l;
        Object object;
        int n = 2;
        if (this.online != null && sDMSResource.getIsOnline(systemEnvironment).booleanValue() != this.online.booleanValue()) {
            sDMSResource.setIsOnline(systemEnvironment, this.online);
            n = 16;
        }
        if (this.status != null) {
            object = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.status);
            l = ((SDMSProxy)object).getId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource.getNrId(systemEnvironment));
            Long l2 = sDMSNamedResource.getRspId(systemEnvironment);
            if (l2 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03604041545", "Resource does not have a profile"));
            }
            if (!SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l2))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03604041633", "Resource state is not contained within the resource state profile"));
            }
            sDMSResource.setRsdId(systemEnvironment, l);
        }
        if (this.requestableAmount != null) {
            if (this.requestableAmount == -1) {
                this.requestableAmount = null;
            }
            if ((object = sDMSResource.getRequestableAmount(systemEnvironment)) == null && this.requestableAmount != null || object != null && this.requestableAmount == null || object != null && this.requestableAmount != null && ((Integer)object).intValue() != this.requestableAmount.intValue()) {
                sDMSResource.setRequestableAmount(systemEnvironment, this.requestableAmount);
                n = 15;
            }
        }
        if (this.amount != null) {
            if (this.amount == -1) {
                this.amount = null;
            }
            if ((object = sDMSResource.getDefinedAmount(systemEnvironment)) != null && this.amount != null && (Integer)object > this.amount) {
                n = 15;
            }
            sDMSResource.setDefinedAmount(systemEnvironment, this.amount);
            if (sDMSResource.getManagerId(systemEnvironment) == null) {
                sDMSResource.setAmount(systemEnvironment, this.amount);
            }
        }
        if (this.with.containsKey("TOUCH")) {
            object = (DateTime)this.with.get("TOUCH");
            if (object != null) {
                if (((DateTime)object).year == -1) {
                    ((DateTime)object).setMissingFieldsFromNow();
                } else {
                    ((DateTime)object).fixToMinDate();
                }
                l = ((DateTime)object).toDate().getTime();
            } else {
                l = System.currentTimeMillis();
            }
            sDMSResource.setRsdTime(systemEnvironment, l);
        }
        if (this.groupname != null) {
            object = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.groupname), SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, (Long)object, sDMSResource.getOwnerId(systemEnvironment));
            sDMSResource.setOwnerId(systemEnvironment, (Long)object);
        }
        if (this.with.containsKey("PARAMETERS")) {
            sDMSResource.alterVariables(systemEnvironment, this.parms, Long.MAX_VALUE);
        }
        if (this.with.containsKey("FACTOR")) {
            sDMSResource.setFactor(systemEnvironment, this.factor);
        }
        if (this.with.containsKey("TAG")) {
            sDMSResource.setTag(systemEnvironment, this.tag);
        }
        if (this.with.containsKey("TRACE")) {
            sDMSResource.setTraceInterval(systemEnvironment, this.traceInterval);
        }
        if (this.with.containsKey("BASE")) {
            sDMSResource.setTraceBase(systemEnvironment, this.traceBase);
        }
        if (this.with.containsKey("MULTIPLIER")) {
            sDMSResource.setTraceBaseMultiplier(systemEnvironment, this.baseMultiplier);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSResource, this.sId, n);
    }

    private void alterResourceTemplate(SystemEnvironment systemEnvironment, SDMSResourceTemplate sDMSResourceTemplate) throws SDMSException {
        Comparable comparable;
        if (this.online != null) {
            sDMSResourceTemplate.setIsOnline(systemEnvironment, this.online);
        }
        if (this.status != null) {
            comparable = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.status);
            Long l = comparable.getId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceTemplate.getNrId(systemEnvironment));
            Long l2 = sDMSNamedResource.getRspId(systemEnvironment);
            if (l2 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03604041546", "Resource does not have a profile"));
            }
            SDMSResourceStateProfile sDMSResourceStateProfile = SDMSResourceStateProfileTable.getObject(systemEnvironment, l2);
            if (!l.equals(sDMSResourceStateProfile.getInitialRsdId(systemEnvironment)) && !SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l2))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03604041634", "Resource state is not contained within the resource state profile"));
            }
            sDMSResourceTemplate.setRsdId(systemEnvironment, l);
        }
        if (this.requestableAmount != null) {
            if (this.requestableAmount == -1) {
                this.requestableAmount = null;
            }
            sDMSResourceTemplate.setRequestableAmount(systemEnvironment, this.requestableAmount);
        }
        if (this.amount != null) {
            if (this.amount == -1) {
                this.amount = null;
            }
            sDMSResourceTemplate.setAmount(systemEnvironment, this.amount);
        }
        if (this.groupname != null) {
            comparable = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.groupname), SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, (Long)comparable, sDMSResourceTemplate.getOwnerId(systemEnvironment));
            sDMSResourceTemplate.setOwnerId(systemEnvironment, (Long)comparable);
        }
        if (this.with.containsKey("PARAMETERS")) {
            sDMSResourceTemplate.alterVariables(systemEnvironment, this.parms, Long.MAX_VALUE);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        this.collectWith(systemEnvironment);
        if (this.resource != null) {
            this.pp = this.resource.resolve(systemEnvironment);
        }
        if (this.pp instanceof SDMSResource) {
            SDMSResource sDMSResource = (SDMSResource)this.pp;
            Long l = sDMSResource.getLinkId(systemEnvironment);
            while (l != null) {
                sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
                l = sDMSResource.getLinkId(systemEnvironment);
            }
            this.alterResource(systemEnvironment, sDMSResource);
        } else {
            SDMSResourceTemplate sDMSResourceTemplate = (SDMSResourceTemplate)this.pp;
            this.alterResourceTemplate(systemEnvironment, sDMSResourceTemplate);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202220027", "Resource altered"));
    }
}

