/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.ManipUser;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.ScopeParameter;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.util.CheckSum;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Vector;

public class AlterScope
extends Node {
    public static final String __version = "@(#) $Id: AlterScope.java,v 2.7.2.1 2013/03/14 10:24:23 ronald Exp $";
    private final WithHash with;
    private final boolean noerr;
    private final ObjectURL url;
    private boolean dynamic = false;
    private boolean fatal;
    private String errmsg;

    public AlterScope(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.with = withHash == null ? new WithHash() : withHash;
        this.errmsg = null;
        this.noerr = bl;
    }

    public AlterScope(boolean bl, String string, Boolean bl2) {
        this.cmdtype = 2;
        this.url = null;
        this.with = new WithHash();
        this.fatal = bl;
        this.errmsg = string;
        this.noerr = bl2;
    }

    public AlterScope(WithHash withHash, Boolean bl) {
        this.cmdtype = 2;
        this.url = null;
        this.with = withHash;
        this.errmsg = null;
        this.dynamic = true;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.url == null) {
            this.jobServerAlter(systemEnvironment);
        } else {
            this.userAlter(systemEnvironment);
        }
    }

    public void userAlter(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope;
        try {
            sDMSScope = (SDMSScope)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311121736", "No scope altered"));
                return;
            }
            throw notFoundException;
        }
        if (this.url.parserType == 566) {
            this.userAlterScope(systemEnvironment, sDMSScope);
        } else {
            this.userAlterJobServer(systemEnvironment, sDMSScope);
        }
    }

    public void userAlterScope(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Object object;
        Long l = sDMSScope.getId(systemEnvironment);
        if (this.with.containsKey("CONFIG")) {
            ScopeConfig.alter(systemEnvironment, sDMSScope, (WithHash)this.with.get("CONFIG"));
        }
        if (this.with.containsKey("PARAMETERS")) {
            ScopeParameter.alter(systemEnvironment, l, (WithHash)this.with.get("PARAMETERS"));
        }
        if (this.with.containsKey("GROUP") || this.with.containsKey("GROUP_CASCADE")) {
            if (this.with.containsKey("GROUP") && this.with.containsKey("GROUP_CASCADE")) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402041341", "It is forbidden to specify the group clause twice"));
            }
            object = this.with.containsKey("GROUP") ? (String)this.with.get("GROUP") : (String)this.with.get("GROUP_CASCADE");
            Long l2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, l2, sDMSScope.getOwnerId(systemEnvironment));
            sDMSScope.setOwnerId(systemEnvironment, l2);
            if (this.with.containsKey("GROUP_CASCADE")) {
                this.changeChildGroup(systemEnvironment, l, l2);
            }
        }
        if (this.with.containsKey("INHERIT")) {
            object = (Long)this.with.get("INHERIT");
            if (object == null) {
                object = SDMSConstants.lZERO;
            }
            long l3 = (Long)object;
            if ((sDMSScope.getPrivilegeMask() & l3) != l3) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061325", "Incompatible grant"));
            }
            sDMSScope.setInheritPrivs(systemEnvironment, (Long)object);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04305181612", "Scope altered"));
    }

    private void userAlterJobServer(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        Object object;
        Long l = sDMSScope.getId(systemEnvironment);
        String string = null;
        Integer n = SDMSConstants.S_SHA256;
        sDMSScope.notify(systemEnvironment);
        if (this.with.containsKey("NODE")) {
            sDMSScope.setNode(systemEnvironment, (String)this.with.get("NODE"));
        }
        String string2 = null;
        if (this.with.containsKey("PASSWORD")) {
            string = ManipUser.generateSalt();
            string2 = n == 0 ? CheckSum.mkstr(CheckSum.md5(((String)this.with.get("PASSWORD") + string).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256(((String)this.with.get("PASSWORD") + string).getBytes()), false);
        }
        if (this.with.containsKey("RAWPASSWORD")) {
            if (string2 == null) {
                object = (Vector)this.with.get("RAWPASSWORD");
                string2 = (String)((Vector)object).get(0);
                string = (String)((Vector)object).get(1);
                if (string2.length() == 35) {
                    n = SDMSConstants.S_MD5;
                }
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04312151811", "Both PASSWORD and RAWPASSWORD are not allowed"));
            }
        }
        if (string2 != null) {
            sDMSScope.setPasswd(systemEnvironment, string2);
            sDMSScope.setSalt(systemEnvironment, string);
            sDMSScope.setMethod(systemEnvironment, n);
        }
        if (this.with.containsKey("ERROR_TEXT")) {
            sDMSScope.setErrmsg(systemEnvironment, (String)this.with.get("ERROR_TEXT"));
        }
        if (this.with.containsKey("ENABLE") && !((Boolean)(object = (Boolean)this.with.get("ENABLE"))).equals(sDMSScope.getIsEnabled(systemEnvironment))) {
            if (((Boolean)object).booleanValue()) {
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSScope, 19);
            } else {
                SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSScope, 20);
                if (!sDMSScope.hasActiveJobs(systemEnvironment) && sDMSScope.isConnected(systemEnvironment)) {
                    SDMSThread.doTrace(systemEnvironment.cEnv, "Trying to kill connection " + sDMSScope.getConnectionId(systemEnvironment) + " of Jobserver " + sDMSScope.pathString(systemEnvironment), 2);
                    SystemEnvironment.server.killUser(sDMSScope.getConnectionId(systemEnvironment));
                    sDMSScope.setIsRegistered(systemEnvironment, Boolean.FALSE);
                }
            }
            sDMSScope.setIsEnabled(systemEnvironment, (Boolean)object);
        }
        if (this.with.containsKey("CONFIG")) {
            ScopeConfig.alter(systemEnvironment, sDMSScope, (WithHash)this.with.get("CONFIG"));
        }
        if (this.with.containsKey("PARAMETERS")) {
            ScopeParameter.alter(systemEnvironment, l, (WithHash)this.with.get("PARAMETERS"));
        }
        if (this.with.containsKey("GROUP")) {
            object = (String)this.with.get("GROUP");
            Long l2 = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)object, SDMSConstants.lZERO)).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, l2, sDMSScope.getOwnerId(systemEnvironment));
            sDMSScope.setOwnerId(systemEnvironment, l2);
        }
        if (this.with.containsKey("INHERIT")) {
            object = (Long)this.with.get("INHERIT");
            if (object == null) {
                object = SDMSConstants.lZERO;
            }
            long l3 = (Long)object;
            if ((sDMSScope.getPrivilegeMask() & l3) != l3) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061325", "Incompatible grant"));
            }
            sDMSScope.setInheritPrivs(systemEnvironment, (Long)object);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201301103", "Job Server altered"));
    }

    private void changeChildGroup(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSScope sDMSScope = (SDMSScope)vector.get(i);
            try {
                sDMSScope.setOwnerId(systemEnvironment, l2);
            }
            catch (AccessViolationException accessViolationException) {
                // empty catch block
            }
            this.changeChildGroup(systemEnvironment, sDMSScope.getId(systemEnvironment), l2);
        }
    }

    private void jobServerAlter(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, systemEnvironment.cEnv.uid());
        if (this.dynamic) {
            ScopeParameter.setDynamicValues(systemEnvironment, sDMSScope, this.with);
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "04307152322", "Job Server altered"));
            return;
        }
        if (this.fatal) {
            sDMSScope.setState(systemEnvironment, SDMSConstants.S_FATAL);
        } else {
            sDMSScope.setState(systemEnvironment, SDMSConstants.S_NONFATAL);
        }
        SDMSThread.doTrace(this.env, this.errmsg, -1);
        sDMSScope.setErrmsg(systemEnvironment, this.errmsg);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202052011", "Job Server altered"));
    }
}

