/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterNiceProfile;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.Iterator;
import java.util.Vector;

public class CreateNiceProfile
extends Node {
    private static final Integer ZERO = SDMSConstants.iZERO;
    private String name;
    private WithHash items;
    private boolean replace;

    public CreateNiceProfile(String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.items = withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNiceProfile sDMSNiceProfile;
        systemEnvironment.checkFeatureAvailability("NICE_PROFILE");
        Boolean bl = (Boolean)this.items.get("ACTIVE");
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        try {
            sDMSNiceProfile = SDMSNiceProfileTable.table.create(systemEnvironment, this.name, Boolean.FALSE, null);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterNiceProfile alterNiceProfile = new AlterNiceProfile(new ObjectURL(SDMSConstants.PS_NICE_PROFILE, this.name), this.items, Boolean.FALSE);
                alterNiceProfile.setEnv(this.env);
                alterNiceProfile.go(systemEnvironment);
                this.result = alterNiceProfile.result;
                return;
            }
            throw duplicateKeyException;
        }
        Vector vector = (Vector)this.items.get("PROFILE");
        if (vector != null) {
            Long l = sDMSNiceProfile.getId(systemEnvironment);
            int n = 0;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Long l2;
                ++n;
                WithHash withHash = (WithHash)iterator.next();
                ObjectURL objectURL = (ObjectURL)withHash.get("FOLDER");
                Integer n2 = (Integer)withHash.get("RENICE");
                Integer n3 = (Integer)withHash.get("SUSPEND");
                Boolean bl2 = (Boolean)withHash.get("ACTIVE");
                if (objectURL == null) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408141331", "A folder must be specified"));
                }
                if (n2 == null) {
                    n2 = ZERO;
                }
                if (n3 == null) {
                    n3 = SDMSConstants.SME_NOSUSPEND;
                }
                if (bl2 == null) {
                    bl2 = Boolean.TRUE;
                }
                if (objectURL != null) {
                    SDMSProxy sDMSProxy = objectURL.resolve(systemEnvironment);
                    l2 = sDMSProxy.getId(systemEnvironment);
                } else {
                    l2 = null;
                }
                SDMSNiceProfileEntryTable.table.create(systemEnvironment, l, n, l2, n3, n2, bl2);
            }
        }
        if (bl.booleanValue()) {
            sDMSNiceProfile.setIsActive(systemEnvironment, bl);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03408110743", "Nice Profile created"));
    }
}

