/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterRsp;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import java.util.Vector;

public class CreateRsp
extends Node {
    public static final String __version = "@(#) $Id: CreateRsp.java,v 2.1.4.1 2013/03/14 10:24:27 ronald Exp $";
    private String name;
    private WithHash with;
    private boolean replace;

    public CreateRsp(String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.with = withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateProfile sDMSResourceStateProfile;
        try {
            sDMSResourceStateProfile = SDMSResourceStateProfileTable.table.create(systemEnvironment, this.name, null);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterRsp alterRsp = new AlterRsp(this.name, this.with, Boolean.FALSE);
                alterRsp.setEnv(this.env);
                alterRsp.go(systemEnvironment);
                this.result = alterRsp.result;
                return;
            }
            throw duplicateKeyException;
        }
        Long l = sDMSResourceStateProfile.getId(systemEnvironment);
        Vector vector = (Vector)this.with.get("STATUS");
        if (vector == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201102145", "States missing"));
        }
        for (String string : vector) {
            Long l2 = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
            try {
                SDMSResourceStateTable.table.create(systemEnvironment, l2, l);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110120918", "State $1 specified more than once", string));
            }
        }
        Long l3 = null;
        String string = (String)this.with.get("INITIAL_STATUS");
        if (string != null) {
            l3 = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
            sDMSResourceStateProfile.setInitialRsdId(systemEnvironment, l3);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201222249", "Resource State Profile created"));
    }
}

