/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterWt;
import de.independit.scheduler.server.parser.ManipWt;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import java.util.Vector;

public class CreateWt
extends ManipWt {
    public static final String __version = "@(#) $Id: CreateWt.java,v 2.1.4.3 2013/03/20 06:42:58 ronald Exp $";
    private String name;
    private WithHash with;
    private boolean replace;

    public CreateWt(String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.with = withHash;
        this.replace = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSWatchType sDMSWatchType;
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        try {
            sDMSWatchType = SDMSWatchTypeTable.table.create(systemEnvironment, this.name);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                AlterWt alterWt = new AlterWt(new ObjectURL(SDMSConstants.PS_WATCH, this.name), this.with, Boolean.FALSE);
                alterWt.setEnv(this.env);
                alterWt.go(systemEnvironment);
                this.result = alterWt.result;
                return;
            }
            throw duplicateKeyException;
        }
        Long l = sDMSWatchType.getId(systemEnvironment);
        Vector vector = (Vector)this.with.get("PARAMETERS");
        if (vector == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02108240902", "Parameters missing"));
        }
        for (Vector vector2 : vector) {
            String string = (String)vector2.get(0);
            Integer n = this.getTypeInteger(string);
            String string2 = (String)vector2.get(1);
            String string3 = (String)vector2.get(2);
            if (string3 != null) {
                string3 = "=" + string3;
            }
            Boolean bl = (Boolean)vector2.get(3);
            SDMSWatchTypeParameterTable.table.create(systemEnvironment, string2, string3, l, bl, n);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108240922", "Watch Type created"));
    }
}

