/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;

public class DropDistribution
extends Node {
    public static final String __version = "@(#) $Id: DropDistribution.java,v 2.1.14.3 2013/03/20 06:42:58 ronald Exp $";
    private final ObjectURL url;
    private final boolean tolerant;

    public DropDistribution(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.tolerant = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, "03603201409", "Distribution dropped");
        try {
            SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)this.url.resolve(systemEnvironment);
            sDMSPoolDistribution.delete(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.tolerant) {
                sDMSMessage.setMessage("No Distribution dropped");
            }
            throw notFoundException;
        }
        this.result.setFeedback(sDMSMessage);
    }
}

