/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropFootprint
extends Node {
    public static final String __version = "@(#) $Id: DropFootprint.java,v 2.2.14.1 2013/03/14 10:24:29 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropFootprint(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFootprint sDMSFootprint;
        try {
            sDMSFootprint = (SDMSFootprint)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130013", "No Footprint dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSFootprint.getId(systemEnvironment);
        Vector vector = SDMSSchedulingEntityTable.idx_fpId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)vector.get(0);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205190930", "Footprint in use by Scheduling Entity $1", sDMSSchedulingEntity.pathString(systemEnvironment)));
        }
        vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
            sDMSResourceRequirement.delete(systemEnvironment);
        }
        sDMSFootprint.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02205190934", "Footprint dropped"));
    }
}

