/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.dumpClasses.DumpCMT;
import de.independit.scheduler.server.parser.dumpClasses.DumpD;
import de.independit.scheduler.server.parser.dumpClasses.DumpESD;
import de.independit.scheduler.server.parser.dumpClasses.DumpESM;
import de.independit.scheduler.server.parser.dumpClasses.DumpESP;
import de.independit.scheduler.server.parser.dumpClasses.DumpEST;
import de.independit.scheduler.server.parser.dumpClasses.DumpEV;
import de.independit.scheduler.server.parser.dumpClasses.DumpF;
import de.independit.scheduler.server.parser.dumpClasses.DumpFP;
import de.independit.scheduler.server.parser.dumpClasses.DumpGR;
import de.independit.scheduler.server.parser.dumpClasses.DumpGroup;
import de.independit.scheduler.server.parser.dumpClasses.DumpIV;
import de.independit.scheduler.server.parser.dumpClasses.DumpNE;
import de.independit.scheduler.server.parser.dumpClasses.DumpNP;
import de.independit.scheduler.server.parser.dumpClasses.DumpNR;
import de.independit.scheduler.server.parser.dumpClasses.DumpOM;
import de.independit.scheduler.server.parser.dumpClasses.DumpPL;
import de.independit.scheduler.server.parser.dumpClasses.DumpR;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSD;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSM;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSP;
import de.independit.scheduler.server.parser.dumpClasses.DumpRT;
import de.independit.scheduler.server.parser.dumpClasses.DumpSC;
import de.independit.scheduler.server.parser.dumpClasses.DumpSE;
import de.independit.scheduler.server.parser.dumpClasses.DumpSEV;
import de.independit.scheduler.server.parser.dumpClasses.DumpScope;
import de.independit.scheduler.server.parser.dumpClasses.DumpTR;
import de.independit.scheduler.server.parser.dumpClasses.DumpUser;
import de.independit.scheduler.server.parser.dumpClasses.DumpWT;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceTemplate;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashMap;
import java.util.Vector;

public class DumpObject
implements Comparable {
    static final double PHI = (1.0 + Math.sqrt(5.0)) / 2.0;
    public static final int MODE_DEPLOY = 1;
    public static final int MODE_BACKUP = 2;
    public static final int EXIT_STATE_DEFINITION = 1;
    public static final int EXIT_STATE_MAPPING = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_TRANSLATION = 4;
    public static final int GROUP = 5;
    public static final int USER = 6;
    public static final int RESOURCE_STATE_DEFINITION = 7;
    public static final int RESOURCE_STATE_PROFILE = 8;
    public static final int RESOURCE_STATE_MAPPING = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int ENVIRONMENT = 11;
    public static final int FOOTPRINT = 12;
    public static final int FOLDER = 13;
    public static final int JOB_DEFINITION = 14;
    public static final int SCOPE = 15;
    public static final int RESOURCE = 16;
    public static final int RESOURCE_TEMPLATE = 17;
    public static final int POOL = 18;
    public static final int DISTRIBUTION = 19;
    public static final int INTERVAL = 20;
    public static final int SCHEDULE = 21;
    public static final int EVENT = 22;
    public static final int SCHEDULED_EVENT = 23;
    public static final int WATCH_TYPE = 24;
    public static final int OBJECT_MONITOR = 25;
    public static final int TRIGGER = 26;
    public static final int COMMENT = 40;
    public static final int GRANT = 50;
    public static final int NICE_PROFILE = 60;
    static final HashMap sortTypeFromURL = new HashMap();
    static final HashMap parseTypeFromST;
    public final Long id;
    public String alias;
    public SDMSProxy object;
    public int sortType;
    public int parserType;

    public DumpObject(Long l, int n) {
        this.id = l;
        this.initDumpObject((String)null, (SDMSProxy)null, n);
    }

    public DumpObject(Long l, String string, int n) {
        this.id = l;
        this.initDumpObject(string, (SDMSProxy)null, n);
    }

    public DumpObject(Long l, String string, SDMSProxy sDMSProxy, int n) {
        this.id = l;
        this.initDumpObject(string, sDMSProxy, n);
    }

    public DumpObject(Long l, String string, SDMSProxy sDMSProxy, Integer n) {
        this.id = l;
        this.initDumpObject(string, sDMSProxy, n);
    }

    protected void initDumpObject(String string, SDMSProxy sDMSProxy, int n) {
        this.initDumpObject(string, sDMSProxy, (Integer)n);
    }

    protected void initDumpObject(String string, SDMSProxy sDMSProxy, Integer n) {
        this.alias = string;
        this.object = sDMSProxy;
        Integer n2 = (Integer)sortTypeFromURL.get(n);
        this.sortType = n2;
        this.parserType = (Integer)parseTypeFromST.get(n2);
    }

    public String sortTypeAsString() {
        switch (this.sortType) {
            case 1: {
                return "EXIT_STATE_DEFINITION";
            }
            case 2: {
                return "EXIT_STATE_MAPPING";
            }
            case 3: {
                return "EXIT_STATE_PROFILE";
            }
            case 4: {
                return "EXIT_STATE_TRANSLATION";
            }
            case 5: {
                return "GROUP";
            }
            case 6: {
                return "USER";
            }
            case 7: {
                return "RESOURCE_STATE_DEFINITION";
            }
            case 8: {
                return "RESOURCE_STATE_PROFILE";
            }
            case 9: {
                return "RESOURCE_STATE_MAPPING";
            }
            case 10: {
                return "NAMED_RESOURCE";
            }
            case 60: {
                return "NICE_PROFILE";
            }
            case 11: {
                return "ENVIRONMENT";
            }
            case 12: {
                return "FOOTPRINT";
            }
            case 13: {
                return "FOLDER";
            }
            case 14: {
                return "JOB_DEFINITION";
            }
            case 15: {
                return "SCOPE";
            }
            case 16: {
                return "RESOURCE";
            }
            case 17: {
                return "RESOURCE_TEMPLATE";
            }
            case 25: {
                return "OBJECT_MONITOR";
            }
            case 18: {
                return "POOL";
            }
            case 19: {
                return "DISTRIBUTION";
            }
            case 20: {
                return "INTERVAL";
            }
            case 21: {
                return "SCHEDULE";
            }
            case 22: {
                return "EVENT";
            }
            case 23: {
                return "SCHEDULED_EVENT";
            }
            case 26: {
                return "TRIGGER";
            }
            case 24: {
                return "WATCH_TYPE";
            }
            case 40: {
                return "COMMENT";
            }
            case 50: {
                return "GRANT";
            }
        }
        return null;
    }

    public String toString() {
        return "ID: " + this.id + ", Type : " + this.sortTypeAsString() + ", Alias : " + this.alias + ", HashCode : " + this.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DumpObject)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        DumpObject dumpObject = (DumpObject)object;
        if (!this.id.equals(dumpObject.id)) {
            return false;
        }
        if (this.alias == null) {
            return dumpObject.alias == null;
        }
        return this.alias.equals(dumpObject.alias);
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof DumpObject)) {
            throw new ClassCastException();
        }
        DumpObject dumpObject = (DumpObject)object;
        if (this.sortType > dumpObject.sortType) {
            return 1;
        }
        if (this.sortType < dumpObject.sortType) {
            return -1;
        }
        int n = this.id.compareTo(dumpObject.id);
        if (n != 0) {
            return n;
        }
        if (this.alias == null) {
            if (dumpObject.alias == null) {
                return 0;
            }
            return -1;
        }
        if (dumpObject.alias == null) {
            return 1;
        }
        return this.alias.compareTo(dumpObject.alias);
    }

    public int hashCode() {
        int n = this.id.hashCode();
        int n2 = this.alias == null ? 1 : this.alias.hashCode();
        double d = PHI * (double)n * (double)n2;
        long l = (long)Math.floor(2.147483647E9 * (d - Math.floor(d)));
        return (int)l;
    }

    public void dump(SystemEnvironment systemEnvironment, Vector vector, Vector vector2, HashMap hashMap, int n, int n2) throws SDMSException {
        try {
            switch (this.sortType) {
                case 1: {
                    vector.addAll(DumpESD.dump(systemEnvironment, (SDMSExitStateDefinition)this.object, vector2, hashMap, n2));
                    break;
                }
                case 2: {
                    vector.addAll(DumpESM.dump(systemEnvironment, (SDMSExitStateMappingProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 3: {
                    vector.addAll(DumpESP.dump(systemEnvironment, (SDMSExitStateProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 4: {
                    vector.addAll(DumpEST.dump(systemEnvironment, (SDMSExitStateTranslationProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 5: {
                    vector.addAll(DumpGroup.dump(systemEnvironment, (SDMSGroup)this.object, vector2, hashMap, n2));
                    break;
                }
                case 6: {
                    vector.addAll(DumpUser.dump(systemEnvironment, (SDMSUser)this.object, vector2, hashMap, n2));
                    break;
                }
                case 7: {
                    vector.addAll(DumpRSD.dump(systemEnvironment, (SDMSResourceStateDefinition)this.object, vector2, hashMap, n2));
                    break;
                }
                case 8: {
                    vector.addAll(DumpRSP.dump(systemEnvironment, (SDMSResourceStateProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 9: {
                    vector.addAll(DumpRSM.dump(systemEnvironment, (SDMSResourceStateMappingProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 10: {
                    vector.addAll(DumpNR.dump(systemEnvironment, (SDMSNamedResource)this.object, vector2, hashMap, n2));
                    break;
                }
                case 60: {
                    vector.addAll(DumpNP.dump(systemEnvironment, (SDMSNiceProfile)this.object, vector2, hashMap, n2));
                    break;
                }
                case 11: {
                    vector.addAll(DumpNE.dump(systemEnvironment, (SDMSNamedEnvironment)this.object, vector2, hashMap, n2));
                    break;
                }
                case 12: {
                    vector.addAll(DumpFP.dump(systemEnvironment, (SDMSFootprint)this.object, vector2, hashMap, n2));
                    break;
                }
                case 13: {
                    vector.addAll(DumpF.dump(systemEnvironment, (SDMSFolder)this.object, vector2, hashMap, n2));
                    break;
                }
                case 14: {
                    vector.addAll(DumpSE.dump(systemEnvironment, (SDMSSchedulingEntity)this.object, vector2, hashMap, n2));
                    break;
                }
                case 15: {
                    vector.addAll(DumpScope.dump(systemEnvironment, (SDMSScope)this.object, vector2, hashMap, n2));
                    break;
                }
                case 16: {
                    vector.addAll(DumpR.dump(systemEnvironment, (SDMSResource)this.object, vector2, hashMap, n, n2));
                    break;
                }
                case 17: {
                    vector.addAll(DumpRT.dump(systemEnvironment, (SDMSResourceTemplate)this.object, vector2, hashMap, n2));
                    break;
                }
                case 25: {
                    vector.addAll(DumpOM.dump(systemEnvironment, (SDMSObjectMonitor)this.object, vector2, hashMap, n2));
                    break;
                }
                case 24: {
                    vector.addAll(DumpWT.dump(systemEnvironment, (SDMSWatchType)this.object, vector2, hashMap, n2));
                    break;
                }
                case 18: {
                    vector.addAll(DumpPL.dump(systemEnvironment, (SDMSPool)this.object, vector2, hashMap, n2));
                    break;
                }
                case 19: {
                    vector.addAll(DumpD.dump(systemEnvironment, (SDMSPoolDistribution)this.object, vector2, hashMap, n2));
                    break;
                }
                case 20: {
                    vector.addAll(DumpIV.dump(systemEnvironment, (SDMSInterval)this.object, vector2, hashMap, n2));
                    break;
                }
                case 21: {
                    vector.addAll(DumpSC.dump(systemEnvironment, (SDMSSchedule)this.object, vector2, hashMap, n2));
                    break;
                }
                case 22: {
                    vector.addAll(DumpEV.dump(systemEnvironment, (SDMSEvent)this.object, vector2, hashMap, n2));
                    break;
                }
                case 23: {
                    vector.addAll(DumpSEV.dump(systemEnvironment, (SDMSScheduledEvent)this.object, vector2, hashMap, n2));
                    break;
                }
                case 26: {
                    vector.addAll(DumpTR.dump(systemEnvironment, (SDMSTrigger)this.object, vector2, hashMap, n2));
                    break;
                }
                case 40: {
                    vector.addAll(DumpCMT.dump(systemEnvironment, (SDMSObjectComment)this.object, vector2, hashMap, n2));
                    break;
                }
                case 50: {
                    vector.addAll(DumpGR.dump(systemEnvironment, (SDMSGrant)this.object, vector2, hashMap, n2));
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDMSThread.doTrace(systemEnvironment.cEnv, "ClassCastException!\nthis : " + this.toString() + "\nObject : " + this.object.toString(), -1);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03712031353", "Application Error. Please Notify your System Administrator"));
        }
    }

    static {
        sortTypeFromURL.put(25, 19);
        sortTypeFromURL.put(1, 11);
        sortTypeFromURL.put(18, 22);
        sortTypeFromURL.put(2, 1);
        sortTypeFromURL.put(3, 3);
        sortTypeFromURL.put(4, 2);
        sortTypeFromURL.put(5, 4);
        sortTypeFromURL.put(6, 13);
        sortTypeFromURL.put(7, 12);
        sortTypeFromURL.put(21, 5);
        sortTypeFromURL.put(19, 20);
        sortTypeFromURL.put(9, 14);
        sortTypeFromURL.put(10, 10);
        sortTypeFromURL.put(31, 60);
        sortTypeFromURL.put(30, 25);
        sortTypeFromURL.put(24, 18);
        sortTypeFromURL.put(11, 16);
        sortTypeFromURL.put(28, 17);
        sortTypeFromURL.put(13, 7);
        sortTypeFromURL.put(14, 8);
        sortTypeFromURL.put(12, 9);
        sortTypeFromURL.put(20, 21);
        sortTypeFromURL.put(22, 23);
        sortTypeFromURL.put(15, 15);
        sortTypeFromURL.put(16, 26);
        sortTypeFromURL.put(8, 6);
        sortTypeFromURL.put(29, 24);
        sortTypeFromURL.put(26, 40);
        sortTypeFromURL.put(27, 50);
        parseTypeFromST = new HashMap();
        parseTypeFromST.put(19, 201);
        parseTypeFromST.put(11, 100);
        parseTypeFromST.put(22, 105);
        parseTypeFromST.put(1, 101);
        parseTypeFromST.put(3, 103);
        parseTypeFromST.put(2, 102);
        parseTypeFromST.put(4, 104);
        parseTypeFromST.put(13, 106);
        parseTypeFromST.put(12, 107);
        parseTypeFromST.put(5, 109);
        parseTypeFromST.put(20, 110);
        parseTypeFromST.put(14, 111);
        parseTypeFromST.put(10, 112);
        parseTypeFromST.put(60, 113);
        parseTypeFromST.put(25, 114);
        parseTypeFromST.put(18, 115);
        parseTypeFromST.put(16, 116);
        parseTypeFromST.put(17, 117);
        parseTypeFromST.put(7, 118);
        parseTypeFromST.put(8, 120);
        parseTypeFromST.put(9, 119);
        parseTypeFromST.put(21, 121);
        parseTypeFromST.put(23, 122);
        parseTypeFromST.put(15, 123);
        parseTypeFromST.put(26, 124);
        parseTypeFromST.put(6, 125);
        parseTypeFromST.put(24, 126);
        parseTypeFromST.put(40, 200);
        parseTypeFromST.put(50, 108);
    }
}

