/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import java.util.Iterator;

public class KillSession
extends Node {
    public static final String __version = "@(#) $Id: KillSession.java,v 2.4.6.1 2013/03/14 10:24:35 ronald Exp $";
    private int sid;

    public KillSession(Integer n) {
        this.sid = n;
        this.txMode = 1;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (!systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            Iterator iterator = systemEnvironment.cEnv.gid().iterator();
            SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                try {
                    SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSConstants.lZERO, l));
                    sDMSPrivilege.addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {}
            }
            if (!sDMSPrivilege.can(0x200000000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03701301537", "Insufficient Privileges"));
            }
        }
        if (this.sid == this.env.id()) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206032301", "Session not killed"));
            return;
        }
        SystemEnvironment.server.killUser(this.sid);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03206032300", "Session killed"));
    }
}

