/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSSystemMessage;
import de.independit.scheduler.server.repository.SDMSSystemMessageTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ListApproval
extends Node {
    private static final String EMPTY = "";
    HashSet idList;

    public ListApproval() {
        this.txMode = 1;
        this.auditFlag = false;
        this.idList = null;
    }

    public ListApproval(HashSet hashSet) {
        this.txMode = 1;
        this.auditFlag = false;
        this.idList = hashSet;
    }

    private String getAdditionalInfo(SystemEnvironment systemEnvironment, SDMSSystemMessage sDMSSystemMessage, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        String string = null;
        Long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        switch (sDMSSystemMessage.getOperation(systemEnvironment)) {
            case 1: {
                if (sDMSSystemMessage.getAdditionalBool(systemEnvironment).booleanValue()) {
                    string = "Cancel with Kill";
                    break;
                }
                string = "Cancel";
                break;
            }
            case 2: {
                boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                string = bl ? "Recursive" : EMPTY;
                long l2 = System.currentTimeMillis();
                Long l3 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                Long l4 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                if (l3 == null) break;
                boolean bl2 = (l3 & 2L) != 0L;
                boolean bl3 = (l3 & 4L) != 0L;
                Object object = null;
                if (l4 != null) {
                    object = l4 < 0L ? Long.valueOf(l2 - l4) : (l4 == 0L ? null : l4);
                }
                if ((l3 & 1L) == 1L) {
                    if (object != null && (Long)object <= l2) break;
                    string = string + " Suspend";
                    if ((Long)object == 0L) break;
                    string = string + ", Resume";
                    if (l4 < 0L) {
                        string = string + " in " + l4 / -60000L + " minutes";
                        break;
                    }
                    Date date = new Date();
                    date.setTime(l4);
                    SimpleDateFormat simpleDateFormat = (SimpleDateFormat)systemEnvironment.systemDateFormat.clone();
                    simpleDateFormat.setTimeZone(sDMSSubmittedEntity.getEffectiveTimeZone(systemEnvironment));
                    string = string + " at " + simpleDateFormat.format(date);
                    break;
                }
                string = string + " Resume";
                break;
            }
            case 4: {
                Long l5 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                Long l6 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
                SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5, l);
                SDMSExitStateDefinition sDMSExitStateDefinition2 = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l6, l);
                string = "Current: " + sDMSExitStateDefinition2.getName(systemEnvironment) + ", new: " + sDMSExitStateDefinition.getName(systemEnvironment) + " " + (sDMSSystemMessage.getAdditionalBool(systemEnvironment) != false ? "[force]" : EMPTY);
                break;
            }
            case 5: {
                Long l7 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                SDMSDependencyInstance sDMSDependencyInstance = SDMSDependencyInstanceTable.getObject(systemEnvironment, l7);
                SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getRequiredId(systemEnvironment));
                Long l8 = sDMSDependencyInstance.getRequiredSeId(systemEnvironment);
                if (l8 == null) {
                    l8 = sDMSSubmittedEntity2.getSeId(systemEnvironment);
                }
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
                SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l8, l);
                string = sDMSSchedulingEntity2.pathString(systemEnvironment) + " (" + sDMSSubmittedEntity2.getId(systemEnvironment) + ") -> " + sDMSSchedulingEntity.pathString(systemEnvironment);
                break;
            }
            case 6: {
                Long l9 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l9);
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource.getNrId(systemEnvironment));
                String string2 = null;
                Long l10 = sDMSResource.getScopeId(systemEnvironment);
                try {
                    SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l10);
                    string2 = sDMSScope.pathString(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    try {
                        SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l10);
                        string2 = sDMSFolder.pathString(systemEnvironment);
                    }
                    catch (NotFoundException notFoundException2) {
                        sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l10);
                        string2 = sDMSSubmittedEntity.getSubmitPathString(systemEnvironment, true);
                    }
                }
                string = sDMSNamedResource.pathString(systemEnvironment) + " in " + string2;
                break;
            }
            case 7: {
                Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                string = bl != false ? "SUSPEND" : EMPTY;
                break;
            }
            case 11: {
                String string3 = sDMSSystemMessage.getComment(systemEnvironment);
                Long l11 = sDMSSystemMessage.getAdditionalLong(systemEnvironment);
                SDMSEntityVariable sDMSEntityVariable = SDMSEntityVariableTable.getObject(systemEnvironment, l11);
                String string4 = sDMSEntityVariable.getValue(systemEnvironment);
                String string5 = " ";
                if (string4.contains("\n")) {
                    string5 = "\n";
                }
                if (sDMSSystemMessage.getIsMandatory(systemEnvironment).booleanValue()) {
                    String string6;
                    try {
                        string6 = sDMSSubmittedEntity.getVariableValue(systemEnvironment, string3, true, "DEFAULT", false, null, false);
                    }
                    catch (SDMSException sDMSException) {
                        string6 = "UNKNOWN";
                    }
                    if (string5.equals(" ") && string6.contains("\n")) {
                        string5 = "\n";
                    }
                    string = string3 + " will be changed." + string5 + "NEW VALUE =" + string5 + "'" + string4 + "',\nOLD VALUE =" + string5 + "'" + string6 + "'";
                    break;
                }
                string = string3 + " has been changed." + string5 + "NEW VALUE =" + string5 + "'" + string4 + "'";
                break;
            }
            case 12: {
                Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                string = "KILL" + (bl != false ? " RECURSIVE" : EMPTY);
                break;
            }
            case 13: {
                int n = sDMSSystemMessage.getAdditionalLong(systemEnvironment).intValue();
                Long l12 = sDMSSystemMessage.getSecondLong(systemEnvironment);
                string = "Old state : " + sDMSSubmittedEntity.getStateAsString(systemEnvironment) + ", new state : " + SDMSSubmittedEntity.convertStateToString(n) + ", exit code = " + l12;
                break;
            }
            case 3: 
            case 23: {
                Boolean bl = sDMSSystemMessage.getAdditionalBool(systemEnvironment);
                string = bl != false ? "Disable" : "Enable";
                break;
            }
            default: {
                string = "Unknown Operation";
            }
        }
        return string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("SME_ID");
        vector.add("NAME");
        vector.add("TYPE");
        vector.add("MASTER_ID");
        vector.add("MASTER_NAME");
        vector.add("MASTER_TYPE");
        vector.add("OPERATION");
        vector.add("MODE");
        vector.add("REQUESTING_USER");
        vector.add("REQUEST_TS");
        vector.add("REQUEST_MSG");
        vector.add("ADDITIONAL_INFORMATION");
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of approval requests", vector);
        Iterator iterator = SDMSSystemMessageTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            Comparable comparable;
            SDMSProxy sDMSProxy;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            Vector<Object> vector2 = new Vector<Object>();
            SDMSSystemMessage sDMSSystemMessage = (SDMSSystemMessage)iterator.next();
            if (!sDMSSystemMessage.getMsgType(systemEnvironment).equals(1)) continue;
            Long l = sDMSSystemMessage.getSmeId(systemEnvironment);
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                if (!sDMSSubmittedEntity.getPrivileges(systemEnvironment).can(512L)) {
                }
            }
            catch (NotFoundException notFoundException) {}
            continue;
            SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, sDMSSystemMessage.getRequestUId(systemEnvironment));
            if (sDMSUser.getId(systemEnvironment).equals(systemEnvironment.cEnv.uid()) && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId) || this.idList != null && !this.idList.contains(l)) continue;
            vector2.add(sDMSSystemMessage.getId(systemEnvironment));
            vector2.add(l);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.pathString(systemEnvironment));
            vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector2.add(sDMSSubmittedEntity.getMasterId(systemEnvironment));
            if (sDMSSubmittedEntity.getMasterId(systemEnvironment) != l) {
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getMasterId(systemEnvironment));
                comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSProxy.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                vector2.add(((SDMSSchedulingEntity)comparable).pathString(systemEnvironment));
                vector2.add(((SDMSSchedulingEntityProxyGeneric)comparable).getTypeAsString(systemEnvironment));
            } else {
                vector2.add(sDMSSchedulingEntity.pathString(systemEnvironment));
                vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            }
            vector2.add(sDMSSystemMessage.getOperationAsString(systemEnvironment));
            if (sDMSSystemMessage.getIsMandatory(systemEnvironment).booleanValue()) {
                vector2.add("APPROVAL");
            } else {
                vector2.add("REVIEW");
            }
            sDMSProxy = SDMSUserTable.getObject(systemEnvironment, sDMSSystemMessage.getRequestUId(systemEnvironment));
            vector2.add(sDMSUser.getName(systemEnvironment));
            comparable = sDMSSystemMessage.getRequestTs(systemEnvironment);
            Date date = new Date();
            date.setTime((Long)comparable);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
            vector2.add(sDMSSystemMessage.getRequestMsg(systemEnvironment));
            vector2.add(this.getAdditionalInfo(systemEnvironment, sDMSSystemMessage, sDMSSubmittedEntity));
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03106151242", "$1 item(s) to approve found", sDMSOutputContainer.lines));
    }
}

