/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class ListDependencyHierarchy
extends Node {
    public static final String __version = "@(#) $Id: ListDependencyHierarchy.java,v 2.11.2.2 2013/06/18 09:49:32 ronald Exp $";
    private final Long smeId;
    private final HashSet expandIds;
    private final Boolean isCondensed;
    private final HashMap depsComp_nameHash = new HashMap();

    public ListDependencyHierarchy(Long l, Boolean bl) {
        this.smeId = l;
        this.expandIds = null;
        this.txMode = 1;
        this.auditFlag = false;
        this.isCondensed = bl;
    }

    public ListDependencyHierarchy(Long l, HashSet hashSet, Boolean bl) {
        this.smeId = l;
        this.expandIds = hashSet;
        this.txMode = 1;
        this.auditFlag = false;
        this.isCondensed = bl;
    }

    private Object asTimestamp(SystemEnvironment systemEnvironment, Long l) {
        if (l == null) {
            return null;
        }
        Date date = new Date();
        date.setTime(l);
        return systemEnvironment.systemDateFormat.format(date);
    }

    private Object asOwnerString(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return null;
        }
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
        if (sDMSGroup == null) {
            return null;
        }
        return sDMSGroup.getName(systemEnvironment);
    }

    private Object asScopeString(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return null;
        }
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
        if (sDMSScope == null) {
            return null;
        }
        return sDMSScope.pathString(systemEnvironment);
    }

    private Object asEsdString(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        if (l == null) {
            return null;
        }
        SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l, l2);
        if (sDMSExitStateDefinition == null) {
            return null;
        }
        return sDMSExitStateDefinition.getName(systemEnvironment);
    }

    private String getSePathString(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return null;
        }
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        return sDMSSchedulingEntity.pathString(systemEnvironment);
    }

    private String getSmePathString(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        Long l3;
        SDMSProxy sDMSProxy;
        if (l == null) {
            return null;
        }
        long l4 = l2;
        try {
            sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
            l3 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getSeId(systemEnvironment);
            l4 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getSeVersion(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            l3 = l;
        }
        sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l4);
        return ((SDMSSchedulingEntity)sDMSProxy).pathString(systemEnvironment);
    }

    private String getSmePathString(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l == null) {
            return null;
        }
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
        Long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        Long l3 = (long)sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l3);
        return sDMSSchedulingEntity.pathString(systemEnvironment);
    }

    private Long cntRequired(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        if (sDMSSubmittedEntity.getState(systemEnvironment) != 1) {
            return SDMSConstants.lZERO;
        }
        Vector vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        return vector == null ? 0L : (long)vector.size();
    }

    private final void render_deps(SystemEnvironment systemEnvironment, Long l, String string, SDMSOutputContainer sDMSOutputContainer, HashSet hashSet) throws SDMSException {
        Vector vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l);
        Collections.sort(vector, new depsComp(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSProxy sDMSProxy;
            Object object;
            SDMSProxy sDMSProxy2;
            Comparable comparable;
            CharSequence charSequence;
            Object object2;
            Vector vector2;
            Long l2;
            long l3;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            SDMSDependencyInstance sDMSDependencyInstance = (SDMSDependencyInstance)vector.get(i);
            Long l4 = sDMSDependencyInstance.getDependentId(systemEnvironment);
            Long l5 = sDMSDependencyInstance.getRequiredId(systemEnvironment);
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l5);
            }
            catch (NotFoundException notFoundException) {
                sDMSSubmittedEntity = null;
            }
            Long l6 = null;
            SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
            if (sDMSSubmittedEntity != null) {
                l6 = sDMSSubmittedEntity.getParentId(systemEnvironment);
                l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
            } else {
                l3 = sDMSSubmittedEntity2.getSeVersion(systemEnvironment);
                l2 = l5;
            }
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l3);
            String string2 = string + ";";
            string2 = sDMSSubmittedEntity != null ? string2 + sDMSSubmittedEntity.getSubmitPathString(systemEnvironment) : string2 + sDMSSchedulingEntity.pathString(systemEnvironment);
            Long l7 = sDMSDependencyInstance.getDdId(systemEnvironment);
            SDMSDependencyDefinition sDMSDependencyDefinition = SDMSDependencyDefinitionTable.getObject(systemEnvironment, l7, l3);
            Long l8 = sDMSDependencyDefinition.getSeDependentId(systemEnvironment);
            Long l9 = sDMSDependencyDefinition.getSeRequiredId(systemEnvironment);
            boolean bl = hashSet.contains(l2);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSDependencyInstance.getId(systemEnvironment));
            vector3.add(l7);
            vector3.add(l4);
            vector3.add(this.getSmePathString(systemEnvironment, l4));
            vector3.add(l5);
            vector3.add(this.getSmePathString(systemEnvironment, l5, l3));
            vector3.add(sDMSDependencyInstance.getStateAsString(systemEnvironment));
            vector3.add(string2);
            vector3.add(l8);
            vector3.add(this.getSePathString(systemEnvironment, l8));
            vector3.add(l9);
            vector3.add(this.getSePathString(systemEnvironment, l9));
            vector3.add(sDMSDependencyDefinition.getName(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getUnresolvedHandlingAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getModeAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getStateSelectionAsString(systemEnvironment));
            vector3.add(sDMSSubmittedEntity2.getMasterId(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            if (sDMSSubmittedEntity != null) {
                vector3.add(l6);
                vector3.add(this.getSmePathString(systemEnvironment, l6));
                vector3.add(this.asOwnerString(systemEnvironment, sDMSSubmittedEntity.getOwnerId(systemEnvironment)));
                vector3.add(this.asScopeString(systemEnvironment, sDMSSubmittedEntity.getScopeId(systemEnvironment)));
                vector3.add(sDMSSubmittedEntity.getExitCode(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getPid(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getExtPid(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getStateAsString(systemEnvironment));
                vector3.add(this.asEsdString(systemEnvironment, sDMSSubmittedEntity.getJobEsdId(systemEnvironment), l3));
                vector3.add(this.asEsdString(systemEnvironment, sDMSSubmittedEntity.getFinalEsdId(systemEnvironment), l3));
                vector3.add(sDMSSubmittedEntity.getJobIsFinal(systemEnvironment));
                vector3.add(bl ? SDMSConstants.lZERO : this.cntRequired(systemEnvironment, sDMSSubmittedEntity));
                vector3.add(sDMSSubmittedEntity.getCntRestartable(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntRunnable(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntStarting(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntStarted(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntRunning(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntToKill(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntKilled(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntCancelled(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntFinal(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntError(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntFinished(systemEnvironment));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getSubmitTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getSyncTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getResourceTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getRunnableTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getStartTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getFinishTs(systemEnvironment)));
                vector3.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getFinalTs(systemEnvironment)));
                vector3.add(sDMSSubmittedEntity.getErrorMsg(systemEnvironment));
                vector3.add(sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
                vector3.add(sDMSDependencyInstance.getDependencyOperationAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getChildTag(systemEnvironment));
                vector2 = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                vector3.add(vector2.size());
                vector2 = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                vector3.add(vector2.size());
                object2 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, (Object)sDMSDependencyDefinition.getId(systemEnvironment), l3);
                charSequence = "";
                comparable = new StringBuffer();
                for (int j = 0; j < ((Vector)object2).size(); ++j) {
                    sDMSProxy2 = (SDMSDependencyState)((Vector)object2).get(j);
                    object = SDMSExitStateDefinitionTable.getObject(systemEnvironment, ((SDMSDependencyStateProxyGeneric)sDMSProxy2).getEsdId(systemEnvironment), l3);
                    String string3 = ((SDMSExitStateDefinitionProxyGeneric)object).getName(systemEnvironment);
                    ((StringBuffer)comparable).append((String)charSequence);
                    ((StringBuffer)comparable).append(string3);
                    charSequence = ",";
                }
                vector3.add(new String((StringBuffer)comparable));
                vector3.add(sDMSSubmittedEntity.getIsSuspendedAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getParentSuspended(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment));
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
                vector3.add(((SDMSSubmittedEntity)sDMSProxy).getSubmitPathString(systemEnvironment));
                vector3.add(sDMSDependencyInstance.getIgnoreAsString(systemEnvironment));
            } else {
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add(SDMSConstants.lZERO);
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add("");
                vector3.add(sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
                vector3.add(sDMSDependencyInstance.getDependencyOperationAsString(systemEnvironment));
                vector3.add("");
                vector3.add(SDMSConstants.iZERO);
                vector3.add(SDMSConstants.iZERO);
                vector2 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, (Object)sDMSDependencyDefinition.getId(systemEnvironment), l3);
                object2 = "";
                charSequence = new StringBuffer();
                for (int j = 0; j < vector2.size(); ++j) {
                    sDMSProxy = (SDMSDependencyState)vector2.get(j);
                    sDMSProxy2 = SDMSExitStateDefinitionTable.getObject(systemEnvironment, ((SDMSDependencyStateProxyGeneric)sDMSProxy).getEsdId(systemEnvironment), l3);
                    object = ((SDMSExitStateDefinitionProxyGeneric)sDMSProxy2).getName(systemEnvironment);
                    charSequence.append((String)object2);
                    charSequence.append((String)object);
                    object2 = ",";
                }
                vector3.add(new String((StringBuffer)charSequence));
                vector3.add("");
                vector3.add("");
                vector3.add("");
                comparable = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
                vector3.add(((SDMSSubmittedEntity)comparable).getSubmitPathString(systemEnvironment));
                vector3.add(sDMSDependencyInstance.getIgnoreAsString(systemEnvironment));
            }
            vector3.add(sDMSDependencyDefinition.getResolveModeAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getExpiredAmount(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getExpiredBaseAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getSelectCondition(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
            if (sDMSSubmittedEntity == null || this.expandIds != null && !this.expandIds.contains(l5) || bl || sDMSSubmittedEntity.getState(systemEnvironment) != 1) continue;
            hashSet.add(l5);
            this.render_deps(systemEnvironment, l5, string2, sDMSOutputContainer, hashSet);
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("DD_ID");
        vector.add("DEPENDENT_ID");
        vector.add("DEPENDENT_NAME");
        vector.add("REQUIRED_ID");
        vector.add("REQUIRED_NAME");
        vector.add("DEP_STATE");
        vector.add("DEPENDENCY_PATH");
        vector.add("SE_DEPENDENT_ID");
        vector.add("SE_DEPENDENT_NAME");
        vector.add("SE_REQUIRED_ID");
        vector.add("SE_REQUIRED_NAME");
        vector.add("DD_NAME");
        vector.add("UNRESOLVED_HANDLING");
        vector.add("MODE");
        vector.add("STATE_SELECTION");
        vector.add("MASTER_ID");
        vector.add("SE_TYPE");
        vector.add("PARENT_ID");
        vector.add("PARENT_NAME");
        vector.add("OWNER");
        vector.add("SCOPE");
        vector.add("EXIT_CODE");
        vector.add("PID");
        vector.add("EXTPID");
        vector.add("JOB_STATE");
        vector.add("JOB_ESD");
        vector.add("FINAL_ESD");
        vector.add("JOB_IS_FINAL");
        vector.add("CNT_REQUIRED");
        vector.add("CNT_RESTARTABLE");
        vector.add("CNT_SUBMITTED");
        vector.add("CNT_DEPENDENCY_WAIT");
        vector.add("CNT_RESOURCE_WAIT");
        vector.add("CNT_RUNNABLE");
        vector.add("CNT_STARTING");
        vector.add("CNT_STARTED");
        vector.add("CNT_RUNNING");
        vector.add("CNT_TO_KILL");
        vector.add("CNT_KILLED");
        vector.add("CNT_CANCELLED");
        vector.add("CNT_FINAL");
        vector.add("CNT_BROKEN_ACTIVE");
        vector.add("CNT_BROKEN_FINISHED");
        vector.add("CNT_ERROR");
        vector.add("CNT_SYNCHRONIZE_WAIT");
        vector.add("CNT_FINISHED");
        vector.add("SUBMIT_TS");
        vector.add("SYNC_TS");
        vector.add("RESOURCE_TS");
        vector.add("RUNNABLE_TS");
        vector.add("START_TS");
        vector.add("FINSH_TS");
        vector.add("FINAL_TS");
        vector.add("ERROR_MSG");
        vector.add("DEPENDENT_ID_ORIG");
        vector.add("DEPENDENCY_OPERATION");
        vector.add("CHILD_TAG");
        vector.add("CHILDREN");
        vector.add("REQUIRED");
        vector.add("DD_STATES");
        vector.add("IS_SUSPENDED");
        vector.add("PARENT_SUSPENDED");
        vector.add("CNT_UNREACHABLE");
        vector.add("DEPENDENT_PATH_ORIG");
        vector.add("IGNORE");
        vector.add("RESOLVE_MODE");
        vector.add("EXPIRED_AMOUNT");
        vector.add("EXPIRED_BASE");
        vector.add("SELECT_CONDITION");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Dependency Hierarchy", vector);
        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.smeId);
        Long l = sDMSSubmittedEntity.getParentId(systemEnvironment);
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        Long l3 = sDMSSubmittedEntity.getSeId(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3, l2);
        String string = sDMSSubmittedEntity.getSubmitPathString(systemEnvironment);
        HashSet<Long> hashSet = new HashSet<Long>();
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add(string);
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add(sDMSSubmittedEntity.getMasterId(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        vector2.add(l);
        vector2.add(this.getSmePathString(systemEnvironment, l));
        vector2.add(this.asOwnerString(systemEnvironment, sDMSSubmittedEntity.getOwnerId(systemEnvironment)));
        vector2.add(this.asScopeString(systemEnvironment, sDMSSubmittedEntity.getScopeId(systemEnvironment)));
        vector2.add(sDMSSubmittedEntity.getExitCode(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getPid(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getExtPid(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getStateAsString(systemEnvironment));
        vector2.add(this.asEsdString(systemEnvironment, sDMSSubmittedEntity.getJobEsdId(systemEnvironment), l2));
        vector2.add(this.asEsdString(systemEnvironment, sDMSSubmittedEntity.getFinalEsdId(systemEnvironment), l2));
        vector2.add(sDMSSubmittedEntity.getJobIsFinal(systemEnvironment));
        vector2.add(this.cntRequired(systemEnvironment, sDMSSubmittedEntity));
        vector2.add(sDMSSubmittedEntity.getCntRestartable(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntRunnable(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntStarting(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntStarted(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntRunning(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntToKill(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntKilled(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntCancelled(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntFinal(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntError(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntFinished(systemEnvironment));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getSubmitTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getSyncTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getResourceTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getRunnableTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getStartTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getFinishTs(systemEnvironment)));
        vector2.add(this.asTimestamp(systemEnvironment, sDMSSubmittedEntity.getFinalTs(systemEnvironment)));
        vector2.add(sDMSSubmittedEntity.getErrorMsg(systemEnvironment));
        vector2.add("");
        vector2.add("");
        vector2.add(sDMSSubmittedEntity.getChildTag(systemEnvironment));
        Vector vector3 = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        vector2.add(vector3.size());
        vector3 = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        vector2.add(vector3.size());
        vector2.add("");
        vector2.add(sDMSSubmittedEntity.getIsSuspendedAsString(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getParentSuspended(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment));
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        vector2.add("");
        sDMSOutputContainer.addData(systemEnvironment, vector2);
        if (this.expandIds == null || this.expandIds.size() > 0) {
            hashSet.add(this.smeId);
            this.render_deps(systemEnvironment, this.smeId, string, sDMSOutputContainer, hashSet);
        }
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04205142204", "$1 Dependencies found", sDMSOutputContainer.lines));
    }

    private class depsComp
    implements Comparator {
        private final SystemEnvironment env;

        public depsComp(SystemEnvironment systemEnvironment) {
            this.env = systemEnvironment;
        }

        private String getName(SDMSDependencyInstance sDMSDependencyInstance) {
            try {
                long l;
                SDMSProxy sDMSProxy;
                Long l2 = sDMSDependencyInstance.getId(this.env);
                String string = (String)ListDependencyHierarchy.this.depsComp_nameHash.get(l2);
                if (string != null) {
                    return string;
                }
                Long l3 = sDMSDependencyInstance.getRequiredId(this.env);
                Long l4 = null;
                try {
                    sDMSProxy = SDMSSubmittedEntityTable.getObject(this.env, l3);
                    l = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getSeVersion(this.env);
                    l4 = ((SDMSSubmittedEntityProxyGeneric)sDMSProxy).getSeId(this.env);
                }
                catch (NotFoundException notFoundException) {
                    SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(this.env, sDMSDependencyInstance.getDependentId(this.env));
                    l = sDMSSubmittedEntity.getSeVersion(this.env);
                    l4 = l3;
                }
                sDMSProxy = SDMSSchedulingEntityTable.getObject(this.env, l4, l);
                string = ((SDMSSchedulingEntity)sDMSProxy).pathString(this.env);
                ListDependencyHierarchy.this.depsComp_nameHash.put(l2, string);
                return string;
            }
            catch (SDMSException sDMSException) {
                return new String("");
            }
        }

        public int compare(Object object, Object object2) {
            Long l;
            Long l2;
            try {
                l2 = ((SDMSDependencyInstance)object).getDependentIdOrig(this.env);
            }
            catch (SDMSException sDMSException) {
                l2 = null;
            }
            try {
                l = ((SDMSDependencyInstance)object2).getDependentIdOrig(this.env);
            }
            catch (SDMSException sDMSException) {
                l = null;
            }
            int n = l2.compareTo(l);
            if (n == 0) {
                String string = this.getName((SDMSDependencyInstance)object);
                String string2 = this.getName((SDMSDependencyInstance)object2);
                return string.compareTo(string2);
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object == this;
        }
    }
}

