/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class ListPool
extends Node {
    public static final String __version = "@(#) $Id: ListPool.java,v 2.6.14.5 2013/06/18 09:49:33 ronald Exp $";

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        systemEnvironment.checkFeatureAvailability("POOL");
        vector.add("ID");
        vector.add("NAME");
        vector.add("SCOPENAME");
        vector.add("OWNER");
        vector.add("MANAGER_ID");
        vector.add("MANAGER_NAME");
        vector.add("MANAGER_SCOPENAME");
        vector.add("DEFINED_AMOUNT");
        vector.add("AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("EVALUATION_CYCLE");
        vector.add("NEXT_EVALUATION_TIME");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Iterator iterator = SDMSPoolTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSPool sDMSPool = (SDMSPool)iterator.next();
            if (!sDMSPool.checkPrivileges(systemEnvironment, 0x10000000L)) continue;
            sDMSOutputContainer.addData(systemEnvironment, this.renderPool(systemEnvironment, sDMSPool));
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603151712", "$1 Pool(s) found", sDMSOutputContainer.lines));
    }

    private Vector renderPool(SystemEnvironment systemEnvironment, SDMSPool sDMSPool) throws SDMSException {
        Comparable comparable;
        Comparable comparable2;
        Vector<Object> vector = new Vector<Object>();
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSPool.getNrId(systemEnvironment));
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSPool.getScopeId(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSPool.getOwnerId(systemEnvironment));
        Long l = sDMSPool.getId(systemEnvironment);
        vector.add(l);
        vector.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector.add(sDMSScope.pathVector(systemEnvironment));
        vector.add(sDMSGroup.getName(systemEnvironment));
        Long l2 = sDMSPool.getManagerId(systemEnvironment);
        vector.add(l2);
        if (l2 != null) {
            comparable2 = SDMSPooledResourceTable.getObject(systemEnvironment, l2);
            comparable = SDMSPoolTable.getObject(systemEnvironment, comparable2.getPId(systemEnvironment));
            vector.add(SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getNrId(systemEnvironment)).pathVector(systemEnvironment));
            vector.add(SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getScopeId(systemEnvironment)).pathVector(systemEnvironment));
        } else {
            vector.add(null);
            vector.add(null);
        }
        vector.add(sDMSPool.getDefinedAmount(systemEnvironment));
        vector.add(sDMSPool.getAmount(systemEnvironment));
        vector.add(sDMSPool.getFreeAmount(systemEnvironment));
        comparable2 = sDMSPool.getEvaluationCycle(systemEnvironment);
        if (comparable2 == null) {
            comparable2 = Integer.valueOf(SystemEnvironment.ptEvalCycle);
        }
        vector.add(comparable2);
        comparable = new Date();
        ((Date)comparable).setTime(sDMSPool.getNextEvaluationTime(systemEnvironment));
        vector.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector.add(SDMSUserTable.getObject(systemEnvironment, sDMSPool.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector.add("unknown");
        }
        ((Date)comparable).setTime(sDMSPool.getCreateTs(systemEnvironment));
        vector.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector.add(SDMSUserTable.getObject(systemEnvironment, sDMSPool.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector.add("unknown");
        }
        ((Date)comparable).setTime(sDMSPool.getChangeTs(systemEnvironment));
        vector.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector.add(sDMSPool.getPrivileges(systemEnvironment).toString());
        return vector;
    }
}

