/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NonRecoverableException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.parser.cmdline.CmdLineParser;
import de.independit.scheduler.server.parser.cmdline.CmdLineScanner;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSUserProxyGeneric;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.BoolExpr;
import de.independit.scheduler.server.util.PathVector;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public abstract class ManipJobDefinition
extends Node {
    ObjectURL url = null;
    Vector path;
    WithHash withs;
    String name;
    Long folderId;
    Integer otype;
    int type;
    String runProgram;
    String rerunProgram;
    String killProgram;
    String workdir;
    String logfile;
    Boolean truncLog;
    String errlogfile;
    Boolean truncErrlog;
    Integer expectedRuntime;
    Integer expectedFinaltime;
    String getExpectedRuntime;
    Integer priority;
    Integer minPriority;
    WithHash aging;
    Integer agingAmount = null;
    Integer agingBase = null;
    Boolean submitSuspended;
    String resumeAt = null;
    Integer resumeIn = null;
    Integer resumeBase = null;
    Boolean masterSubmittable;
    Boolean sameNode;
    Boolean gangSchedule;
    Integer dependencyOperation;
    Long esmpId;
    Long espId;
    Long qaId;
    Long neId;
    Long fpId;
    WithHash timeout;
    Integer to_mult = null;
    Integer to_interval = null;
    String to_state = null;
    Long to_esdId;
    String gName;
    Long gId;
    Boolean gotCancel = Boolean.FALSE;
    Boolean gotRerun = Boolean.FALSE;
    Boolean gotEnable = Boolean.FALSE;
    Boolean gotSetState = Boolean.FALSE;
    Boolean gotIgnDep = Boolean.FALSE;
    Boolean gotIgnRss = Boolean.FALSE;
    Boolean gotClone = Boolean.FALSE;
    Boolean gotSuspend = Boolean.FALSE;
    Boolean gotClrWarn = Boolean.FALSE;
    Boolean gotPriority = Boolean.FALSE;
    Boolean gotEditParm = Boolean.FALSE;
    Boolean gotKill = Boolean.FALSE;
    Boolean gotSetJobState = Boolean.FALSE;
    Boolean cancelLeadFlag = Boolean.FALSE;
    Boolean rerunLeadFlag = Boolean.FALSE;
    Boolean enableLeadFlag = Boolean.FALSE;
    Boolean setStateLeadFlag = Boolean.FALSE;
    Boolean ignDepLeadFlag = Boolean.FALSE;
    Boolean ignRssLeadFlag = Boolean.FALSE;
    Boolean cloneLeadFlag = Boolean.FALSE;
    Boolean editParmLeadFlag = Boolean.FALSE;
    Boolean killLeadFlag = Boolean.FALSE;
    Boolean setJobStateLeadFlag = Boolean.FALSE;
    Integer cancelApproval = 0;
    Integer rerunApproval = 0;
    Integer enableApproval = 0;
    Integer setStateApproval = 0;
    Integer ignDepApproval = 0;
    Integer ignRssApproval = 0;
    Integer cloneApproval = 0;
    Integer editParmApproval = 0;
    Integer killApproval = 0;
    Integer setJobStateApproval = 0;
    Long inheritPrivs;
    Vector childdeflist;
    Vector dependencydeflist;
    Vector resourcedeflist;
    WithHash parameters;
    SDMSExitStateProfile esp;
    boolean priowarn = false;
    boolean noerr;
    HashSet resourceList = null;
    SDMSSchedulingEntity se = null;

    public ManipJobDefinition(Vector vector, String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.path = vector;
        this.withs = withHash;
        this.noerr = bl;
    }

    public ManipJobDefinition(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.url = objectURL;
        this.withs = withHash;
        this.noerr = bl;
    }

    protected void evaluateWith(SystemEnvironment systemEnvironment) throws SDMSException {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        Serializable serializable5;
        Serializable serializable6;
        Serializable serializable7;
        Serializable serializable8;
        Serializable serializable9;
        Object object;
        if (this.url != null) {
            this.se = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
            this.folderId = this.se.getFolderId(systemEnvironment);
        } else {
            this.folderId = SDMSFolderTable.pathToId(systemEnvironment, this.path);
        }
        this.otype = (Integer)this.withs.get("TYPE");
        this.runProgram = (String)this.withs.get("RUN_PROGRAM");
        this.rerunProgram = (String)this.withs.get("RERUN_PROGRAM");
        this.killProgram = (String)this.withs.get("KILL_PROGRAM");
        this.workdir = (String)this.withs.get("WORKDIR");
        WithHash withHash = (WithHash)this.withs.get("LOGFILE");
        if (withHash != null) {
            this.logfile = (String)withHash.get("FILENAME");
            this.truncLog = (Boolean)withHash.get("TRUNC");
        }
        if ((withHash = (WithHash)this.withs.get("ERRLOG")) != null) {
            this.errlogfile = (String)withHash.get("FILENAME");
            this.truncErrlog = (Boolean)withHash.get("TRUNC");
        }
        this.expectedRuntime = (Integer)this.withs.get("RUNTIME");
        this.expectedFinaltime = (Integer)this.withs.get("FINAL");
        this.priority = (Integer)this.withs.get("PRIORITY");
        this.minPriority = (Integer)this.withs.get("MPRIORITY");
        this.aging = (WithHash)this.withs.get("AGING");
        if (this.minPriority != null || this.aging != null) {
            systemEnvironment.checkFeatureAvailability("JOB_LEVEL_AGING_CONTROL");
        }
        this.submitSuspended = (Boolean)this.withs.get("SUSPEND");
        Object v = this.withs.get("RESUME");
        if (v != null) {
            if (v instanceof String) {
                this.resumeAt = (String)v;
            } else {
                object = (WithHash)v;
                this.resumeIn = (Integer)((HashMap)object).get("MULT");
                this.resumeBase = (Integer)((HashMap)object).get("INTERVAL");
            }
        }
        this.masterSubmittable = (Boolean)this.withs.get("MASTER");
        this.sameNode = null;
        this.gangSchedule = null;
        this.dependencyOperation = (Integer)this.withs.get("DEPENDENCY_MODE");
        String string = (String)this.withs.get("MAPPING");
        this.esmpId = string != null ? SDMSExitStateMappingProfileTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment) : null;
        string = (String)this.withs.get("PROFILE");
        if (string != null) {
            this.esp = SDMSExitStateProfileTable.idx_name_getUnique(systemEnvironment, string);
            this.espId = this.esp.getId(systemEnvironment);
        } else {
            this.esp = null;
            this.espId = null;
        }
        this.childdeflist = (Vector)this.withs.get("CHILDREN");
        this.dependencydeflist = (Vector)this.withs.get("REQUIRED");
        this.resourcedeflist = (Vector)this.withs.get("RESOURCE");
        this.timeout = (WithHash)this.withs.get("TIMEOUT");
        this.parameters = (WithHash)this.withs.get("PARAMETERS");
        string = (String)this.withs.get("ENVIRONMENT");
        if (string != null) {
            object = SDMSNamedEnvironmentTable.idx_name_getUnique(systemEnvironment, string);
            this.neId = ((SDMSProxy)object).getId(systemEnvironment);
        }
        this.fpId = (string = (String)this.withs.get("FOOTPRINT")) != null ? SDMSFootprintTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment) : null;
        this.gName = (String)this.withs.get("GROUP");
        if (this.gName != null) {
            this.gId = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.gName), SDMSConstants.lZERO)).getId(systemEnvironment);
        } else {
            object = SDMSUserTable.getObject(systemEnvironment, this.env.uid());
            this.gId = ((SDMSUserProxyGeneric)object).getDefaultGId(systemEnvironment);
        }
        object = this.withs.containsKey("APPROVE") ? (WithHash)this.withs.get("APPROVE") : new WithHash();
        Long l = SDMSConstants.PR_CANCEL;
        if (((HashMap)object).containsKey(l)) {
            serializable9 = (SDMSKey)((HashMap)object).get(l);
            this.cancelApproval = (Integer)((Vector)serializable9).get(0);
            this.cancelLeadFlag = (Boolean)((Vector)serializable9).get(1);
            this.gotCancel = Boolean.TRUE;
        } else {
            this.gotCancel = Boolean.FALSE;
            this.cancelLeadFlag = Boolean.FALSE;
            this.cancelApproval = 0;
        }
        serializable9 = SDMSConstants.PR_RERUN;
        if (((HashMap)object).containsKey(serializable9)) {
            serializable8 = (SDMSKey)((HashMap)object).get(serializable9);
            this.gotRerun = Boolean.TRUE;
            this.rerunApproval = (Integer)((Vector)serializable8).get(0);
            this.rerunLeadFlag = (Boolean)((Vector)serializable8).get(1);
        } else {
            this.gotRerun = Boolean.FALSE;
            this.rerunLeadFlag = Boolean.FALSE;
            this.rerunApproval = 0;
        }
        serializable8 = SDMSConstants.PR_ENABLE;
        if (((HashMap)object).containsKey(serializable8)) {
            serializable7 = (SDMSKey)((HashMap)object).get(serializable8);
            this.gotEnable = Boolean.TRUE;
            this.enableApproval = (Integer)((Vector)serializable7).get(0);
            this.enableLeadFlag = (Boolean)((Vector)serializable7).get(1);
        } else {
            this.gotEnable = Boolean.FALSE;
            this.enableLeadFlag = Boolean.FALSE;
            this.enableApproval = 0;
        }
        serializable7 = SDMSConstants.PR_SET_STATE;
        if (((HashMap)object).containsKey(serializable7)) {
            serializable6 = (SDMSKey)((HashMap)object).get(serializable7);
            this.gotSetState = Boolean.TRUE;
            this.setStateApproval = (Integer)((Vector)serializable6).get(0);
            this.setStateLeadFlag = (Boolean)((Vector)serializable6).get(1);
        } else {
            this.gotSetState = Boolean.FALSE;
            this.setStateLeadFlag = Boolean.FALSE;
            this.setStateApproval = 0;
        }
        serializable6 = SDMSConstants.PR_IGN_DEPENDENCY;
        if (((HashMap)object).containsKey(serializable6)) {
            serializable5 = (SDMSKey)((HashMap)object).get(serializable6);
            this.gotIgnDep = Boolean.TRUE;
            this.ignDepApproval = (Integer)((Vector)serializable5).get(0);
            this.ignDepLeadFlag = (Boolean)((Vector)serializable5).get(1);
        } else {
            this.gotIgnDep = Boolean.FALSE;
            this.ignDepLeadFlag = Boolean.FALSE;
            this.ignDepApproval = 0;
        }
        serializable5 = SDMSConstants.PR_IGN_RESOURCE;
        if (((HashMap)object).containsKey(serializable5)) {
            serializable4 = (SDMSKey)((HashMap)object).get(serializable5);
            this.gotIgnRss = Boolean.TRUE;
            this.ignRssApproval = (Integer)((Vector)serializable4).get(0);
            this.ignRssLeadFlag = (Boolean)((Vector)serializable4).get(1);
        } else {
            this.gotIgnRss = Boolean.FALSE;
            this.ignRssLeadFlag = Boolean.FALSE;
            this.ignRssApproval = 0;
        }
        serializable4 = SDMSConstants.PR_CLONE;
        if (((HashMap)object).containsKey(serializable4)) {
            serializable3 = (SDMSKey)((HashMap)object).get(serializable4);
            this.gotClone = Boolean.TRUE;
            this.cloneApproval = (Integer)((Vector)serializable3).get(0);
            this.cloneLeadFlag = (Boolean)((Vector)serializable3).get(1);
        } else {
            this.gotClone = Boolean.FALSE;
            this.cloneLeadFlag = Boolean.FALSE;
            this.cloneApproval = 0;
        }
        serializable3 = SDMSConstants.PR_MODIFY_PARAMETER;
        if (((HashMap)object).containsKey(serializable3)) {
            serializable2 = (SDMSKey)((HashMap)object).get(serializable3);
            this.gotEditParm = Boolean.TRUE;
            this.editParmApproval = (Integer)((Vector)serializable2).get(0);
            this.editParmLeadFlag = (Boolean)((Vector)serializable2).get(1);
        } else {
            this.gotEditParm = Boolean.FALSE;
            this.editParmLeadFlag = Boolean.FALSE;
            this.editParmApproval = 0;
        }
        serializable2 = SDMSConstants.PR_KILL;
        if (((HashMap)object).containsKey(serializable2)) {
            serializable = (SDMSKey)((HashMap)object).get(serializable2);
            this.gotKill = Boolean.TRUE;
            this.killApproval = (Integer)((Vector)serializable).get(0);
            this.killLeadFlag = (Boolean)((Vector)serializable).get(1);
        } else {
            this.gotKill = Boolean.FALSE;
            this.killLeadFlag = Boolean.FALSE;
            this.killApproval = 0;
        }
        serializable = SDMSConstants.PR_SET_JOB_STATE;
        if (((HashMap)object).containsKey(serializable)) {
            SDMSKey sDMSKey = (SDMSKey)((HashMap)object).get(serializable);
            this.gotSetJobState = Boolean.TRUE;
            this.setJobStateApproval = (Integer)sDMSKey.get(0);
            this.setJobStateLeadFlag = (Boolean)sDMSKey.get(1);
        } else {
            this.gotSetJobState = Boolean.FALSE;
            this.setJobStateLeadFlag = Boolean.FALSE;
            this.setJobStateApproval = 0;
        }
        if (this.withs.containsKey("INHERIT")) {
            this.inheritPrivs = (Long)this.withs.get("INHERIT");
            if (this.inheritPrivs == null) {
                this.inheritPrivs = SDMSConstants.lZERO;
            }
        } else {
            this.inheritPrivs = SDMSConstants.lZERO;
        }
        long l2 = this.inheritPrivs;
        this.inheritPrivs = l2;
    }

    protected void checkJob(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.runProgram == null || this.runProgram.equals("")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141002", "Job needs a Run Program"));
        }
        if (this.logfile == null) {
            this.truncLog = null;
        }
        if (this.errlogfile == null) {
            this.truncErrlog = null;
        }
        if (this.priority != null) {
            if (this.priority > 100) {
                this.priority = SDMSConstants.ST_MIN_PRIORITY;
                this.priowarn = true;
            }
            if (this.priority < 0) {
                this.priority = SDMSConstants.ST_MAX_PRIORITY;
                this.priowarn = true;
            }
            if (this.priority < SystemEnvironment.priorityLowerBound && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                this.priority = SystemEnvironment.priorityLowerBound;
                this.priowarn = true;
            }
        } else {
            this.priority = SDMSConstants.ST_DEFAULT_PRIORITY;
        }
        if (this.minPriority != null) {
            if (this.minPriority > 100) {
                this.minPriority = SDMSConstants.ST_MIN_PRIORITY;
                this.priowarn = true;
            }
            if (this.minPriority < 0) {
                this.minPriority = SDMSConstants.ST_MAX_PRIORITY;
                this.priowarn = true;
            }
            if (this.minPriority < SystemEnvironment.priorityLowerBound && !systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
                this.priority = SystemEnvironment.priorityLowerBound;
                this.priowarn = true;
            }
        }
        if (this.aging != null) {
            this.agingAmount = (Integer)this.aging.get("MULT");
            this.agingBase = (Integer)this.aging.get("INTERVAL");
        }
        if (this.submitSuspended == null) {
            this.submitSuspended = Boolean.FALSE;
        }
        if (this.masterSubmittable == null) {
            this.masterSubmittable = Boolean.FALSE;
        }
        if (this.dependencyOperation == null) {
            this.dependencyOperation = SDMSConstants.SE_AND;
        }
        if (this.esp == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112140955", "Missing Exit State Profile"));
        }
        if (this.esmpId == null) {
            if (this.esp.getDefaultEsmpId(systemEnvironment) == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112140957", "Exit State Profile doesn't define a Default Exit State Mapping"));
            }
        } else {
            this.esp.validateMappingProfile(systemEnvironment, this.esmpId);
        }
        if (this.neId == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03203062019", "Environment missing"));
        }
        SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, this.neId);
        Vector<Long> vector = new Vector<Long>();
        vector.add(SDMSObject.publicGId);
        vector.add(this.gId);
        if (sDMSNamedEnvironment.getPrivileges(systemEnvironment, 0x1000000L, false, vector) != 0x1000000L) {
            String string = SDMSGroupTable.getObject(systemEnvironment, this.gId).getName(systemEnvironment);
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131040", "Insufficient privileges of group $1 for environment $2", string, sDMSNamedEnvironment.getName(systemEnvironment)));
        }
        this.getExpectedRuntime = null;
        if (this.timeout != null) {
            this.to_mult = (Integer)this.timeout.get("MULT");
            if (this.to_mult == null) {
                this.to_mult = SDMSConstants.iONE;
            }
            this.to_interval = (Integer)this.timeout.get("INTERVAL");
            this.to_state = (String)this.timeout.get("STATUS");
            this.to_esdId = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.to_state).getId(systemEnvironment);
            if (this.to_esdId != null && !SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, new SDMSKey(this.espId, this.to_esdId))) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311031749", "Timeout state $1 is not contained in profile $2", this.to_state, this.esp.getName(systemEnvironment)));
            }
        }
        if (this.sameNode == null) {
            this.sameNode = Boolean.FALSE;
        }
        if (this.gangSchedule == null) {
            this.gangSchedule = Boolean.FALSE;
        }
        StringReader stringReader = new StringReader(this.runProgram);
        CmdLineScanner cmdLineScanner = new CmdLineScanner(stringReader);
        CmdLineParser cmdLineParser = new CmdLineParser();
        cmdLineParser.set(systemEnvironment, null);
        cmdLineParser.setCheckOnly();
        SDMSMessage sDMSMessage = null;
        try {
            cmdLineParser.yyparse(cmdLineScanner);
        }
        catch (CmdLineParser.yyException yyException2) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03402291355", "Error parsing run command (missing (double) quotes?)");
        }
        catch (IOException iOException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03402291401", "I/O Error parsing run command ($1)", iOException);
        }
        catch (NonRecoverableException nonRecoverableException) {
            sDMSMessage = new SDMSMessage(systemEnvironment, "03402291421", "Error parsing run command (missing quotes?)");
        }
        if (sDMSMessage != null) {
            throw new CommonErrorException(sDMSMessage);
        }
        if (this.rerunProgram != null) {
            stringReader = new StringReader(this.rerunProgram);
            cmdLineScanner = new CmdLineScanner(stringReader);
            cmdLineParser = new CmdLineParser();
            cmdLineParser.set(systemEnvironment, null);
            cmdLineParser.setCheckOnly();
            try {
                cmdLineParser.yyparse(cmdLineScanner);
            }
            catch (CmdLineParser.yyException yyException3) {
                sDMSMessage = new SDMSMessage(systemEnvironment, "03402291507", "Error parsing rerun command (missing (double) quotes?)");
            }
            catch (IOException iOException) {
                sDMSMessage = new SDMSMessage(systemEnvironment, "03402291508", "I/O Error parsing rerun command ($1)", iOException);
            }
            catch (NonRecoverableException nonRecoverableException) {
                sDMSMessage = new SDMSMessage(systemEnvironment, "03402291509", "Error parsing rerun command (missing quotes?)");
            }
            if (sDMSMessage != null) {
                throw new CommonErrorException(sDMSMessage);
            }
        }
    }

    protected void checkBatch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.runProgram = null;
        this.rerunProgram = null;
        this.killProgram = null;
        this.workdir = null;
        this.logfile = null;
        this.errlogfile = null;
        this.truncLog = null;
        this.truncErrlog = null;
        if (this.masterSubmittable == null) {
            this.masterSubmittable = Boolean.FALSE;
        }
        if (this.dependencyOperation == null) {
            this.dependencyOperation = SDMSConstants.SE_AND;
        }
        if (this.priority != null) {
            if (this.priority > 100) {
                this.priority = SDMSConstants.ST_MIN_PRIORITY;
                this.priowarn = true;
            }
            if (this.priority < -100) {
                this.priority = SDMSConstants.ST_MINUS_MIN_PRIORITY;
                this.priowarn = true;
            }
        } else {
            this.priority = SDMSConstants.iZERO;
        }
        this.minPriority = null;
        if (this.submitSuspended == null) {
            this.submitSuspended = Boolean.FALSE;
        }
        if (this.esp == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112140956", "Missing Exit State Profile"));
        }
        this.esmpId = null;
        this.neId = null;
        this.fpId = null;
        this.getExpectedRuntime = null;
        this.resourcedeflist = null;
        this.sameNode = null;
        this.gangSchedule = null;
        this.to_mult = null;
        this.to_interval = null;
        this.to_state = null;
        this.to_esdId = null;
    }

    protected void checkMilestone(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkBatch(systemEnvironment);
        this.masterSubmittable = Boolean.FALSE;
        this.minPriority = null;
        this.resourcedeflist = null;
        this.parameters = null;
    }

    protected String checkChildDependencies(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSKey sDMSKey = new SDMSKey(l, l2);
        if (SDMSDependencyDefinitionTable.idx_DependentId_RequiredId.containsKey(systemEnvironment, sDMSKey)) {
            return l2.toString();
        }
        Vector vector = SDMSSchedulingHierarchyTable.idx_seParentId.getVector(systemEnvironment, l2);
        for (SDMSSchedulingHierarchy sDMSSchedulingHierarchy : vector) {
            String string = this.checkChildDependencies(systemEnvironment, l, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
            if (string == null) continue;
            return sDMSSchedulingHierarchy.getSeParentId(systemEnvironment) + "->" + string;
        }
        return null;
    }

    protected void checkTranslation(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSSchedulingEntity sDMSSchedulingEntity2, SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile) throws SDMSException {
        Vector vector = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, sDMSSchedulingEntity.getEspId(systemEnvironment));
        Iterator iterator = vector.iterator();
        Long l = sDMSSchedulingEntity2.getEspId(systemEnvironment);
        while (iterator.hasNext()) {
            Object object;
            Long l2;
            SDMSExitState sDMSExitState = (SDMSExitState)iterator.next();
            Long l3 = l2 = sDMSExitState.getEsdId(systemEnvironment);
            if (sDMSExitStateTranslationProfile == null || (l3 = sDMSExitStateTranslationProfile.translate(systemEnvironment, l2, false)) == null) continue;
            SDMSKey sDMSKey = new SDMSKey(l, l3);
            if (!SDMSExitStateTable.idx_espId_esdId.containsKey(systemEnvironment, sDMSKey)) {
                object = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), sDMSExitStateTranslationProfile == null ? "NONE" : sDMSExitStateTranslationProfile.getName(systemEnvironment)};
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112201828", "Profile doesn't contain translated child state $1 of $2 Translation $3", (Object[])object));
            }
            object = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, sDMSKey);
            if (!((SDMSExitStateProxyGeneric)object).getIsFinal(systemEnvironment).equals(Boolean.FALSE) || !sDMSExitState.getIsFinal(systemEnvironment).equals(Boolean.TRUE)) continue;
            Object[] objectArray = new Object[]{SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment), sDMSSchedulingEntity.pathString(systemEnvironment), SDMSExitStateDefinitionTable.getObject(systemEnvironment, l3).getName(systemEnvironment), sDMSSchedulingEntity2.pathString(systemEnvironment), sDMSExitStateTranslationProfile == null ? "NONE" : sDMSExitStateTranslationProfile.getName(systemEnvironment)};
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02205061803", "Invalid translation from final child state $1 of $2 to non final state $3 of $4, Translation = [$5]", objectArray));
        }
    }

    public void addOrAlterChild(SystemEnvironment systemEnvironment, WithHash withHash, SDMSSchedulingEntity sDMSSchedulingEntity, boolean bl, boolean bl2) throws SDMSException {
        Serializable serializable;
        SDMSSchedulingHierarchy sDMSSchedulingHierarchy;
        Integer n;
        Object object;
        Object object2;
        Integer n2;
        Boolean bl3 = Boolean.FALSE;
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        WithHash withHash2 = (WithHash)withHash.get("FULLNAME");
        if (withHash2 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112141754", "Missing Child Name"));
        }
        String string = (String)withHash2.get("NAME");
        Vector vector = (Vector)withHash2.get("PATH");
        int n3 = sDMSSchedulingEntity.getType(systemEnvironment);
        Boolean bl4 = (Boolean)withHash.get("STATIC");
        if (bl4 == null) {
            bl4 = n3 == 2 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (withHash.containsKey("ENABLE")) {
            bl3 = (Boolean)withHash.get("ENABLE") == false;
        }
        if (n3 != 2 && n3 != 1 && bl4.equals(Boolean.TRUE)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406071422", "Only batches and Jobs can have static children"));
        }
        Integer n4 = (Integer)withHash.get("PRIORITY");
        if (n4 != null) {
            if (n4 > 100) {
                n4 = SDMSConstants.ST_MIN_PRIORITY;
            }
            if (n4 < -100) {
                n4 = SDMSConstants.ST_MINUS_MIN_PRIORITY;
            }
        } else {
            n4 = SDMSConstants.iZERO;
        }
        if ((n2 = (Integer)withHash.get("SUSPEND")) == null) {
            n2 = SDMSConstants.SH_CHILDSUSPEND;
        }
        String string2 = null;
        Integer n5 = null;
        Integer n6 = null;
        if (n2 == 3 && (object2 = withHash.get("RESUME")) != null) {
            if (object2 instanceof String) {
                string2 = (String)object2;
            } else {
                object = (WithHash)object2;
                n5 = (Integer)((HashMap)object).get("MULT");
                n6 = (Integer)((HashMap)object).get("INTERVAL");
            }
        }
        if ((n = (Integer)withHash.get("MERGE_MODE")) == null) {
            n = SDMSConstants.SH_NOMERGE;
        }
        String string3 = (String)withHash.get("TRANSLATION");
        String string4 = (String)withHash.get("INTERVAL");
        Vector vector2 = (Vector)withHash.get("IGNORE");
        String string5 = (String)withHash.get("ALIAS");
        String string6 = this.canonizeCondition(systemEnvironment, (String)withHash.get("CONDITION"));
        Integer n7 = (Integer)withHash.get("MODE");
        if (n7 == null) {
            n7 = 1;
        }
        if (!((SDMSSchedulingEntityProxyGeneric)(object2 = SDMSSchedulingEntityTable.get(systemEnvironment, vector, string))).checkPrivileges(systemEnvironment, 0x100000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131121", "Execute privilege missing for $1", ((SDMSSchedulingEntity)object2).pathString(systemEnvironment)));
        }
        Long l2 = ((SDMSProxy)object2).getId(systemEnvironment);
        Long l3 = null;
        if (string3 != null) {
            object = null;
            systemEnvironment.checkFeatureAvailability("EXIT_STATE_TRANSLATION");
            object = SDMSExitStateTranslationProfileTable.idx_name_getUnique(systemEnvironment, string3);
            l3 = ((SDMSProxy)object).getId(systemEnvironment);
            this.checkTranslation(systemEnvironment, (SDMSSchedulingEntity)object2, sDMSSchedulingEntity, (SDMSExitStateTranslationProfile)object);
        }
        Long l4 = null;
        if (string4 != null) {
            object = null;
            try {
                object = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), Integer.valueOf(0)));
            }
            catch (NotFoundException notFoundException) {
                object = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string4), null));
            }
            l4 = ((SDMSProxy)object).getId(systemEnvironment);
        }
        if (l.equals(l2)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112201726", "Cannot have itself as child"));
        }
        object = this.checkChildDependencies(systemEnvironment, l, l2);
        if (object != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112202010", "Dependency from children not allowed [$1]", l.toString() + "->" + (String)object));
        }
        if (bl) {
            try {
                sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.table.create(systemEnvironment, l, l2, string5, bl4, bl3, n4, n2, string2, n5, n6, n, l3, l4, string6, n7);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                if (bl2) {
                    sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.idx_parentId_childId_getUnique(systemEnvironment, new SDMSKey(l, l2));
                    sDMSSchedulingHierarchy.setAliasName(systemEnvironment, string5);
                    sDMSSchedulingHierarchy.setIsStatic(systemEnvironment, bl4);
                    sDMSSchedulingHierarchy.setIsDisabled(systemEnvironment, bl3);
                    sDMSSchedulingHierarchy.setPriority(systemEnvironment, n4);
                    sDMSSchedulingHierarchy.setSuspend(systemEnvironment, n2);
                    sDMSSchedulingHierarchy.setResumeAt(systemEnvironment, string2);
                    sDMSSchedulingHierarchy.setResumeIn(systemEnvironment, n5);
                    sDMSSchedulingHierarchy.setResumeBase(systemEnvironment, n6);
                    sDMSSchedulingHierarchy.setMergeMode(systemEnvironment, n);
                    sDMSSchedulingHierarchy.setEstpId(systemEnvironment, l3);
                    sDMSSchedulingHierarchy.setIntId(systemEnvironment, l4);
                    sDMSSchedulingHierarchy.setEnableCondition(systemEnvironment, string6);
                    sDMSSchedulingHierarchy.setEnableMode(systemEnvironment, n7);
                    Vector vector3 = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, sDMSSchedulingHierarchy.getId(systemEnvironment));
                    for (int i = 0; i < vector3.size(); ++i) {
                        ((SDMSIgnoredDependency)vector3.get(i)).delete(systemEnvironment);
                    }
                }
                throw duplicateKeyException;
            }
        } else {
            try {
                sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.idx_parentId_childId_getUnique(systemEnvironment, new SDMSKey(l, l2));
                sDMSSchedulingHierarchy.setAliasName(systemEnvironment, string5);
                sDMSSchedulingHierarchy.setIsStatic(systemEnvironment, bl4);
                sDMSSchedulingHierarchy.setIsDisabled(systemEnvironment, bl3);
                sDMSSchedulingHierarchy.setPriority(systemEnvironment, n4);
                sDMSSchedulingHierarchy.setSuspend(systemEnvironment, n2);
                sDMSSchedulingHierarchy.setResumeAt(systemEnvironment, string2);
                sDMSSchedulingHierarchy.setResumeIn(systemEnvironment, n5);
                sDMSSchedulingHierarchy.setResumeBase(systemEnvironment, n6);
                sDMSSchedulingHierarchy.setMergeMode(systemEnvironment, n);
                sDMSSchedulingHierarchy.setEstpId(systemEnvironment, l3);
                sDMSSchedulingHierarchy.setIntId(systemEnvironment, l4);
                sDMSSchedulingHierarchy.setEnableCondition(systemEnvironment, string6);
                sDMSSchedulingHierarchy.setEnableMode(systemEnvironment, n7);
                serializable = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, sDMSSchedulingHierarchy.getId(systemEnvironment));
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    ((SDMSIgnoredDependency)((Vector)serializable).get(i)).delete(systemEnvironment);
                }
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    return;
                }
                throw notFoundException;
            }
        }
        if (string5 != null && ((Vector)(serializable = SDMSSchedulingHierarchyTable.idx_parentId_aliasName.getVector(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string5))))).size() > 1) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03212051503", "Duplicate Aliasname $1", string5));
        }
        if (vector2 != null) {
            serializable = sDMSSchedulingHierarchy.getId(systemEnvironment);
            for (int i = 0; i < vector2.size(); ++i) {
                String string7 = (String)vector2.get(i);
                SDMSIgnoredDependencyTable.table.create(systemEnvironment, (Long)serializable, string7);
            }
        }
    }

    private void buildResourceList(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        this.resourceList = new HashSet();
        Vector vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
            this.resourceList.add(sDMSResourceRequirement.getNrId(systemEnvironment));
        }
        Long l = sDMSSchedulingEntity.getFpId(systemEnvironment);
        if (l != null) {
            vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(i);
                this.resourceList.add(sDMSResourceRequirement.getNrId(systemEnvironment));
            }
        }
        Long l2 = sDMSSchedulingEntity.getNeId(systemEnvironment);
        vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector.get(i);
            this.resourceList.add(sDMSEnvironment.getNrId(systemEnvironment));
        }
    }

    protected boolean checkResourceRequirement(SystemEnvironment systemEnvironment, Long l, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        if (this.resourceList == null) {
            this.buildResourceList(systemEnvironment, sDMSSchedulingEntity);
        }
        return this.resourceList.contains(l);
    }

    public void addOrAlterParameters(SystemEnvironment systemEnvironment, WithHash withHash, SDMSSchedulingEntity sDMSSchedulingEntity, boolean bl, boolean bl2) throws SDMSException {
        Set set = withHash.keySet();
        for (String string : set) {
            Comparable comparable;
            Object object;
            Vector vector = (Vector)withHash.get(string);
            WithItem withItem = (WithItem)vector.get(0);
            String string2 = (String)vector.get(1);
            Boolean bl3 = (Boolean)vector.get(2);
            String string3 = (String)vector.get(3);
            Long l = (Long)vector.get(4);
            Integer n = withItem == null ? SDMSConstants.PD_PARAMETER : (Integer)withItem.key;
            Integer n2 = SDMSConstants.PD_NONE;
            Long l2 = null;
            switch (n) {
                case 40: 
                case 50: 
                case 70: 
                case 71: {
                    if (string2 == null) break;
                    string2 = "=" + string2;
                    break;
                }
                case 60: {
                    object = (Vector)withItem.value;
                    n2 = (Integer)((Vector)object).get(0);
                    string2 = "=" + (String)((Vector)object).get(1);
                    break;
                }
                case 30: {
                    string2 = "=" + (String)withItem.value;
                    break;
                }
                case 10: 
                case 20: {
                    if (string2 != null) {
                        string2 = "=" + string2;
                    }
                    comparable = (PathVector)withItem.value;
                    String string4 = (String)((Vector)((Object)comparable)).remove(((Vector)((Object)comparable)).size() - 1);
                    Long l3 = SDMSSchedulingEntityTable.get(systemEnvironment, (Vector)((Object)comparable), null).getId(systemEnvironment);
                    SDMSParameterDefinition sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l3, (Comparable)((Object)string4)));
                    if (!sDMSParameterDefinition.getIsLocal(systemEnvironment).booleanValue()) {
                        l2 = sDMSParameterDefinition.getId(systemEnvironment);
                        break;
                    }
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603061409", "A local parameter cannot be referenced"));
                }
                case 91: {
                    if (string2 != null) {
                        string2 = "=" + string2;
                    }
                    PathVector pathVector = (PathVector)withItem.value;
                    String string4 = (String)pathVector.remove(pathVector.size() - 1);
                    Long l4 = SDMSNamedResourceTable.getNamedResource(systemEnvironment, pathVector).getId(systemEnvironment);
                    if (!this.checkResourceRequirement(systemEnvironment, l4, sDMSSchedulingEntity)) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281727", "Resource $2 for parameter $1 not required", string, pathVector));
                    }
                    l2 = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l4, (Comparable)((Object)string4))).getId(systemEnvironment);
                }
            }
            if (bl) {
                try {
                    SDMSParameterDefinitionTable.table.create(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment), string, n, n2, string2, bl3, l2, string3);
                    continue;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    if (bl2) {
                        comparable = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSchedulingEntity.getId(systemEnvironment), (Comparable)((Object)string)));
                        ((SDMSParameterDefinitionProxyGeneric)comparable).setType(systemEnvironment, n);
                        ((SDMSParameterDefinitionProxyGeneric)comparable).setAggFunction(systemEnvironment, n2);
                        ((SDMSParameterDefinition)comparable).setDefaultValue(systemEnvironment, string2);
                        ((SDMSParameterDefinitionProxyGeneric)comparable).setIsLocal(systemEnvironment, bl3);
                        ((SDMSParameterDefinition)comparable).setLinkPdId(systemEnvironment, l2);
                        ((SDMSParameterDefinitionProxyGeneric)comparable).setExportName(systemEnvironment, string3);
                        continue;
                    }
                    throw duplicateKeyException;
                }
            }
            try {
                if (l != 0L) {
                    try {
                        object = SDMSParameterDefinitionTable.getObject(systemEnvironment, l);
                        comparable = ((SDMSParameterDefinitionProxyGeneric)object).getSeId(systemEnvironment);
                        if (!((Long)comparable).equals(sDMSSchedulingEntity.getId(systemEnvironment))) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202161355", "Parameter $1($2) does not belong to job definition $3", ((SDMSParameterDefinitionProxyGeneric)object).getName(systemEnvironment), l, sDMSSchedulingEntity.pathString(systemEnvironment)));
                        }
                        ((SDMSParameterDefinitionProxyGeneric)object).setName(systemEnvironment, string);
                    }
                    catch (NotFoundException notFoundException) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202161351", "Could not find a parameter with ID $1", l));
                    }
                } else {
                    object = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(sDMSSchedulingEntity.getId(systemEnvironment), (Comparable)((Object)string)));
                }
                ((SDMSParameterDefinitionProxyGeneric)object).setType(systemEnvironment, n);
                ((SDMSParameterDefinitionProxyGeneric)object).setAggFunction(systemEnvironment, n2);
                ((SDMSParameterDefinition)object).setDefaultValue(systemEnvironment, string2);
                ((SDMSParameterDefinitionProxyGeneric)object).setIsLocal(systemEnvironment, bl3);
                ((SDMSParameterDefinition)object).setLinkPdId(systemEnvironment, l2);
                ((SDMSParameterDefinitionProxyGeneric)object).setExportName(systemEnvironment, string3);
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    return;
                }
                throw notFoundException;
            }
        }
    }

    public void addOrAlterResource(SystemEnvironment systemEnvironment, WithHash withHash, SDMSSchedulingEntity sDMSSchedulingEntity, boolean bl, boolean bl2) throws SDMSException {
        SDMSResourceRequirement sDMSResourceRequirement;
        Boolean bl3;
        Integer n;
        Integer n2;
        Long l;
        Object object;
        Vector vector;
        String string;
        Boolean bl4;
        Long l2 = sDMSSchedulingEntity.getId(systemEnvironment);
        Vector vector2 = (Vector)withHash.get("NAME");
        if (vector2 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03203140032", "No resourcename specified"));
        }
        Integer n3 = (Integer)withHash.get("AMOUNT");
        Integer n4 = (Integer)withHash.get("LOCKMODE");
        String string2 = (String)withHash.get("MAP_STATUS");
        Integer n5 = (Integer)withHash.get("KEEP");
        WithHash withHash2 = (WithHash)withHash.get("STICKY");
        WithHash withHash3 = (WithHash)withHash.get("EXPIRED");
        String string3 = (String)withHash.get("CONDITION");
        if (string3 != null) {
            string3 = this.canonizeCondition(systemEnvironment, string3);
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector2);
        Long l3 = sDMSNamedResource.getId(systemEnvironment);
        if (n3 == null) {
            n3 = SDMSConstants.iZERO;
        }
        if (n4 == null) {
            n4 = SDMSConstants.RR_N;
        }
        Long l4 = string2 != null ? SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, string2).getId(systemEnvironment) : null;
        if (n5 == null) {
            n5 = SDMSConstants.RR_NOKEEP;
        }
        if (withHash2 != null) {
            bl4 = Boolean.TRUE;
            string = (String)withHash2.get("NAME");
            vector = (PathVector)withHash2.get("JOB_DEFINITION");
            if (vector != null) {
                object = (String)vector.remove(vector.size() - 1);
                try {
                    SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.get(systemEnvironment, vector, (String)object);
                    if (!sDMSSchedulingEntity2.checkPrivileges(systemEnvironment, 0x10000000L)) {
                        throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03309241442", "Insufficient privileges"));
                    }
                    l = sDMSSchedulingEntity2.getId(systemEnvironment);
                }
                catch (NotFoundException notFoundException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309250931", "The specified sticky parent isn't a job definition"));
                }
            } else {
                l = null;
            }
        } else {
            bl4 = Boolean.FALSE;
            string = null;
            l = null;
        }
        if (withHash3 != null) {
            n2 = (Integer)withHash3.get("MULT");
            if (n2 == null) {
                n2 = SDMSConstants.iONE;
            }
            n = (Integer)withHash3.get("INTERVAL");
            bl3 = (Boolean)withHash3.get("IGNORE");
        } else {
            n2 = null;
            n = null;
            bl3 = Boolean.FALSE;
        }
        if (bl) {
            try {
                sDMSResourceRequirement = SDMSResourceRequirementTable.table.create(systemEnvironment, l3, l2, n3, n5, bl4, string, l, l4, n2, n, bl3, n4, string3);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                if (bl2) {
                    sDMSResourceRequirement = this.changeResourceRequirement(systemEnvironment, l2, l3, n3, n5, bl4, string, l, l4, n2, n, bl3, n4, string3);
                }
                throw duplicateKeyException;
            }
        } else {
            try {
                sDMSResourceRequirement = this.changeResourceRequirement(systemEnvironment, l2, l3, n3, n5, bl4, string, l, l4, n2, n, bl3, n4, string3);
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    return;
                }
                throw notFoundException;
            }
        }
        Vector vector3 = (Vector)withHash.get("STATUS");
        vector = new Vector();
        if (vector3 != null) {
            object = sDMSResourceRequirement.getId(systemEnvironment);
            for (int i = 0; i < vector3.size(); ++i) {
                String string4 = (String)vector3.get(i);
                Long l5 = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, string4).getId(systemEnvironment);
                vector.add(l5);
                if (SDMSResourceReqStatesTable.idx_rr_rsd_pk.containsKey(systemEnvironment, new SDMSKey((Comparable)object, l5))) continue;
                SDMSResourceReqStatesTable.table.create(systemEnvironment, (Long)object, l5);
            }
        }
        object = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, sDMSResourceRequirement.getId(systemEnvironment));
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Long l6 = ((SDMSResourceReqStates)((Vector)object).get(i)).getRsdId(systemEnvironment);
            if (vector.contains(l6)) continue;
            ((SDMSResourceReqStates)((Vector)object).get(i)).delete(systemEnvironment);
        }
        sDMSResourceRequirement.check(systemEnvironment);
    }

    private SDMSResourceRequirement changeResourceRequirement(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Boolean bl, String string, Long l3, Long l4, Integer n3, Integer n4, Boolean bl2, Integer n5, String string2) throws SDMSException {
        SDMSResourceRequirement sDMSResourceRequirement = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(l, l2));
        sDMSResourceRequirement.setAmount(systemEnvironment, n);
        sDMSResourceRequirement.setKeepMode(systemEnvironment, n2);
        sDMSResourceRequirement.setIsSticky(systemEnvironment, bl);
        sDMSResourceRequirement.setStickyName(systemEnvironment, string);
        sDMSResourceRequirement.setStickyParent(systemEnvironment, l3);
        sDMSResourceRequirement.setRsmpId(systemEnvironment, l4);
        sDMSResourceRequirement.setExpiredAmount(systemEnvironment, n3);
        sDMSResourceRequirement.setExpiredBase(systemEnvironment, n4);
        sDMSResourceRequirement.setIgnoreOnRerun(systemEnvironment, bl2);
        sDMSResourceRequirement.setLockmode(systemEnvironment, n5);
        sDMSResourceRequirement.setCondition(systemEnvironment, string2);
        return sDMSResourceRequirement;
    }

    public String canonizeCondition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return null;
        }
        BoolExpr boolExpr = new BoolExpr(string);
        boolExpr.checkConditionSyntax(systemEnvironment);
        return string2;
    }

    public void addOrAlterRequirement(SystemEnvironment systemEnvironment, WithHash withHash, SDMSSchedulingEntity sDMSSchedulingEntity, boolean bl, boolean bl2) throws SDMSException {
        Serializable serializable;
        String string;
        SDMSDependencyState sDMSDependencyState;
        Serializable serializable2;
        SDMSDependencyDefinition sDMSDependencyDefinition;
        Object object;
        Vector vector;
        Integer n;
        String string2 = null;
        Integer n2 = 0;
        String string3 = null;
        WithHash withHash2 = (WithHash)withHash.get("FULLNAME");
        if (withHash2 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "0220117156", "Missing Required Name"));
        }
        String string4 = (String)withHash2.get("NAME");
        Vector vector2 = (Vector)withHash2.get("PATH");
        String string5 = (String)withHash.get("DEPENDENCY");
        string2 = this.canonizeCondition(systemEnvironment, (String)withHash.get("CONDITION"));
        if (string2 != null) {
            systemEnvironment.checkFeatureAvailability("CONDITIONAL_DEPENDENCIES");
        }
        if ((n = (Integer)withHash.get("UNRESOLVED")) == null) {
            n = SDMSConstants.DD_ERROR;
        }
        Object v = withHash.get("STATUS");
        Vector<String> vector3 = new Vector<String>();
        Integer n3 = null;
        if (v == null || v instanceof Vector) {
            vector = (Vector)v;
            if (vector != null) {
                object = vector.iterator();
                while (object.hasNext()) {
                    vector3.add((String)((Object)((WithItem)object.next()).key));
                }
            }
            n3 = SDMSConstants.DD_FINAL;
        } else {
            vector = null;
            object = (String)v;
            if (((String)object).equals("DEFAULT")) {
                n3 = SDMSConstants.DD_DEFAULT;
            } else if (((String)object).equals("UNREACHABLE")) {
                n3 = SDMSConstants.DD_UNREACHABLE;
            } else if (((String)object).equals("REACHABLE")) {
                n3 = SDMSConstants.DD_ALL_REACHABLE;
            }
        }
        object = SDMSSchedulingEntityTable.get(systemEnvironment, vector2, string4);
        Long l = ((SDMSProxy)object).getId(systemEnvironment);
        Integer n4 = (Integer)withHash.get("MODE");
        if (n4 == null) {
            n4 = SDMSConstants.DD_ALL_FINAL;
        }
        if ((n2 = (Integer)withHash.get("RESOLVE")) == null) {
            n2 = 0;
        }
        Integer n5 = null;
        Integer n6 = null;
        WithHash withHash3 = (WithHash)withHash.get("EXPIRED");
        if (withHash3 != null) {
            n5 = (Integer)withHash3.get("MULT");
            if (n5 == null) {
                n5 = SDMSConstants.iONE;
            }
            n6 = (Integer)withHash3.get("INTERVAL");
        }
        string3 = this.canonizeCondition(systemEnvironment, (String)withHash.get("SELECT_CONDIION"));
        if (bl) {
            try {
                sDMSDependencyDefinition = SDMSDependencyDefinitionTable.table.create(systemEnvironment, sDMSSchedulingEntity.getId(systemEnvironment), l, string5, n, n4, n3, string2, n2, n5, n6, string3);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                if (bl2) {
                    sDMSDependencyDefinition = SDMSDependencyDefinitionTable.idx_DependentId_RequiredId_getUnique(systemEnvironment, new SDMSKey(sDMSSchedulingEntity.getId(systemEnvironment), l));
                    sDMSDependencyDefinition.setName(systemEnvironment, string5);
                    sDMSDependencyDefinition.setUnresolvedHandling(systemEnvironment, n);
                    sDMSDependencyDefinition.setMode(systemEnvironment, n4);
                    sDMSDependencyDefinition.setStateSelection(systemEnvironment, n3);
                    sDMSDependencyDefinition.setCondition(systemEnvironment, string2);
                    sDMSDependencyDefinition.setResolveMode(systemEnvironment, n2);
                    sDMSDependencyDefinition.setExpiredAmount(systemEnvironment, n5);
                    sDMSDependencyDefinition.setExpiredBase(systemEnvironment, n6);
                    sDMSDependencyDefinition.setSelectCondition(systemEnvironment, string3);
                    serializable2 = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
                    for (int i = 0; i < ((Vector)serializable2).size(); ++i) {
                        sDMSDependencyState = (SDMSDependencyState)((Vector)serializable2).get(i);
                        string = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSDependencyState.getEsdId(systemEnvironment)).getName(systemEnvironment);
                        if (vector3.contains(string)) continue;
                        sDMSDependencyState.delete(systemEnvironment);
                    }
                }
                throw duplicateKeyException;
            }
        } else {
            try {
                sDMSDependencyDefinition = SDMSDependencyDefinitionTable.idx_DependentId_RequiredId_getUnique(systemEnvironment, new SDMSKey(sDMSSchedulingEntity.getId(systemEnvironment), l));
                sDMSDependencyDefinition.setName(systemEnvironment, string5);
                sDMSDependencyDefinition.setUnresolvedHandling(systemEnvironment, n);
                sDMSDependencyDefinition.setMode(systemEnvironment, n4);
                sDMSDependencyDefinition.setStateSelection(systemEnvironment, n3);
                sDMSDependencyDefinition.setCondition(systemEnvironment, string2);
                sDMSDependencyDefinition.setResolveMode(systemEnvironment, n2);
                sDMSDependencyDefinition.setExpiredAmount(systemEnvironment, n5);
                sDMSDependencyDefinition.setExpiredBase(systemEnvironment, n6);
                sDMSDependencyDefinition.setSelectCondition(systemEnvironment, string3);
                serializable = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, sDMSDependencyDefinition.getId(systemEnvironment));
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    sDMSDependencyState = (SDMSDependencyState)((Vector)serializable).get(i);
                    string = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSDependencyState.getEsdId(systemEnvironment)).getName(systemEnvironment);
                    if (vector3.contains(string)) continue;
                    sDMSDependencyState.delete(systemEnvironment);
                }
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    return;
                }
                throw notFoundException;
            }
        }
        if (vector != null) {
            serializable = sDMSDependencyDefinition.getId(systemEnvironment);
            serializable2 = ((SDMSSchedulingEntityProxyGeneric)object).getEspId(systemEnvironment);
            for (WithItem withItem : vector) {
                String string6 = (String)((Object)withItem.key);
                string2 = this.canonizeCondition(systemEnvironment, (String)withItem.value);
                SDMSExitStateDefinition sDMSExitStateDefinition = null;
                try {
                    sDMSExitStateDefinition = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, string6);
                }
                catch (NotFoundException notFoundException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02201171210", "Exit State $1 does not exist", string6));
                }
                SDMSExitState sDMSExitState = null;
                Long l2 = sDMSExitStateDefinition.getId(systemEnvironment);
                try {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)serializable2), l2));
                }
                catch (NotFoundException notFoundException) {
                    SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, (Long)serializable2);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201292036", "Exit State $1 not in Exit State Profile $2 of $3", string6, sDMSExitStateProfile.getName(systemEnvironment), ((SDMSSchedulingEntity)object).pathString(systemEnvironment)));
                }
                if (!sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) {
                    SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, (Long)serializable2);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201292037", "Exit State $1 in Exit State Profile $2 of $3 must be a final state", string6, sDMSExitStateProfile.getName(systemEnvironment), ((SDMSSchedulingEntity)object).pathString(systemEnvironment)));
                }
                if (!SDMSDependencyStateTable.idx_ddId_esdId.containsKey(systemEnvironment, new SDMSKey((Comparable)((Object)serializable), l2))) {
                    SDMSDependencyStateTable.table.create(systemEnvironment, (Long)serializable, l2, string2);
                    continue;
                }
                sDMSDependencyState = SDMSDependencyStateTable.idx_ddId_esdId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)serializable), l2));
                sDMSDependencyState.setCondition(systemEnvironment, string2);
            }
        }
    }

    protected void checkParameterRI(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, l);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSParameterDefinition sDMSParameterDefinition;
            Long l2;
            SDMSParameterDefinition sDMSParameterDefinition2 = (SDMSParameterDefinition)vector.get(i);
            if (sDMSParameterDefinition2.getType(systemEnvironment) != 91 || this.checkResourceRequirement(systemEnvironment, l2 = (sDMSParameterDefinition = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSParameterDefinition2.getLinkPdId(systemEnvironment))).getSeId(systemEnvironment), sDMSSchedulingEntity)) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409291229", "Resource $2 for parameter $1 not required", sDMSParameterDefinition2.getName(systemEnvironment), SDMSNamedResourceTable.getObject(systemEnvironment, l2).pathString(systemEnvironment)));
        }
    }

    @Override
    public abstract void go(SystemEnvironment var1) throws SDMSException;
}

