/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserParameter;
import de.independit.scheduler.server.repository.SDMSUserParameterTable;
import de.independit.scheduler.server.util.CheckSum;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public abstract class ManipUser
extends Node {
    public static final String __version = "@(#) $Id";
    protected String user;
    protected ObjectURL url;
    protected String passwd;
    protected String salt;
    protected Integer method;
    protected String txtPasswd;
    protected Boolean enable;
    protected Long defaultGId;
    protected Vector grouplist;
    protected Vector addlist;
    protected Vector dellist;
    protected WithHash with;
    private boolean withEvaluated = false;
    protected Long publicGId;
    protected Integer connect_type;
    protected Vector userEquiv = null;
    protected static final int MD5LENGTH = 35;

    public ManipUser(ObjectURL objectURL, WithHash withHash) {
        this.with = withHash;
        this.url = objectURL;
        this.user = null;
        this.grouplist = new Vector();
        this.addlist = new Vector();
        this.dellist = new Vector();
        this.method = SDMSConstants.U_SHA256;
    }

    public ManipUser(String string, WithHash withHash) {
        this.with = withHash;
        this.user = string;
        this.url = null;
        this.grouplist = new Vector();
        this.addlist = new Vector();
        this.dellist = new Vector();
        this.method = SDMSConstants.U_SHA256;
    }

    @Override
    public abstract void go(SystemEnvironment var1) throws SDMSException;

    public static String generateSalt() {
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random(System.currentTimeMillis());
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 64; ++i) {
            char c = (char)(random.nextInt(96) + 32);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected void evaluate_with(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        int n;
        Vector vector;
        SDMSGroup sDMSGroup = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"PUBLIC"), SDMSConstants.lZERO));
        this.publicGId = sDMSGroup.getId(systemEnvironment);
        if (this.withEvaluated) {
            return;
        }
        this.passwd = null;
        if (this.with.containsKey("PASSWORD")) {
            this.txtPasswd = (String)this.with.get("PASSWORD");
            this.passwd = this.method == 0 ? CheckSum.mkstr(CheckSum.md5((this.txtPasswd + this.salt).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + this.salt).getBytes()), false);
            this.with.remove("PASSWORD");
        }
        if (this.with.containsKey("RAWPASSWORD")) {
            if (this.passwd == null) {
                vector = (Vector)this.with.get("RAWPASSWORD");
                this.passwd = (String)vector.get(0);
                this.salt = (String)vector.get(1);
                if (this.passwd.length() == 35) {
                    this.method = SDMSConstants.U_MD5;
                }
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04312181625", "Both PASSWORD and RAWPASSWORD are not allowed"));
            }
            this.with.remove("RAWPASSWORD");
        }
        this.enable = !this.with.containsKey("ENABLE") ? Boolean.TRUE : (Boolean)this.with.get("ENABLE");
        if (this.with.containsKey("DEFAULTGROUP")) {
            sDMSGroup = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)this.with.get("DEFAULTGROUP"))), SDMSConstants.lZERO));
            this.defaultGId = sDMSGroup.getId(systemEnvironment);
        } else {
            this.defaultGId = null;
        }
        if (this.defaultGId != null) {
            this.grouplist.add(this.defaultGId);
        }
        if (this.with.containsKey("GROUPLIST")) {
            vector = (Vector)this.with.get("GROUPLIST");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), SDMSConstants.lZERO)).getId(systemEnvironment);
                if (l.equals(this.defaultGId)) continue;
                this.grouplist.add(l);
            }
        }
        this.connect_type = this.with.containsKey("CONNECT") ? (Integer)this.with.get("CONNECT") : SDMSConstants.U_PLAIN;
        if (this.with.containsKey("EQUIVALENT")) {
            this.userEquiv = (Vector)this.with.get("EQUIVALENT");
        }
        if (this.with.containsKey("ADDGROUP")) {
            vector = (Vector)this.with.get("ADDGROUP");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), SDMSConstants.lZERO)).getId(systemEnvironment);
                this.addlist.add(l);
            }
        }
        if (this.with.containsKey("DELGROUP")) {
            vector = (Vector)this.with.get("DELGROUP");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), SDMSConstants.lZERO)).getId(systemEnvironment);
                this.dellist.add(l);
            }
        }
        this.withEvaluated = true;
    }

    public void delParameters(SystemEnvironment systemEnvironment, SDMSUser sDMSUser, Vector vector, boolean bl) throws SDMSException {
        block3: {
            Long l = sDMSUser.getId(systemEnvironment);
            try {
                for (int i = 0; i < vector.size(); ++i) {
                    String string = (String)vector.get(i);
                    SDMSUserParameter sDMSUserParameter = SDMSUserParameterTable.idx_uId_Name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
                    sDMSUserParameter.delete(systemEnvironment);
                }
            }
            catch (NotFoundException notFoundException) {
                if (bl) break block3;
                throw notFoundException;
            }
        }
    }

    public void createParameters(SystemEnvironment systemEnvironment, WithHash withHash, SDMSUser sDMSUser) throws SDMSException {
        Vector vector = SDMSUserParameterTable.idx_uId.getVector(systemEnvironment, sDMSUser.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSUserParameter sDMSUserParameter = (SDMSUserParameter)vector.get(i);
            sDMSUserParameter.delete(systemEnvironment);
        }
        this.addOrAlterParameters(systemEnvironment, withHash, sDMSUser, true, false);
    }

    public void addOrAlterParameters(SystemEnvironment systemEnvironment, WithHash withHash, SDMSUser sDMSUser, boolean bl, boolean bl2) throws SDMSException {
        Long l = sDMSUser.getId(systemEnvironment);
        if (withHash == null) {
            return;
        }
        Set set = withHash.keySet();
        for (String string : set) {
            String string2 = (String)withHash.get(string);
            if (bl) {
                try {
                    SDMSUserParameterTable.table.create(systemEnvironment, sDMSUser.getId(systemEnvironment), string, string2);
                    System.out.println("Createing parameter " + string + " with value '" + string2 + "'");
                    continue;
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    if (bl2) {
                        SDMSUserParameter sDMSUserParameter = SDMSUserParameterTable.idx_uId_Name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
                        sDMSUserParameter.setValue(systemEnvironment, string2);
                        continue;
                    }
                    throw duplicateKeyException;
                }
            }
            try {
                SDMSUserParameter sDMSUserParameter = SDMSUserParameterTable.idx_uId_Name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
                sDMSUserParameter.setValue(systemEnvironment, string2);
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    return;
                }
                throw notFoundException;
            }
        }
    }
}

