/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class MoveJobDefinition
extends Node {
    private ObjectURL url;
    private Vector name2;
    private String newName;

    public MoveJobDefinition(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.name2 = vector;
        this.newName = null;
    }

    public MoveJobDefinition(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = null;
        this.newName = string;
    }

    private void moveJobDefinition(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        String string;
        SDMSFolder sDMSFolder;
        try {
            sDMSFolder = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
            string = sDMSSchedulingEntity.getName(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            string = (String)this.name2.remove(this.name2.size() - 1);
            sDMSFolder = SDMSFolderTable.getFolder(systemEnvironment, this.name2);
        }
        Long l = sDMSFolder.getId(systemEnvironment);
        Long l2 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
        if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "02204160909", "Object with name $1 already exists within $2", string, sDMSFolder.pathString(systemEnvironment)));
        }
        if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03410311345", "Object with name $1 already exists within $2", string, sDMSFolder.pathString(systemEnvironment)));
        }
        sDMSSchedulingEntity.set_FolderIdName(systemEnvironment, l, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202201037", "Job Definition moved"));
    }

    private void renameJobDefinition(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Long l = sDMSSchedulingEntity.getFolderId(systemEnvironment);
        if (SDMSSchedulingEntityTable.idx_folderId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.newName)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03112161101", "Object with name $1 already exists", this.newName));
        }
        if (SDMSFolderTable.idx_parentId_name.containsKey(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.newName)))) {
            throw new DuplicateKeyException(new SDMSMessage(systemEnvironment, "03112161103", "Object with name $1 already exists", this.newName));
        }
        sDMSSchedulingEntity.setName(systemEnvironment, this.newName);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202201038", "Job Definition renamed"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = this.url.resolve(systemEnvironment);
        if (!(sDMSProxy instanceof SDMSSchedulingEntity)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03410311333", "The object $1 is not a scheduling entity", this.url.toString()));
        }
        SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)this.url.resolve(systemEnvironment);
        if (this.newName == null) {
            this.moveJobDefinition(systemEnvironment, sDMSSchedulingEntity);
        } else {
            this.renameJobDefinition(systemEnvironment, sDMSSchedulingEntity);
        }
    }
}

