/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import java.util.Vector;

public class MoveSchedule
extends Node {
    public static final String __version = "@(#) $Id: MoveSchedule.java,v 2.1.2.1 2013/03/14 10:24:41 ronald Exp $";
    private final Vector fromPath;
    private final String fromName;
    private final Vector target;
    private final String newName;

    public MoveSchedule(Vector vector, String string, Vector vector2) {
        this.fromPath = vector;
        this.fromName = string;
        this.target = vector2;
        this.newName = null;
    }

    public MoveSchedule(Vector vector, String string, String string2) {
        this.fromPath = vector;
        this.fromName = string;
        this.target = null;
        this.newName = string2;
    }

    private void moveSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        String string;
        SDMSSchedule sDMSSchedule;
        try {
            sDMSSchedule = SDMSScheduleTable.getSchedule(systemEnvironment, this.target);
            string = this.fromName;
        }
        catch (NotFoundException notFoundException) {
            string = (String)this.target.remove(this.target.size() - 1);
            sDMSSchedule = SDMSScheduleTable.getSchedule(systemEnvironment, this.target);
        }
        Long l2 = sDMSSchedule.getId(systemEnvironment);
        Long l3 = SDMSScheduleTable.getSchedule(systemEnvironment, this.fromPath).getId(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(l3, (Comparable)((Object)this.fromName));
        SDMSSchedule sDMSSchedule2 = SDMSScheduleTable.idx_parentId_name_getUnique(systemEnvironment, sDMSKey);
        Long l4 = sDMSSchedule2.getId(systemEnvironment);
        if (l2.equals(l4)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207252320", "A Schedule cannot be moved below itself"));
        }
        while ((l = sDMSSchedule.getParentId(systemEnvironment)) != null) {
            if (l.equals(l4)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04207252324", "A Schedule cannot be moved below itself"));
            }
            sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
        }
        sDMSSchedule2.set_ParentIdName(systemEnvironment, l2, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207251911", "Schedule moved"));
    }

    private void renameSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = SDMSScheduleTable.getSchedule(systemEnvironment, this.fromPath).getId(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(l, (Comparable)((Object)this.fromName));
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.idx_parentId_name_getUnique(systemEnvironment, sDMSKey);
        sDMSSchedule.setName(systemEnvironment, this.newName);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112161244", "Schedule renamed"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.newName == null) {
            this.moveSchedule(systemEnvironment);
        } else {
            this.renameSchedule(systemEnvironment);
        }
    }
}

