/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;

public class RenameGroup
extends Node {
    public static final String __version = "@(#) $Id: RenameGroup.java,v 2.1.14.1 2013/03/14 10:24:44 ronald Exp $";
    private ObjectURL url;
    private String name2;

    public RenameGroup(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSGroup sDMSGroup = (SDMSGroup)this.url.resolve(systemEnvironment);
        try {
            sDMSGroup.setName(systemEnvironment, this.name2);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            sDMSGroup = SDMSGroupTable.idx_name_getUnique(systemEnvironment, this.name2);
            if (sDMSGroup.getDeleteVersion(systemEnvironment) == 0L) {
                throw duplicateKeyException;
            }
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402191848", "A group with the same name previously existed"));
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03312091436", "Group renamed"));
    }
}

